/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.JellyVersion;
import org.netbeans.jellytools.MainWindowOperator;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.OutlineNode;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.input.KeyRobotDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.actions.SystemAction;

public class Action {
    public static final int MENU_MODE = 0;
    public static final int POPUP_MODE = 1;
    public static final int API_MODE = 2;
    public static final int SHORTCUT_MODE = 3;
    protected static final long SELECTION_WAIT_TIME = 300L;
    protected static final long AFTER_ACTION_WAIT_TIME = 0L;
    protected static final long WAIT_AFTER_SHORTCUT_TIMEOUT = 0L;
    private static final int[][] sequence = new int[][]{{0, 1, 3, 2}, {1, 0, 3, 2}, {2, 1, 0, 3}, {3, 1, 0, 2}};
    protected String menuPath;
    protected String popupPath;
    protected Class systemActionClass;
    protected String layerInstancePath;
    protected KeyStroke[] keystrokes;
    private static Operator.StringComparator defaultComparator;
    private Operator.StringComparator comparator;

    public Action(String string, String string2) {
        this(string, string2, null, (KeyStroke[])null);
    }

    public Action(String string, String string2, String string3) {
        this(string, string2, string3, (KeyStroke[])null);
    }

    @Deprecated
    public Action(String string, String string2, Shortcut[] shortcutArray) {
        this(string, string2, null, shortcutArray);
    }

    @Deprecated
    public Action(String string, String string2, Shortcut shortcut) {
        this(string, string2, null, new Shortcut[]{shortcut});
    }

    @Deprecated
    public Action(String string, String string2, String string3, Shortcut[] shortcutArray) {
        this(string, string2, string3, Action.convertShortcuts(shortcutArray));
    }

    private static KeyStroke[] convertShortcuts(Shortcut[] shortcutArray) {
        KeyStroke[] keyStrokeArray = null;
        if (shortcutArray != null) {
            keyStrokeArray = new KeyStroke[shortcutArray.length];
            for (int i = 0; i < shortcutArray.length; ++i) {
                keyStrokeArray[i] = KeyStroke.getKeyStroke(shortcutArray[i].getKeyCode(), shortcutArray[i].getKeyModifiers());
            }
        }
        return keyStrokeArray;
    }

    @Deprecated
    public Action(String string, String string2, String string3, Shortcut shortcut) {
        this(string, string2, string3, new Shortcut[]{shortcut});
    }

    public Action(String string, String string2, KeyStroke keyStroke) {
        this(string, string2, null, keyStroke);
    }

    public Action(String string, String string2, KeyStroke[] keyStrokeArray) {
        this(string, string2, null, keyStrokeArray);
    }

    public Action(String string, String string2, String string3, KeyStroke keyStroke) {
        this(string, string2, string3, new KeyStroke[]{keyStroke});
    }

    public Action(String string, String string2, String string3, KeyStroke[] keyStrokeArray) {
        this.menuPath = string;
        this.popupPath = string2;
        if (string3 == null) {
            this.systemActionClass = null;
        } else if (string3.endsWith(".instance")) {
            this.layerInstancePath = string3;
        } else {
            try {
                this.systemActionClass = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    this.systemActionClass = Class.forName(string3, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    this.systemActionClass = null;
                }
            }
        }
        if (keyStrokeArray != null) {
            this.keystrokes = (KeyStroke[])keyStrokeArray.clone();
        }
    }

    private void perform(int n) {
        switch (n) {
            case 1: {
                this.performPopup();
                break;
            }
            case 0: {
                this.performMenu();
                break;
            }
            case 2: {
                this.performAPI();
                break;
            }
            case 3: {
                this.performShortcut();
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    private void perform(Node node, int n) {
        switch (n) {
            case 1: {
                this.performPopup(node);
                break;
            }
            case 0: {
                this.performMenu(node);
                break;
            }
            case 2: {
                this.performAPI(node);
                break;
            }
            case 3: {
                this.performShortcut(node);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    private void perform(Node[] nodeArray, int n) {
        switch (n) {
            case 1: {
                this.performPopup(nodeArray);
                break;
            }
            case 0: {
                this.performMenu(nodeArray);
                break;
            }
            case 2: {
                this.performAPI(nodeArray);
                break;
            }
            case 3: {
                this.performShortcut(nodeArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    private void perform(OutlineNode outlineNode, int n) {
        switch (n) {
            case 1: {
                this.performPopup(outlineNode);
                break;
            }
            case 0: {
                this.performMenu(outlineNode);
                break;
            }
            case 2: {
                this.performAPI(outlineNode);
                break;
            }
            case 3: {
                this.performShortcut(outlineNode);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    private void perform(ComponentOperator componentOperator, int n) {
        switch (n) {
            case 1: {
                this.performPopup(componentOperator);
                break;
            }
            case 0: {
                this.performMenu(componentOperator);
                break;
            }
            case 2: {
                this.performAPI(componentOperator);
                break;
            }
            case 3: {
                this.performShortcut(componentOperator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong Action.MODE");
            }
        }
    }

    public void perform() {
        int[] nArray = sequence[this.getDefaultMode()];
        for (int i = 0; i < nArray.length; ++i) {
            try {
                this.perform(nArray[i]);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
        }
    }

    public void perform(Node node) {
        int[] nArray = sequence[this.getDefaultMode()];
        for (int i = 0; i < nArray.length; ++i) {
            try {
                this.perform(node, nArray[i]);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
        }
    }

    public void perform(Node[] nodeArray) {
        int[] nArray = sequence[this.getDefaultMode()];
        for (int i = 0; i < nArray.length; ++i) {
            try {
                this.perform(nodeArray, nArray[i]);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
        }
    }

    public void perform(OutlineNode outlineNode) {
        int[] nArray = sequence[this.getDefaultMode()];
        for (int i = 0; i < nArray.length; ++i) {
            try {
                this.perform(outlineNode, nArray[i]);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
        }
    }

    public void perform(ComponentOperator componentOperator) {
        int[] nArray = sequence[this.getDefaultMode()];
        for (int i = 0; i < nArray.length; ++i) {
            try {
                this.perform(componentOperator, nArray[i]);
                return;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                continue;
            }
        }
    }

    public void performMenu() {
        if (this.menuPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define menu path");
        }
        new EventTool().waitNoEvent(500L);
        MainWindowOperator.getDefault().menuBar().pushMenu(this.menuPath, "|", this.getComparator());
        try {
            Thread.sleep(0L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
    }

    public void performMenu(Node node) {
        this.performMenu(new Node[]{node});
    }

    public void performMenu(Node[] nodeArray) {
        if (this.menuPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define menu path");
        }
        this.testNodes(nodeArray);
        nodeArray[0].select();
        for (int i = 1; i < nodeArray.length; ++i) {
            nodeArray[i].addSelectionPath();
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
        this.performMenu();
    }

    public void performMenu(OutlineNode outlineNode) {
        if (this.menuPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define menu path");
        }
        outlineNode.select();
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
        this.performMenu();
    }

    public void performMenu(ComponentOperator componentOperator) {
        componentOperator.getFocus();
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
        this.performMenu();
    }

    public void performPopup() {
        throw new UnsupportedOperationException(this.getClass().toString() + " does not implement performPopup()");
    }

    public void performPopup(Node node) {
        this.performPopup(new Node[]{node});
    }

    public void performPopup(Node[] nodeArray) {
        this.callPopup(nodeArray).pushMenu(this.popupPath, "|", this.getComparator());
        try {
            Thread.sleep(0L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
    }

    public void performPopup(OutlineNode outlineNode) {
        if (this.popupPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define popup path");
        }
        outlineNode.callPopup().pushMenu(this.popupPath, "|", this.getComparator());
        try {
            Thread.sleep(0L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
    }

    JPopupMenuOperator callPopup(Node[] nodeArray) {
        JPopupMenuOperator jPopupMenuOperator;
        if (this.popupPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define popup path");
        }
        this.testNodes(nodeArray);
        Operator.ComponentVisualizer componentVisualizer = nodeArray[0].tree().getVisualizer();
        Operator.ComponentVisualizer componentVisualizer2 = null;
        if (componentVisualizer instanceof EmptyVisualizer) {
            componentVisualizer2 = Operator.getDefaultComponentVisualizer();
            Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)componentVisualizer);
        }
        new EventTool().waitNoEvent(500L);
        TreePath[] treePathArray = new TreePath[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            treePathArray[i] = nodeArray[i].getTreePath();
        }
        try {
            jPopupMenuOperator = new JPopupMenuOperator(nodeArray[0].tree().callPopupOnPaths(treePathArray));
        }
        catch (JTreeOperator.NoSuchPathException noSuchPathException) {
            for (int i = 0; i < nodeArray.length; ++i) {
                treePathArray[i] = nodeArray[i].getTreePath();
            }
            jPopupMenuOperator = new JPopupMenuOperator(nodeArray[0].tree().callPopupOnPaths(treePathArray));
        }
        if (componentVisualizer2 != null) {
            Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)componentVisualizer2);
        }
        jPopupMenuOperator.setComparator(this.getComparator());
        return jPopupMenuOperator;
    }

    public void performPopup(ComponentOperator componentOperator) {
        if (this.popupPath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define popup path");
        }
        new EventTool().waitNoEvent(500L);
        componentOperator.clickForPopup();
        new JPopupMenuOperator((Operator)componentOperator).pushMenu(this.popupPath, "|", this.getComparator());
        try {
            Thread.sleep(0L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
    }

    public void performAPI() {
        if (this.systemActionClass == null && this.layerInstancePath == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not support API call.");
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (Action.this.layerInstancePath != null) {
                        try {
                            FileObject fileObject = FileUtil.getConfigFile((String)Action.this.layerInstancePath);
                            DataObject dataObject = DataObject.find((FileObject)fileObject);
                            javax.swing.Action action = (javax.swing.Action)((InstanceCookie)dataObject).instanceCreate();
                            action.actionPerformed(new ActionEvent(new Container(), 0, null));
                        }
                        catch (Exception exception) {
                            throw new JemmyException("Cannot perform declaratively defined action  \"" + Action.this.layerInstancePath + "\".", (Throwable)exception);
                        }
                    } else if (SystemAction.class.isAssignableFrom(Action.this.systemActionClass)) {
                        SystemAction.get((Class)Action.this.systemActionClass).actionPerformed(new ActionEvent(new Container(), 0, null));
                    } else if (javax.swing.Action.class.isAssignableFrom(Action.this.systemActionClass)) {
                        try {
                            ((javax.swing.Action)Action.this.systemActionClass.newInstance()).actionPerformed(new ActionEvent(new Container(), 0, null));
                        }
                        catch (Exception exception) {
                            throw new JemmyException("Exception when trying to create instance of action \"" + Action.this.systemActionClass.getName() + "\".", (Throwable)exception);
                        }
                    } else if (ActionListener.class.isAssignableFrom(Action.this.systemActionClass)) {
                        try {
                            ((ActionListener)Action.this.systemActionClass.newInstance()).actionPerformed(new ActionEvent(new Container(), 0, null));
                        }
                        catch (Exception exception) {
                            throw new JemmyException("Exception when trying to create instance of action \"" + Action.this.systemActionClass.getName() + "\".", (Throwable)exception);
                        }
                    } else {
                        throw new JemmyException("Cannot create instance of action \"" + Action.this.systemActionClass.getName() + "\".");
                    }
                }
            });
            Thread.sleep(0L);
        }
        catch (Exception exception) {
            throw new JemmyException("API call failed.", (Throwable)exception);
        }
    }

    public void performAPI(Node node) {
        this.performAPI(new Node[]{node});
    }

    public void performAPI(Node[] nodeArray) {
        int n;
        if (this.systemActionClass == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define SystemAction");
        }
        this.testNodes(nodeArray);
        nodeArray[0].select();
        for (n = 1; n < nodeArray.length; ++n) {
            nodeArray[n].addSelectionPath();
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
        n = nodeArray[0].tree().getSelectionCount();
        if (n != nodeArray.length) {
            nodeArray[0].select();
            for (int i = 1; i < nodeArray.length; ++i) {
                nodeArray[i].addSelectionPath();
            }
        }
        this.performAPI();
    }

    public void performAPI(OutlineNode outlineNode) {
        if (this.systemActionClass == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define SystemAction");
        }
        outlineNode.select();
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
        this.performAPI();
    }

    public void performAPI(ComponentOperator componentOperator) {
        componentOperator.getFocus();
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
        this.performAPI();
    }

    public void performShortcut() {
        KeyStroke[] keyStrokeArray = this.getKeyStrokes();
        if (keyStrokeArray == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define shortcut");
        }
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            new KeyRobotDriver(null).pushKey(null, keyStrokeArray[i].getKeyCode(), keyStrokeArray[i].getModifiers(), JemmyProperties.getCurrentTimeouts().create("ComponentOperator.PushKeyTimeout"));
            JemmyProperties.getProperties().getTimeouts().sleep("Action.WaitAfterShortcutTimeout");
        }
        try {
            Thread.sleep(0L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
    }

    public void performShortcut(Node node) {
        this.performShortcut(new Node[]{node});
    }

    public void performShortcut(Node[] nodeArray) {
        KeyStroke[] keyStrokeArray = this.getKeyStrokes();
        if (keyStrokeArray == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define shortcut");
        }
        this.testNodes(nodeArray);
        nodeArray[0].select();
        for (int i = 1; i < nodeArray.length; ++i) {
            nodeArray[i].addSelectionPath();
        }
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
        this.performShortcut();
    }

    public void performShortcut(OutlineNode outlineNode) {
        KeyStroke[] keyStrokeArray = this.getKeyStrokes();
        if (keyStrokeArray == null) {
            throw new UnsupportedOperationException(this.getClass().toString() + " does not define shortcut");
        }
        outlineNode.select();
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
        this.performShortcut();
    }

    public void performShortcut(ComponentOperator componentOperator) {
        componentOperator.getFocus();
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
        this.performShortcut();
    }

    protected void testNodes(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            throw new IllegalArgumentException("argument nodes is null or empty");
        }
        Component component = nodeArray[0].tree().getSource();
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i] == null) {
                throw new IllegalArgumentException("argument nodes contains null value");
            }
            if (component.equals(nodeArray[i].tree().getSource())) continue;
            throw new IllegalArgumentException(nodeArray[i].toString() + " is from different tree");
        }
    }

    public int getDefaultMode() {
        int n = (Integer)JemmyProperties.getCurrentProperty((String)"Action.DefaultMode");
        if (n < 0 || n > 3) {
            return 1;
        }
        return n;
    }

    public int setDefaultMode(int n) {
        int n2 = (Integer)JemmyProperties.getCurrentProperty((String)"Action.DefaultMode");
        if (n < 0 || n > 3) {
            n = 1;
        }
        JemmyProperties.setCurrentProperty((String)"Action.DefaultMode", (Object)n);
        return n2;
    }

    public void setComparator(Operator.StringComparator stringComparator) {
        this.comparator = stringComparator;
    }

    public Operator.StringComparator getComparator() {
        if (this.comparator == null) {
            this.comparator = defaultComparator;
        }
        return this.comparator;
    }

    public String getPopupPath() {
        return this.popupPath;
    }

    public String getMenuPath() {
        return this.menuPath;
    }

    public Class getSystemActionClass() {
        return this.systemActionClass;
    }

    public KeyStroke[] getKeyStrokes() {
        if (this.keystrokes != null) {
            return (KeyStroke[])this.keystrokes.clone();
        }
        return null;
    }

    public boolean isEnabled() {
        if (this.systemActionClass != null) {
            return SystemAction.get((Class)this.systemActionClass).isEnabled();
        }
        if (this.menuPath != null) {
            return MainWindowOperator.getDefault().menuBar().showMenuItem(this.menuPath, "|", this.getComparator()).isEnabled();
        }
        throw new UnsupportedOperationException("Cannot detect if " + this.getClass().getName() + " is enabled.");
    }

    public boolean isEnabled(Node[] nodeArray) {
        this.testNodes(nodeArray);
        if (this.systemActionClass != null) {
            nodeArray[0].select();
            for (int i = 1; i < nodeArray.length; ++i) {
                nodeArray[i].addSelectionPath();
            }
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                throw new JemmyException("Sleeping interrupted", (Throwable)exception);
            }
            return SystemAction.get((Class)this.systemActionClass).isEnabled();
        }
        if (this.popupPath != null) {
            TreePath[] treePathArray = new TreePath[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                treePathArray[i] = nodeArray[i].getTreePath();
            }
            Operator.ComponentVisualizer componentVisualizer = nodeArray[0].tree().getVisualizer();
            Operator.ComponentVisualizer componentVisualizer2 = null;
            if (componentVisualizer instanceof EmptyVisualizer) {
                componentVisualizer2 = Operator.getDefaultComponentVisualizer();
                Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)componentVisualizer);
            }
            new EventTool().waitNoEvent(500L);
            JPopupMenuOperator jPopupMenuOperator = new JPopupMenuOperator(nodeArray[0].tree().callPopupOnPaths(treePathArray));
            if (componentVisualizer2 != null) {
                Operator.setDefaultComponentVisualizer((Operator.ComponentVisualizer)componentVisualizer2);
            }
            boolean bl = jPopupMenuOperator.showMenuItem(this.popupPath, "|", this.getComparator()).isEnabled();
            jPopupMenuOperator.setVisible(false);
            return bl;
        }
        throw new UnsupportedOperationException("Cannot detect if " + this.getClass().getName() + " is enabled.");
    }

    public boolean isEnabled(Node node) {
        return this.isEnabled(new Node[]{node});
    }

    public boolean isEnabled(ComponentOperator componentOperator) {
        componentOperator.makeComponentVisible();
        componentOperator.getFocus();
        if (this.systemActionClass != null) {
            return SystemAction.get((Class)this.systemActionClass).isEnabled();
        }
        if (this.popupPath != null) {
            new EventTool().waitNoEvent(500L);
            componentOperator.clickForPopup();
            return new JPopupMenuOperator((Operator)componentOperator).showMenuItem(this.popupPath, "|", this.getComparator()).isEnabled();
        }
        if (this.menuPath != null) {
            return MainWindowOperator.getDefault().menuBar().showMenuItem(this.menuPath, "|", this.getComparator()).isEnabled();
        }
        throw new UnsupportedOperationException("Cannot detect if " + this.getClass().getName() + " is enabled.");
    }

    static {
        JellyVersion.checkJemmyVersion();
        if (JemmyProperties.getCurrentProperty((String)"Action.DefaultMode") == null) {
            JemmyProperties.setCurrentProperty((String)"Action.DefaultMode", (Object)1);
        }
        Timeouts.initDefault((String)"Action.WaitAfterShortcutTimeout", (long)0L);
        boolean bl = !Operator.getDefaultStringComparator().equals("abc", "a");
        defaultComparator = new Operator.DefaultStringComparator(bl, true);
    }

    @Deprecated
    public static class Shortcut {
        protected int keyCode;
        protected int keyModifiers;

        public Shortcut(int n) {
            this(n, 0);
        }

        public Shortcut(int n, int n2) {
            this.keyCode = n;
            this.keyModifiers = n2;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public int getKeyModifiers() {
            return this.keyModifiers;
        }

        public String toString() {
            String string = KeyEvent.getKeyModifiersText(this.getKeyModifiers());
            return string + (string.length() > 0 ? "+" : "") + KeyEvent.getKeyText(this.getKeyCode());
        }
    }
}

