/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.awt.EventQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.junit.Ignore;
import org.netbeans.insane.live.LiveReferences;
import org.netbeans.insane.live.Path;
import org.netbeans.insane.scanner.CountingVisitor;
import org.netbeans.insane.scanner.ScannerUtils;
import org.netbeans.insane.scanner.Visitor;
import org.netbeans.junit.AssertionFailedErrorException;
import org.netbeans.junit.AssertionFileFailedError;
import org.netbeans.junit.AssertionKnownBugError;
import org.netbeans.junit.Filter;
import org.netbeans.junit.Log;
import org.netbeans.junit.Manager;
import org.netbeans.junit.MemoryFilter;
import org.netbeans.junit.MethodOrder;
import org.netbeans.junit.NbTest;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.RandomlyFails;
import org.netbeans.junit.diff.Diff;
import org.netbeans.junit.internal.MemoryPreferencesFactory;
import org.netbeans.junit.internal.NbModuleLogHandler;

public abstract class NbTestCase
extends TestCase
implements NbTest {
    private Filter filter;
    private long time;
    private String workDirPath;
    private static final long vmDeadline;
    private static ThreadLocal<Boolean> DEFAULT_TIME_OUT_CALLED;
    private static Set<String> usedPaths;
    private String lastTestMethod = null;
    private final Map<String, PrintStream> logStreamTable = new HashMap<String, PrintStream>();
    PrintStream systemOutPSWrapper = new PrintStream(System.out);
    private static final int radix = 16;

    public NbTestCase(String string) {
        super(string);
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public String getExpectedFail() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getExpectedFail(this.getName());
    }

    @Override
    public boolean canRun() {
        if (this.getClass().isAnnotationPresent(Ignore.class)) {
            String string = this.getClass().getAnnotation(Ignore.class).value();
            System.err.println("Skipping " + this.getClass().getName() + (string.isEmpty() ? "" : ": " + string));
            return false;
        }
        try {
            if (this.getClass().getMethod(this.getName(), new Class[0]).isAnnotationPresent(Ignore.class)) {
                String string = this.getClass().getMethod(this.getName(), new Class[0]).getAnnotation(Ignore.class).value();
                System.err.println("Skipping " + this.getClass().getName() + "." + this.getName() + (string.isEmpty() ? "" : ": " + string));
                return false;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (NbTestSuite.ignoreRandomFailures()) {
            if (this.getClass().isAnnotationPresent(RandomlyFails.class)) {
                System.err.println("Skipping " + this.getClass().getName());
                return false;
            }
            try {
                if (this.getClass().getMethod(this.getName(), new Class[0]).isAnnotationPresent(RandomlyFails.class)) {
                    System.err.println("Skipping " + this.getClass().getName() + "." + this.getName());
                    return false;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (null == this.filter) {
            return true;
        }
        boolean bl = this.filter.isIncluded(this.getName());
        return bl;
    }

    protected boolean runInEQ() {
        return false;
    }

    protected int timeOut() {
        DEFAULT_TIME_OUT_CALLED.set(true);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeTimeOut() {
        int n;
        if (vmDeadline == -1L) {
            return 0;
        }
        Boolean bl = DEFAULT_TIME_OUT_CALLED.get();
        try {
            DEFAULT_TIME_OUT_CALLED.set(null);
            n = this.timeOut();
            if (!Boolean.TRUE.equals(DEFAULT_TIME_OUT_CALLED.get())) {
                int n2 = n;
                return n2;
            }
        }
        finally {
            DEFAULT_TIME_OUT_CALLED.set(bl);
        }
        n = (int)(vmDeadline - System.currentTimeMillis());
        if (n > 1500) {
            return (n - 1000) / 2;
        }
        return 1500;
    }

    protected Level logLevel() {
        return null;
    }

    protected String logRoot() {
        return "";
    }

    public void run(TestResult testResult) {
        if (this.canRun()) {
            System.setProperty("netbeans.full.hack", "true");
            System.setProperty("java.util.prefs.PreferencesFactory", MemoryPreferencesFactory.class.getName());
            try {
                Preferences.userRoot().sync();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            Level level = this.logLevel();
            if (level != null) {
                Log.configure(level, this.logRoot(), this);
            }
            super.run(testResult);
        }
    }

    private static StringBuilder printThreadInfo(ThreadInfo threadInfo, StringBuilder stringBuilder) {
        NbTestCase.printThread(threadInfo, stringBuilder);
        StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
        MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            stringBuilder.append("\t at " + stackTraceElement.toString()).append("\n");
            for (MonitorInfo monitorInfo : monitorInfoArray) {
                if (monitorInfo.getLockedStackDepth() != i) continue;
                stringBuilder.append("\t  - locked " + monitorInfo).append("\n");
            }
        }
        stringBuilder.append("\n");
        return stringBuilder;
    }

    private static StringBuilder printThread(ThreadInfo threadInfo, StringBuilder stringBuilder) {
        stringBuilder.append("\"" + threadInfo.getThreadName() + "\" Id=" + threadInfo.getThreadId() + " in " + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null) {
            stringBuilder.append(" waiting on lock=" + threadInfo.getLockName());
        }
        if (threadInfo.isSuspended()) {
            stringBuilder.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            stringBuilder.append(" (running in native)");
        }
        stringBuilder.append("\n");
        if (threadInfo.getLockOwnerName() != null) {
            stringBuilder.append("\t owned by " + threadInfo.getLockOwnerName() + " Id=" + threadInfo.getLockOwnerId()).append("\n");
        }
        return stringBuilder;
    }

    private static void printMonitorInfo(ThreadInfo threadInfo, MonitorInfo[] monitorInfoArray, StringBuilder stringBuilder) {
        stringBuilder.append("\tLocked monitors: count = " + monitorInfoArray.length).append("\n");
        for (MonitorInfo monitorInfo : monitorInfoArray) {
            stringBuilder.append("\t  - " + monitorInfo + " locked at ").append("\n");
            stringBuilder.append("\t      " + monitorInfo.getLockedStackDepth() + " " + monitorInfo.getLockedStackFrame()).append("\n");
        }
    }

    private static void printLockInfo(LockInfo[] lockInfoArray, StringBuilder stringBuilder) {
        stringBuilder.append("\tLocked synchronizers: count = " + lockInfoArray.length).append("\n");
        for (LockInfo lockInfo : lockInfoArray) {
            stringBuilder.append("\t  - " + lockInfo).append("\n");
        }
        stringBuilder.append("\n");
    }

    private static String threadDump() {
        StringBuilder stringBuilder;
        block4: {
            ThreadInfo[] threadInfoArray;
            long[] lArray;
            ThreadMXBean threadMXBean;
            block3: {
                ThreadInfo[] threadInfoArray2;
                threadMXBean = ManagementFactory.getPlatformMXBean(ThreadMXBean.class);
                ThreadInfo[] threadInfoArray22 = threadMXBean.dumpAllThreads(threadMXBean.isSynchronizerUsageSupported(), threadMXBean.isObjectMonitorUsageSupported());
                stringBuilder = new StringBuilder();
                for (ThreadInfo threadInfo : threadInfoArray22) {
                    NbTestCase.printThreadInfo(threadInfo, stringBuilder);
                }
                long[] lArray2 = threadMXBean.isSynchronizerUsageSupported() ? threadMXBean.findDeadlockedThreads() : null;
                lArray = threadMXBean.findMonitorDeadlockedThreads();
                if (lArray2 == null) break block3;
                stringBuilder.append("\n================\nDead-locked threads:\n");
                for (ThreadInfo threadInfo : threadInfoArray2 = threadMXBean.getThreadInfo(lArray2, true, threadMXBean.isObjectMonitorUsageSupported())) {
                    NbTestCase.printThreadInfo(threadInfo, stringBuilder);
                    NbTestCase.printLockInfo(threadInfo.getLockedSynchronizers(), stringBuilder);
                    stringBuilder.append("\n");
                }
                break block4;
            }
            if (lArray == null) break block4;
            for (ThreadInfo threadInfo : threadInfoArray = threadMXBean.getThreadInfo(lArray, Integer.MAX_VALUE)) {
                NbTestCase.printThread(threadInfo, stringBuilder);
                NbTestCase.printMonitorInfo(threadInfo, threadInfo.getLockedMonitors(), stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    public void runBare() throws Throwable {
        block11: {
            block10: {
                abstract class Guard
                implements Runnable {
                    private boolean finished;
                    private Throwable t;

                    Guard() {
                    }

                    public abstract void doSomething() throws Throwable;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            this.doSomething();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            if (MethodOrder.isShuffled()) {
                                throwable2 = Log.wrapWithAddendum(throwable, "(executed in shuffle mode, run with -DNbTestCase.order=" + MethodOrder.getSeed() + " to reproduce the order)", true);
                            }
                            this.t = Log.wrapWithMessages(throwable2, NbTestCase.this.getWorkDirPath());
                        }
                        finally {
                            Guard guard = this;
                            synchronized (guard) {
                                this.finished = true;
                                this.notifyAll();
                            }
                        }
                    }

                    public synchronized void waitFinished() throws Throwable {
                        this.waitFinished(0);
                    }

                    public synchronized void waitFinished(int n) throws Throwable {
                        long l = n;
                        long l2 = System.currentTimeMillis();
                        while (!this.finished) {
                            try {
                                this.wait(l);
                                if (n <= 0 || (l = (long)n - (System.currentTimeMillis() - l2)) >= 1L) continue;
                                break;
                            }
                            catch (InterruptedException interruptedException) {
                                if (this.t != null) continue;
                                this.t = interruptedException;
                            }
                        }
                        if (this.t != null) {
                            throw this.t;
                        }
                        if (!this.finished) {
                            throw Log.wrapWithMessages(new AssertionFailedError("The test " + NbTestCase.this.getName() + " did not finish in " + n + "ms\n" + NbTestCase.threadDump()), NbTestCase.this.getWorkDirPath());
                        }
                    }
                }
                Guard guard;
                if (this.runInEQ()) {
                    guard = new Guard(){
                        {
                        }

                        @Override
                        public void doSomething() throws Throwable {
                            NbTestCase.this.setUp();
                        }
                    };
                    EventQueue.invokeLater(guard);
                    guard.waitFinished(this.computeTimeOut());
                } else {
                    this.setUp();
                }
                try {
                    guard = new Guard(){
                        {
                        }

                        @Override
                        public void doSomething() throws Throwable {
                            long l = System.nanoTime();
                            try {
                                NbTestCase.this.runTest();
                            }
                            catch (Throwable throwable) {
                                NbTestCase.this.noteWorkDir(NbTestCase.this.workdirNoCreate());
                                throw NbTestCase.this.noteRandomness(throwable);
                            }
                            finally {
                                long l2 = System.nanoTime() - l;
                                if (l2 < 1L) {
                                    l2 = 1L;
                                }
                                NbTestCase.this.time = l2;
                            }
                        }
                    };
                    if (this.runInEQ()) {
                        EventQueue.invokeLater(guard);
                        guard.waitFinished(this.computeTimeOut());
                    } else if (this.computeTimeOut() == 0) {
                        guard.run();
                        guard.waitFinished();
                    } else {
                        Thread thread = new Thread((Runnable)guard, "Test Watch Dog: " + this.getName());
                        thread.start();
                        guard.waitFinished(this.computeTimeOut());
                    }
                    if (!this.runInEQ()) break block10;
                }
                catch (Throwable throwable) {
                    if (this.runInEQ()) {
                        Guard guard2 = new Guard(){
                            {
                            }

                            @Override
                            public void doSomething() throws Throwable {
                                NbTestCase.this.tearDown();
                            }
                        };
                        EventQueue.invokeLater(guard2);
                        guard2.waitFinished(this.computeTimeOut());
                    } else {
                        this.tearDown();
                    }
                    throw throwable;
                }
                guard = new /* invalid duplicate definition of identical inner class */;
                EventQueue.invokeLater(guard);
                guard.waitFinished(this.computeTimeOut());
                break block11;
            }
            this.tearDown();
        }
    }

    private void noteWorkDir(File file) {
        if (!file.isDirectory()) {
            return;
        }
        try {
            String string = System.getenv("BUILD_URL");
            if (string != null) {
                String string2;
                String string3 = new File(System.getenv("WORKSPACE")).getCanonicalPath();
                if (!string3.endsWith(File.separator)) {
                    string3 = string3 + File.separator;
                }
                if ((string2 = file.getCanonicalPath()).startsWith(string3)) {
                    NbTestCase.copytree(file, new File(file.getParentFile(), file.getName() + "-FAILED"));
                    System.err.println("Working directory: " + string + "artifact/" + string2.substring(string3.length()).replace(File.separatorChar, '/') + "-FAILED/");
                    return;
                }
            }
            System.err.println("Working directory: " + file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copytree(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.mkdirs()) {
                throw new IOException("mkdir: " + file2);
            }
            for (File file3 : file.listFiles()) {
                NbTestCase.copytree(file3, new File(file2, file3.getName()));
            }
        } else {
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                int n;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                while ((n = bufferedInputStream.read()) != -1) {
                    bufferedOutputStream.write(n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
        }
    }

    private Throwable noteRandomness(Throwable throwable) {
        Class<?> clazz = this.getClass();
        if (clazz.isAnnotationPresent(RandomlyFails.class)) {
            return Log.wrapWithAddendum(throwable, "(" + clazz.getSimpleName() + " marked @RandomlyFails so try just running test again)", false);
        }
        try {
            if (clazz.getMethod(this.getName(), new Class[0]).isAnnotationPresent(RandomlyFails.class)) {
                return Log.wrapWithAddendum(throwable, "(" + clazz.getSimpleName() + "." + this.getName() + " marked @RandomlyFails so try just running test again)", false);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return throwable;
    }

    protected final int getTestNumber() {
        try {
            Matcher matcher = Pattern.compile("test[a-zA-Z]*([0-9]+)").matcher(this.getName());
            NbTestCase.assertTrue((String)("Name does not contain numbers: " + this.getName()), (boolean)matcher.find());
            return Integer.valueOf(matcher.group(1));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            NbTestCase.fail((String)("Name: " + this.getName() + " does not represent number"));
            return 0;
        }
    }

    final long getExecutionTime() {
        return this.time;
    }

    public static void assertFile(String string, String string2, String string3, String string4, Diff diff) {
        Diff diff2 = null == diff ? Manager.getSystemDiff() : diff;
        File file = NbTestCase.getDiffName(string3, null == string4 ? null : new File(string4));
        if (null == diff2) {
            NbTestCase.fail((String)"diff is not available");
        } else {
            try {
                if (null == file) {
                    if (diff2.diff(string2, string3, null)) {
                        throw new AssertionFileFailedError(string, "");
                    }
                } else if (diff2.diff(string2, string3, file.getAbsolutePath())) {
                    throw new AssertionFileFailedError(string, file.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                NbTestCase.fail((String)("exception in assertFile : " + iOException.getMessage()));
            }
        }
    }

    public static void assertFile(String string, String string2, String string3, Diff diff) {
        NbTestCase.assertFile(null, string, string2, string3, diff);
    }

    public static void assertFile(String string, String string2, String string3, String string4) {
        NbTestCase.assertFile(string, string2, string3, string4, null);
    }

    public static void assertFile(String string, String string2, String string3) {
        NbTestCase.assertFile(null, string, string2, string3, null);
    }

    public static void assertFile(String string, String string2) {
        NbTestCase.assertFile(null, string, string2, null, null);
    }

    public static void assertFile(String string, File file, File file2, File file3, Diff diff) {
        Diff diff2 = null == diff ? Manager.getSystemDiff() : diff;
        File file4 = NbTestCase.getDiffName(file2.getAbsolutePath(), file3);
        if (null == diff2) {
            NbTestCase.fail((String)"diff is not available");
        } else {
            try {
                if (diff2.diff(file, file2, file4)) {
                    throw new AssertionFileFailedError(string + "\n diff: " + file4, null == file4 ? "" : file4.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                NbTestCase.fail((String)("exception in assertFile : " + iOException.getMessage()));
            }
        }
    }

    public static void assertFile(File file, File file2, File file3, Diff diff) {
        NbTestCase.assertFile("Difference between " + file + " and " + file2, file, file2, file3, diff);
    }

    public static void assertFile(String string, File file, File file2, File file3) {
        NbTestCase.assertFile(string, file, file2, file3, null);
    }

    public static void assertFile(File file, File file2, File file3) {
        NbTestCase.assertFile("Difference between " + file + " and " + file2, file, file2, file3, null);
    }

    public static void assertFile(File file, File file2) {
        NbTestCase.assertFile("Difference between " + file + " and " + file2, file, file2, null, null);
    }

    private static File getDiffName(String string, File file) {
        if (null == file) {
            return null;
        }
        if (!file.exists() || file.isFile()) {
            return file;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(file.getAbsolutePath());
        int n = string.lastIndexOf(92);
        int n2 = string.lastIndexOf(47);
        n = n > n2 ? n : n2;
        n = -1 == n ? 0 : n + 1;
        n2 = string.lastIndexOf(46);
        int n3 = n2 = -1 == n2 ? string.length() : n2;
        if (0 < stringBuilder.length()) {
            stringBuilder.append("/");
        }
        stringBuilder.append(string.substring(n, n2));
        stringBuilder.append(".diff");
        return new File(stringBuilder.toString());
    }

    public String getWorkDirPath() {
        String string;
        int n;
        int n2;
        String string2;
        int n3;
        int n4;
        if (this.workDirPath != null) {
            return this.workDirPath;
        }
        String string3 = this.getName();
        String string4 = System.getProperty("os.name");
        if (string4 != null && string4.startsWith("Windows")) {
            char[] cArray = new char[]{'\"', '/', '\\', '?', '<', '>', '|', ':'};
            for (int i = 0; i < cArray.length; ++i) {
                string3 = string3.replace(cArray[i], '~');
            }
        }
        if ((n4 = Manager.getWorkDirPath().length()) + (n3 = (string2 = this.getClass().getName()).length()) + (n2 = string3.length()) > (n = Integer.getInteger("nbjunit.too.long", 100).intValue())) {
            string2 = NbTestCase.abbrevDots(string2);
            n3 = string2.length();
        }
        if (n4 + n3 + n2 > n) {
            string3 = NbTestCase.abbrevCapitals(string3);
        }
        String string5 = Manager.getWorkDirPath() + File.separator + string2 + File.separator + string3;
        int n5 = 0;
        while (true) {
            String string6 = string = n5 == 0 ? string5 : string5 + "-" + n5;
            if (usedPaths.add(string)) break;
            ++n5;
        }
        this.workDirPath = string;
        return string;
    }

    private static String abbrevDots(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        for (String string3 : string.split("\\.")) {
            stringBuilder.append(string2);
            stringBuilder.append(string3.charAt(0));
            string2 = ".";
        }
        return stringBuilder.toString();
    }

    private static String abbrevCapitals(String string) {
        if (string.startsWith("test")) {
            string = string.substring(4);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            stringBuilder.append(Character.toLowerCase(string.charAt(i)));
        }
        if (stringBuilder.length() == 0) {
            return string;
        }
        return stringBuilder.toString();
    }

    private File workdirNoCreate() {
        return Manager.normalizeFile(new File(this.getWorkDirPath()));
    }

    public File getWorkDir() throws IOException {
        File file = this.workdirNoCreate();
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("workdir exists, but is not a directory, workdir = " + file);
            }
            return file;
        }
        boolean bl = file.mkdirs();
        if (!bl) {
            throw new IOException("workdir creation failed: " + file);
        }
        return file;
    }

    private static void deleteFile(File file) throws IOException {
        boolean bl;
        if (file.isDirectory() && file.equals(file.getCanonicalFile())) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                NbTestCase.deleteFile(fileArray[i]);
            }
        }
        if (!(bl = file.delete())) {
            throw new IOException("Cannot delete file, file = " + file.getPath());
        }
    }

    static void deleteSubFiles(File file) throws IOException {
        File[] fileArray = file.getCanonicalFile().listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                NbTestCase.deleteFile(file2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWorkDir() throws IOException {
        Map<String, PrintStream> map = this.logStreamTable;
        synchronized (map) {
            File file = this.getWorkDir();
            this.closeAllStreams();
            NbTestCase.deleteSubFiles(file);
        }
    }

    private boolean hasTestMethodChanged() {
        if (!this.getName().equals(this.lastTestMethod)) {
            this.lastTestMethod = this.getName();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintStream getFileLog(String string) throws IOException {
        Map<String, PrintStream> map = this.logStreamTable;
        synchronized (map) {
            if (this.hasTestMethodChanged()) {
                this.closeAllStreams();
            } else if (this.logStreamTable.containsKey(string)) {
                return this.logStreamTable.get(string);
            }
            WFOS wFOS = new WFOS(new File(this.getWorkDir(), string));
            PrintStream printStream = new PrintStream(wFOS, true);
            this.logStreamTable.put(string, printStream);
            return printStream;
        }
    }

    private void closeAllStreams() {
        for (PrintStream printStream : this.logStreamTable.values()) {
            printStream.close();
        }
        this.logStreamTable.clear();
    }

    public PrintStream getLog(String string) {
        try {
            return this.getFileLog(string);
        }
        catch (IOException iOException) {
            return this.systemOutPSWrapper;
        }
    }

    public PrintStream getLog() {
        return this.getLog(this.getName() + ".log");
    }

    public void log(String string) {
        this.getLog().println(string);
    }

    public void log(String string, String string2) {
        this.getLog(string).println(string2);
    }

    public PrintStream getRef() {
        String string = this.getName() + ".ref";
        try {
            return this.getFileLog(string);
        }
        catch (IOException iOException) {
            NbTestCase.fail((String)("Could not open reference file: " + string));
            return this.systemOutPSWrapper;
        }
    }

    public void ref(String string) {
        this.getRef().println(string);
    }

    public File getGoldenFile(String string) {
        String string2 = this.getClass().getName();
        String string3 = string2.replace('.', '/') + "/" + string;
        File file = new File(this.getDataDir() + "/goldenfiles/" + string3);
        if (file.exists()) {
            return file;
        }
        String string4 = string2;
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string4 = string2.substring(n + 1);
        }
        string3 = string4 + "/" + string;
        URL uRL = this.getClass().getResource("data/goldenfiles/" + string3);
        NbTestCase.assertNotNull((String)("Golden file not found in any of the following locations:\n  " + file + "\n  src/" + string2.replace('.', '/').substring(0, string2.indexOf(string4)) + "data/goldenfiles/" + string3), (Object)uRL);
        String string5 = NbTestCase.convertNBFSURL(uRL);
        file = new File(string5);
        return file;
    }

    public File getDataDir() {
        File file;
        String string = System.getProperty("xtest.data");
        if (string != null) {
            return Manager.normalizeFile(new File(string));
        }
        URL uRL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        if (!uRL.getProtocol().equals("file")) {
            throw new Error("Cannot find data directory from " + uRL);
        }
        try {
            file = new File(new File(uRL.toURI()).getParentFile(), "data");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new Error(uRISyntaxException);
        }
        return Manager.normalizeFile(file);
    }

    public File getGoldenFile() {
        return this.getGoldenFile(this.getName() + ".pass");
    }

    public void compareReferenceFiles(String string, String string2, String string3) {
        try {
            if (!this.getRef().equals(this.systemOutPSWrapper)) {
                this.getRef().flush();
                this.getRef().close();
            }
            File file = this.getGoldenFile(string2);
            File file2 = new File(this.getWorkDir(), string);
            File file3 = new File(this.getWorkDir(), string3);
            String string4 = "Files differ";
            if (System.getProperty("xtest.home") == null) {
                string4 = string4 + "; check " + file3;
            }
            NbTestCase.assertFile(string4, file2, file, file3);
        }
        catch (IOException iOException) {
            NbTestCase.fail((String)"Could not obtain working direcory");
        }
    }

    public void compareReferenceFiles() {
        this.compareReferenceFiles(this.getName() + ".ref", this.getName() + ".pass", this.getName() + ".diff");
    }

    @Deprecated
    public static String convertNBFSURL(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("Given URL should not be null.");
        }
        String string = uRL.toExternalForm();
        if (string.startsWith("nbfs://")) {
            return NbTestCase.convertNewNBFSURL(uRL);
        }
        return NbTestCase.convertOldNBFSURL(uRL);
    }

    private static String convertNewNBFSURL(URL uRL) {
        String string = uRL.toExternalForm();
        String string2 = string.startsWith("nbfs://nbhost/") ? uRL.getPath().substring(1) : string.substring("nbfs://".length());
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = string2.length();
        while (n < n2) {
            char c;
            if ((c = string2.charAt(n++)) == '%' && n + 1 < n2) {
                char c2 = string2.charAt(n++);
                char c3 = string2.charAt(n++);
                c = (char)Integer.parseInt("" + c2 + c3, 16);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static String convertOldNBFSURL(URL uRL) {
        String string = uRL.getFile();
        if (uRL.getProtocol().equals("nbfs")) {
            String string2 = "FileSystem ";
            if (string.indexOf(string2) > -1) {
                string = string.substring(string.indexOf(string2) + string2.length());
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            int n2 = string.length();
            block6: while (n < n2) {
                char c;
                if ((c = string.charAt(n++)) == 'Q' && n < n2) {
                    c = string.charAt(n++);
                    switch (c) {
                        case 'B': {
                            stringBuilder.append('/');
                            continue block6;
                        }
                        case 'C': {
                            stringBuilder.append(':');
                            continue block6;
                        }
                        case 'D': {
                            stringBuilder.append('\\');
                            continue block6;
                        }
                        case 'E': {
                            stringBuilder.append('#');
                            continue block6;
                        }
                    }
                    stringBuilder.append('Q');
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(c);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static void assertGC(String string, Reference<?> reference) {
        NbTestCase.assertGC(string, reference, Collections.emptySet());
    }

    public static void assertGC(final String string, final Reference<?> reference, final Set<?> set) {
        NbModuleLogHandler.whileIgnoringOOME(new Runnable(){

            @Override
            public void run() {
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                int n = 100000;
                for (int i = 0; i < 50; ++i) {
                    if (reference.get() == null) {
                        return;
                    }
                    try {
                        System.gc();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        // empty catch block
                    }
                    try {
                        System.runFinalization();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        // empty catch block
                    }
                    try {
                        arrayList.add(new byte[n]);
                        n = (int)((double)n * 1.3);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        n /= 2;
                    }
                    try {
                        if (i % 3 != 0) continue;
                        Thread.sleep(321L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                arrayList = null;
                String string2 = null;
                try {
                    string2 = NbTestCase.findRefsFromRoot(reference.get(), set);
                }
                catch (Exception exception) {
                    throw new AssertionFailedErrorException(exception);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
                TestCase.fail((String)(string + ":\n" + string2));
            }
        });
    }

    public static void assertSize(String string, int n, Object object) {
        NbTestCase.assertSize(string, Arrays.asList(object), n);
    }

    public static void assertSize(String string, Collection<?> collection, int n) {
        NbTestCase.assertSize(string, collection, n, new Object[0]);
    }

    public static void assertSize(String string, Collection<?> collection, int n, Object[] objectArray) {
        org.netbeans.insane.scanner.Filter filter = ScannerUtils.skipObjectsFilter(Arrays.asList(objectArray), (boolean)false);
        NbTestCase.assertSize(string, collection, n, filter);
    }

    public static int assertSize(String string, Collection<?> collection, int n, final MemoryFilter memoryFilter) {
        org.netbeans.insane.scanner.Filter filter = new org.netbeans.insane.scanner.Filter(){

            public boolean accept(Object object, Object object2, Field field) {
                return !memoryFilter.reject(object);
            }
        };
        return NbTestCase.assertSize(string, collection, n, filter);
    }

    private static int assertSize(String string, Collection<?> collection, int n, org.netbeans.insane.scanner.Filter filter) {
        try {
            final CountingVisitor countingVisitor = new CountingVisitor();
            ScannerUtils.scan((org.netbeans.insane.scanner.Filter)filter, (Visitor)countingVisitor, collection, (boolean)false);
            int n2 = countingVisitor.getTotalSize();
            if (n2 > n) {
                StringBuilder stringBuilder = new StringBuilder(4096);
                stringBuilder.append(string);
                stringBuilder.append(": leak ").append(n2 - n).append(" bytes ");
                stringBuilder.append(" over limit of ");
                stringBuilder.append(n).append(" bytes");
                TreeSet treeSet = new TreeSet(new Comparator<Class<?>>(){

                    @Override
                    public int compare(Class<?> clazz, Class<?> clazz2) {
                        int n = countingVisitor.getSizeForClass(clazz2) - countingVisitor.getSizeForClass(clazz);
                        return n != 0 ? n : clazz.hashCode() - clazz2.hashCode();
                    }
                });
                treeSet.addAll(countingVisitor.getClasses());
                for (Class clazz : treeSet) {
                    if (countingVisitor.getCountForClass(clazz) == 0) continue;
                    stringBuilder.append("\n  ").append(clazz.getName()).append(": ").append(countingVisitor.getCountForClass(clazz)).append(", ").append(countingVisitor.getSizeForClass(clazz)).append("B");
                }
                NbTestCase.fail((String)stringBuilder.toString());
            }
            return n2;
        }
        catch (Exception exception) {
            throw new AssertionFailedErrorException("Could not traverse reference graph", exception);
        }
    }

    public static void failByBug(int n) {
        throw new AssertionKnownBugError(n);
    }

    public static void failByBug(int n, String string) {
        throw new AssertionKnownBugError(n, string);
    }

    private static String findRefsFromRoot(Object object, Set<?> set) throws Exception {
        Map map;
        Path path;
        int n = Integer.getInteger("assertgc.paths", 1);
        StringBuilder stringBuilder = new StringBuilder();
        final IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>();
        org.netbeans.insane.scanner.Filter filter = new org.netbeans.insane.scanner.Filter(){

            public boolean accept(Object object, Object object2, Field field) {
                return !identityHashMap.containsKey(object);
            }
        };
        while (n-- > 0 && (path = (Path)(map = LiveReferences.fromRoots(Collections.singleton(object), set, null, (org.netbeans.insane.scanner.Filter)filter)).get(object)) != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n\n");
            }
            stringBuilder.append(path);
            while (path != null) {
                Object object2 = path.getObject();
                if (object2 != object) {
                    identityHashMap.put(object2, null);
                }
                path = path.nextNode();
            }
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : "Not found!!!";
    }

    static {
        MethodOrder.initialize();
        boolean bl = false;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> list = runtimeMXBean.getInputArguments();
        if (list.contains("-Xdebug") || list.contains("-agentlib:jdwp")) {
            bl = true;
        } else {
            for (String string : list) {
                if (!string.startsWith("-agentlib:jdwp=")) continue;
                bl = true;
                break;
            }
        }
        Integer n = Integer.getInteger("nbjunit.hard.timeout");
        vmDeadline = n != null && !bl ? System.currentTimeMillis() + (long)n.intValue() : -1L;
        DEFAULT_TIME_OUT_CALLED = new ThreadLocal();
        usedPaths = new HashSet<String>();
    }

    private static class WFOS
    extends FilterOutputStream {
        private File f;
        private int bytes;

        public WFOS(File file) throws FileNotFoundException {
            super(new FileOutputStream(file));
            this.f = file;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.add(n2);
            this.out.write(byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.add(byArray.length);
            this.out.write(byArray);
        }

        @Override
        public void write(int n) throws IOException {
            this.add(1);
            this.out.write(n);
        }

        private synchronized void add(int n) throws IOException {
            this.bytes += n;
            if ((long)this.bytes >= 0x100000L) {
                this.out.close();
                File file = new File(this.f.getParent(), "TRIMMED_" + this.f.getName());
                file.delete();
                this.f.renameTo(file);
                this.f.delete();
                this.out = new FileOutputStream(this.f);
                this.bytes = 0;
            }
        }
    }
}

