/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.netbeans.junit.Manager;
import org.netbeans.junit.MethodOrder;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.internal.NbModuleLogHandler;

public class NbModuleSuite {
    private static final Logger LOG;

    private NbModuleSuite() {
    }

    public static Test create(Class<? extends TestCase> clazz, String string, String string2) {
        return Configuration.create(clazz).clusters(string).enableModules(string2).suite();
    }

    public static Test create(Class<? extends TestCase> clazz, String string, String string2, String ... stringArray) {
        Configuration configuration = Configuration.create(clazz).clusters(string).enableModules(string2);
        if (stringArray.length > 0) {
            configuration = configuration.addTest(stringArray);
        }
        return configuration.suite();
    }

    public static Test allModules(Class<? extends TestCase> clazz, String ... stringArray) {
        return NbModuleSuite.create(clazz, ".*", ".*", stringArray);
    }

    public static Configuration createConfiguration(Class<? extends TestCase> clazz) {
        return Configuration.create(clazz);
    }

    public static Configuration emptyConfiguration() {
        return Configuration.create(null);
    }

    public static Test create(Configuration configuration) {
        return configuration.suite();
    }

    static {
        System.setProperty("org.netbeans.MainImpl.154417", "true");
        LOG = Logger.getLogger(NbModuleSuite.class.getName());
    }

    private static class NbTestSuiteLogCheck
    extends NbTestSuite {
        public NbTestSuiteLogCheck() {
        }

        public NbTestSuiteLogCheck(Class<? extends TestCase> clazz) {
            super(clazz);
        }

        public void runTest(Test test, TestResult testResult) {
            int n = testResult.errorCount();
            int n2 = testResult.failureCount();
            LOG.log(Level.FINE, "Running test {0}", test);
            super.runTest(test, testResult);
            LOG.log(Level.FINE, "Finished: {0}", test);
            if (n == testResult.errorCount() && n2 == testResult.failureCount()) {
                NbModuleLogHandler.checkFailures((TestCase)test, testResult, test instanceof NbTestCase ? ((NbTestCase)test).getWorkDirPath() : Manager.getWorkDirPath());
            }
        }
    }

    static final class S
    extends NbTestSuite {
        final Configuration config;
        private static int invocations;
        private static File lastUserDir;
        private int testCount = 0;
        private static final Set<String> pseudoModules;
        private static Pattern MANIFEST;
        private static Method fileToPath;
        private static Method pathToUri;
        private static Method pathsGet;
        private static Method pathToFile;
        private static Pattern ENABLED;
        private static Pattern AUTO;
        private static Pattern EAGER;

        public S(Configuration configuration) {
            this.config = configuration.getReady();
        }

        public int countTestCases() {
            return this.testCount;
        }

        public void run(final TestResult testResult) {
            testResult.runProtected((Test)this, new Protectable(){

                public void protect() throws Throwable {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        this.runInRuntimeContainer(testResult);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(classLoader);
                    }
                }
            });
        }

        private static String[] tokenizePath(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":;", true);
            char c = '\u0000';
            int n = 0;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                char c2;
                String string2 = stringTokenizer.nextToken();
                if (string2.length() == 0) continue;
                if (string2.length() == 1 && ((c2 = string2.charAt(0)) == ':' || c2 == ';')) {
                    n = c2;
                    ++n2;
                    continue;
                }
                if (c != '\u0000') {
                    if (n == 58 && n2 == 1 && (string2.charAt(0) == '\\' || string2.charAt(0) == '/')) {
                        string2 = "" + c + ':' + string2;
                    } else {
                        arrayList.add(Character.toString(c));
                    }
                    c = '\u0000';
                }
                n2 = 0;
                if (string2.length() == 1 && ((c2 = string2.charAt(0)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                    c = c2;
                    continue;
                }
                arrayList.add(string2);
            }
            if (c != '\u0000') {
                arrayList.add(Character.toString(c));
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        static void findClusters(Collection<File> collection, List<String> list) throws IOException {
            File file;
            TreeSet<Object> treeSet;
            File file2 = S.findPlatform().getCanonicalFile();
            String string = System.getProperty("cluster.path.final");
            if (string != null) {
                treeSet = new TreeSet();
                for (String object : S.tokenizePath(string)) {
                    file = new File(object);
                    treeSet.add(file.getCanonicalFile());
                }
            } else {
                String string2 = System.getProperty("all.clusters");
                File file3 = string2 != null ? new File(string2) : file2.getParentFile();
                treeSet = new TreeSet<File>(Arrays.asList(file3.listFiles()));
            }
            for (String string3 : list) {
                for (File file3 : treeSet) {
                    if (file3.equals(file2) || !file3.getName().matches(string3) || !(file = new File(new File(file3, "config"), "Modules")).exists()) continue;
                    collection.add(file3);
                }
            }
        }

        private void runInRuntimeContainer(TestResult testResult) throws Exception {
            Item item;
            TestResult testResult2;
            Object noClassDefFoundError;
            Object object;
            Serializable serializable2;
            Object object2;
            System.getProperties().remove("netbeans.dirs");
            File file = S.findPlatform();
            ArrayList<URL> arrayList = new ArrayList<URL>();
            ArrayList<File> arrayList2 = new ArrayList<File>();
            arrayList2.add(new File(file, "lib"));
            File file2 = new File(System.getProperty("java.home"));
            if (new File(file2.getParentFile(), "lib").exists()) {
                file2 = file2.getParentFile();
            }
            arrayList2.add(new File(file2, "lib"));
            if (System.getProperty("code.coverage.classpath") != null) {
                arrayList2.add(new File(System.getProperty("code.coverage.classpath")));
            }
            for (File object52 : arrayList2) {
                object2 = object52.listFiles();
                if (object2 == null) continue;
                for (Serializable serializable2 : object2) {
                    if (!((File)serializable2).getName().endsWith(".jar")) continue;
                    arrayList.add(S.toURI((File)serializable2).toURL());
                }
            }
            JUnitLoader jUnitLoader = new JUnitLoader(this.config.parentClassLoader, NbModuleSuite.class.getClassLoader());
            URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[0]), (ClassLoader)jUnitLoader);
            object2 = uRLClassLoader.loadClass("org.netbeans.Main");
            Assert.assertEquals((String)"Loaded by our classloader", (Object)uRLClassLoader, (Object)((Class)object2).getClassLoader());
            Method method = ((Class)object2).getDeclaredMethod("main", String[].class);
            System.setProperty("java.util.logging.config", "-");
            System.setProperty("netbeans.logger.console", "true");
            if (System.getProperty("netbeans.logger.noSystem") == null) {
                System.setProperty("netbeans.logger.noSystem", "true");
            }
            System.setProperty("netbeans.home", file.getPath());
            System.setProperty("netbeans.full.hack", "true");
            String string = System.getProperty("branding.token");
            if (string != null) {
                try {
                    Method throwable = uRLClassLoader.loadClass("org.openide.util.NbBundle").getMethod("setBranding", String.class);
                    throwable.invoke(null, string);
                }
                catch (Throwable throwable2) {
                    Throwable throwable;
                    if (throwable2 instanceof InvocationTargetException) {
                        throwable = ((InvocationTargetException)throwable2).getTargetException();
                    }
                    LOG.log(Level.WARNING, "Cannot set branding to " + string, throwable);
                }
            }
            File file3 = new File(new File(Manager.getWorkDirPath()), "userdir" + invocations++);
            if (this.config.reuseUserDir) {
                file3 = lastUserDir != null ? lastUserDir : file3;
            } else {
                NbTestCase.deleteSubFiles(file3);
            }
            lastUserDir = file3;
            file3.mkdirs();
            System.setProperty("netbeans.user", file3.getPath());
            serializable2 = new TreeSet();
            if (this.config.enableClasspathModules) {
                ((TreeSet)serializable2).addAll(S.findEnabledModules(NbTestSuite.class.getClassLoader()));
            }
            ((TreeSet)serializable2).add("org.openide.filesystems");
            ((TreeSet)serializable2).add("org.openide.modules");
            ((TreeSet)serializable2).add("org.openide.util");
            ((TreeSet)serializable2).add("org.openide.util.ui");
            ((TreeSet)serializable2).remove("org.netbeans.insane");
            ((TreeSet)serializable2).add("org.netbeans.core.startup");
            ((TreeSet)serializable2).add("org.netbeans.core.startup.base");
            ((TreeSet)serializable2).add("org.netbeans.bootstrap");
            S.turnModules(file3, !this.config.honorAutoEager, (TreeSet<String>)serializable2, this.config.moduleRegExp, file);
            if (this.config.enableClasspathModules) {
                S.turnClassPathModules(file3, NbTestSuite.class.getClassLoader());
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "";
            for (File file4 : this.findClusters()) {
                S.turnModules(file3, !this.config.honorAutoEager, (TreeSet<String>)serializable2, this.config.moduleRegExp, file4);
                stringBuilder.append(string2);
                stringBuilder.append(file4.getPath());
                string2 = File.pathSeparator;
            }
            System.setProperty("netbeans.dirs", stringBuilder.toString());
            if (this.config.hideExtraModules) {
                object = new LinkedHashSet();
                if (this.config.clusterRegExp != null) {
                    S.findClusters((Collection<File>)object, this.config.clusterRegExp);
                }
                object.add(S.findPlatform());
                Iterator arrayList3 = object.iterator();
                while (arrayList3.hasNext()) {
                    File item2 = (File)arrayList3.next();
                    this.disableModules(file3, item2);
                }
            }
            System.setProperty("netbeans.security.nocheck", "true");
            object = new ArrayList(this.config.tests.size());
            for (Item test : this.config.tests) {
                object.add(test.clazz);
            }
            S.preparePatches(System.getProperty("java.class.path"), System.getProperties(), object.toArray(new Class[0]));
            ArrayList arrayList3 = new ArrayList();
            arrayList3.add("--nosplash");
            if (!this.config.gui) {
                arrayList3.add("--nogui");
            }
            if (this.config.startupArgs != null) {
                arrayList3.addAll(this.config.startupArgs);
            }
            Test test = NbModuleLogHandler.registerBuffer(this.config.failOnMessage, this.config.failOnException);
            method.invoke(null, new Object[]{arrayList3.toArray(new String[0])});
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Assert.assertNotNull((String)"Global classloader is initialized", (Object)classLoader);
            ClassLoader classLoader2 = classLoader;
            try {
                classLoader2.loadClass("junit.framework.Test");
                classLoader2.loadClass("org.netbeans.junit.NbTestSuite");
                noClassDefFoundError = new NbTestSuite();
                testResult2 = this.config.tests.iterator();
                while (testResult2.hasNext()) {
                    Class<TestCase> clazz;
                    item = (Item)testResult2.next();
                    if (item.isTestCase) {
                        clazz = classLoader2.loadClass(item.clazz.getName()).asSubclass(TestCase.class);
                        if (item.fileNames == null) {
                            MethodOrder.orderMethods(clazz, null);
                            ((NbTestSuite)noClassDefFoundError).addTest(new NbTestSuiteLogCheck(clazz));
                            continue;
                        }
                        NbTestSuiteLogCheck nbTestSuiteLogCheck = new NbTestSuiteLogCheck();
                        nbTestSuiteLogCheck.addTests(clazz, item.fileNames);
                        ((NbTestSuite)noClassDefFoundError).addTest(nbTestSuiteLogCheck);
                        continue;
                    }
                    clazz = classLoader2.loadClass(item.clazz.getName()).asSubclass(Test.class);
                    ((NbTestSuite)noClassDefFoundError).addTest((Test)clazz.newInstance());
                }
                if (test != null) {
                    ((NbTestSuite)noClassDefFoundError).addTest(test);
                }
                this.testCount = noClassDefFoundError.countTestCases();
                noClassDefFoundError.run(testResult);
            }
            catch (ClassNotFoundException classNotFoundException) {
                testResult.addError((Test)this, (Throwable)classNotFoundException);
            }
            catch (NoClassDefFoundError noClassDefFoundError2) {
                testResult.addError((Test)this, (Throwable)noClassDefFoundError2);
            }
            if (test != null) {
                NbModuleLogHandler.finish();
            }
            if ((testResult2 = new Shutdown(classLoader, (String)(noClassDefFoundError = this.config.latestTestCaseClass != null ? this.config.latestTestCaseClass.getName() : "exit")).run()).failureCount() > 0) {
                item = (TestFailure)testResult2.failures().nextElement();
                testResult.addFailure(item.failedTest(), (AssertionFailedError)item.thrownException());
            }
            if (testResult2.errorCount() > 0) {
                item = (TestFailure)testResult2.errors().nextElement();
                testResult.addError(item.failedTest(), item.thrownException());
            }
        }

        static File findPlatform() {
            File file;
            Serializable serializable;
            Object object;
            Object object2;
            String string = System.getProperty("cluster.path.final");
            if (string != null) {
                object2 = S.tokenizePath(string);
                int n = ((String[])object2).length;
                for (int i = 0; i < n; ++i) {
                    object = object2[i];
                    serializable = new File((String)object);
                    if (!((File)serializable).getName().matches("platform\\d*")) continue;
                    return serializable;
                }
            }
            if ((object2 = System.getProperty("all.clusters")) != null && (file = new File((String)object2, "platform")).isDirectory()) {
                return file;
            }
            try {
                Class<?> clazz = Class.forName("org.openide.util.Lookup");
                File file2 = S.toFile(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
                Assert.assertTrue((String)("Util exists: " + file2), (boolean)file2.exists());
                return file2.getParentFile().getParentFile();
            }
            catch (Exception exception) {
                try {
                    File file3 = S.toFile(NbModuleSuite.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    object = file3.getParentFile().getParentFile();
                    Assert.assertEquals((String)(file3 + " is in a folder named 'harness'"), (String)"harness", (String)((File)object).getName());
                    serializable = new TreeSet();
                    for (File file4 : ((File)object).getParentFile().listFiles()) {
                        if (!file4.getName().startsWith("platform")) continue;
                        ((TreeSet)serializable).add(file4);
                    }
                    Assert.assertFalse((String)("Platform shall be found in " + ((File)object).getParent()), (boolean)((TreeSet)serializable).isEmpty());
                    return (File)((TreeSet)serializable).last();
                }
                catch (Exception exception2) {
                    Assert.fail((String)("Cannot find utilities JAR: " + exception + " and: " + exception2));
                    return null;
                }
            }
        }

        private File[] findClusters() throws IOException {
            LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
            if (this.config.clusterRegExp != null) {
                S.findClusters(linkedHashSet, this.config.clusterRegExp);
            }
            if (this.config.enableClasspathModules) {
                for (String string : S.tokenizePath(System.getProperty("java.class.path"))) {
                    File file = new File(string);
                    File file2 = file.getParentFile().getParentFile();
                    File file3 = new File(new File(file2, "config"), "Modules");
                    if (!file3.exists() && !file2.getName().equals("cluster")) continue;
                    linkedHashSet.add(file2);
                }
            }
            return linkedHashSet.toArray(new File[0]);
        }

        private static String cnb(Manifest manifest) {
            String string = manifest.getMainAttributes().getValue("OpenIDE-Module");
            return string != null ? string.replaceFirst("/\\d+", "") : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Set<String> findEnabledModules(ClassLoader classLoader) throws IOException {
            TreeSet<String> treeSet = new TreeSet<String>();
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                try (InputStream inputStream = uRL.openStream();){
                    String string = S.cnb(new Manifest(inputStream));
                    if (string == null) continue;
                    treeSet.add(string);
                }
            }
            return treeSet;
        }

        static void turnClassPathModules(File file, ClassLoader classLoader) throws IOException {
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                File file2;
                Manifest manifest;
                URL uRL = enumeration.nextElement();
                try (InputStream inputStream = uRL.openStream();){
                    manifest = new Manifest(inputStream);
                }
                String string = S.cnb(manifest);
                if (string == null || (file2 = S.jarFromURL(uRL)) == null || pseudoModules.contains(string)) continue;
                String string2 = manifest.getMainAttributes().getValue("Maven-Class-Path");
                if (string2 != null) {
                    file2 = S.rewrite(file2, string2.split(" "), System.getProperty("java.class.path"));
                }
                String string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n<module name=\"" + string + "\">\n    <param name=\"autoload\">false</param>\n    <param name=\"eager\">false</param>\n    <param name=\"enabled\">true</param>\n    <param name=\"jar\">" + file2 + "</param>\n    <param name=\"reloadable\">false</param>\n</module>\n";
                File file3 = new File(new File(file, "config"), "Modules");
                file3.mkdirs();
                File file4 = new File(file3, string.replace('.', '-') + ".xml");
                S.writeModule(file4, string3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static File rewrite(File file, String[] stringArray, String string) throws IOException {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String[] stringArray2 = S.tokenizePath(string);
            StringBuilder stringBuilder = new StringBuilder();
            for (String object52 : stringArray) {
                object4 = object52.split(":");
                object3 = File.separatorChar + object4[0].replace('.', File.separatorChar) + File.separatorChar + object4[1] + File.separatorChar + object4[2] + File.separatorChar + object4[1] + '-' + (String)object4[2];
                object2 = null;
                for (String n2 : stringArray2) {
                    if (!n2.endsWith(".jar") || !n2.contains((CharSequence)object3)) continue;
                    object2 = new File(n2);
                    break;
                }
                if (object2 == null) {
                    throw new IOException("no match for " + object52 + " found in " + string);
                }
                object = File.createTempFile(object52.replace(':', '-') + '-', ".jar");
                ((File)object).deleteOnExit();
                NbTestCase.copytree((File)object2, (File)object);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(((File)object).getName());
            }
            String string3 = file.getName();
            int n = string3.lastIndexOf(46);
            File file2 = File.createTempFile(string3.substring(0, n) + '-', string3.substring(n));
            file2.deleteOnExit();
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                object4 = new FileOutputStream(file2);
                try {
                    JarEntry jarEntry;
                    object3 = new JarInputStream(fileInputStream);
                    object2 = new Manifest(((JarInputStream)object3).getManifest());
                    ((Manifest)object2).getMainAttributes().putValue("Class-Path", stringBuilder.toString());
                    object = new JarOutputStream((OutputStream)object4, (Manifest)object2);
                    while ((jarEntry = ((JarInputStream)object3).getNextJarEntry()) != null) {
                        int n2;
                        if (jarEntry.getName().matches("META-INF/.+[.]SF")) {
                            throw new IOException("cannot handle signed JARs");
                        }
                        ((JarOutputStream)object).putNextEntry(jarEntry);
                        byte[] byArray = new byte[4092];
                        while ((n2 = ((JarInputStream)object3).read(byArray, 0, byArray.length)) != -1) {
                            ((ZipOutputStream)object).write(byArray, 0, n2);
                        }
                    }
                    ((ZipInputStream)object3).close();
                    ((ZipOutputStream)object).close();
                }
                finally {
                    ((OutputStream)object4).close();
                }
            }
            return file2;
        }

        private static File jarFromURL(URL uRL) {
            Matcher matcher = MANIFEST.matcher(uRL.toExternalForm());
            if (matcher.matches()) {
                return S.toFile(URI.create(matcher.group(1)));
            }
            if (!uRL.getProtocol().equals("file")) {
                throw new IllegalStateException(uRL.toExternalForm());
            }
            return null;
        }

        private static File toFile(URI uRI) throws IllegalArgumentException {
            String string;
            if (pathsGet != null) {
                try {
                    return (File)pathToFile.invoke(pathsGet.invoke(null, uRI), new Object[0]);
                }
                catch (Exception exception) {
                    LOG.log(Level.FINE, "could not convert " + uRI + " to File", exception);
                }
            }
            if ((string = uRI.getHost()) != null && !string.isEmpty() && "file".equals(uRI.getScheme())) {
                return new File("\\\\" + string + uRI.getPath().replace('/', '\\'));
            }
            return new File(uRI);
        }

        private static URI toURI(File file) {
            String string;
            if (fileToPath != null) {
                try {
                    URI uRI = (URI)pathToUri.invoke(fileToPath.invoke((Object)file, new Object[0]), new Object[0]);
                    if (uRI.toString().startsWith("file:///")) {
                        uRI = new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI.getFragment());
                    }
                    return uRI;
                }
                catch (Exception exception) {
                    LOG.log(Level.FINE, "could not convert " + file + " to URI", exception);
                }
            }
            if ((string = file.getAbsolutePath()).startsWith("\\\\")) {
                if (!string.endsWith("\\") && file.isDirectory()) {
                    string = string + "\\";
                }
                try {
                    return new URI("file", null, string.replace('\\', '/'), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOG.log(Level.FINE, "could not convert " + file + " to URI", uRISyntaxException);
                }
            }
            return file.toURI();
        }

        static void preparePatches(String string, Properties properties, Class<?> ... classArray) throws URISyntaxException {
            Pattern pattern = Pattern.compile(".*\\" + File.separator + "([^\\" + File.separator + "]+)\\" + File.separator + "tests\\.jar");
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "";
            for (String string3 : S.tokenizePath(string)) {
                Matcher object = pattern.matcher(string3);
                if (!object.matches()) continue;
                stringBuilder.append(string2).append(string3);
                string2 = File.pathSeparator;
            }
            HashSet hashSet = new HashSet();
            for (Class<?> clazz : classArray) {
                URL uRL = clazz.getProtectionDomain().getCodeSource().getLocation();
                Assert.assertNotNull((String)("URL found for " + clazz), (Object)uRL);
                if (!hashSet.add(uRL)) continue;
                stringBuilder.append(string2).append(S.toFile(uRL.toURI()).getPath());
                string2 = File.pathSeparator;
            }
            properties.setProperty("netbeans.systemclassloader.patches", stringBuilder.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String asString(InputStream inputStream, boolean bl) throws IOException {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = new byte[4096];
            try {
                while ((n = inputStream.read(byArray)) != -1) {
                    stringBuilder.append(new String(byArray, 0, n, StandardCharsets.UTF_8));
                }
            }
            finally {
                if (bl) {
                    inputStream.close();
                }
            }
            while ((n = stringBuilder.indexOf("\r\n")) != -1) {
                stringBuilder.deleteCharAt(n);
            }
            return stringBuilder.toString();
        }

        private void disableModules(File file, File file2) throws IOException {
            File file3 = new File(new File(file2, "config"), "Modules");
            for (File file4 : file3.listFiles()) {
                File file5;
                if (!S.isModuleEnabled(file4) || (file5 = new File(new File(new File(file, "config"), "Modules"), file4.getName())).exists()) continue;
                File file6 = new File(file5.getParentFile(), file4.getName() + "_hidden");
                file6.createNewFile();
            }
        }

        private static boolean isModuleEnabled(File file) throws IOException {
            String string = S.asString(new FileInputStream(file), true);
            Matcher matcher = ENABLED.matcher(string);
            if (matcher.find()) {
                return "true".equals(matcher.group(1));
            }
            return false;
        }

        private static void turnModules(File file, boolean bl, TreeSet<String> treeSet, List<String> list, File ... fileArray) throws IOException {
            if (list == null) {
                return;
            }
            File file2 = new File(new File(file, "config"), "Modules");
            file2.mkdirs();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                String string2 = iterator.next();
                Pattern pattern = Pattern.compile(string2);
                for (File file3 : fileArray) {
                    File file4;
                    File[] fileArray2;
                    if (!file3.getName().matches(string) || (fileArray2 = (file4 = new File(new File(file3, "config"), "Modules")).listFiles()) == null) continue;
                    for (File file5 : fileArray2) {
                        String string3 = file5.getName();
                        if (string3.endsWith(".xml")) {
                            string3 = string3.substring(0, string3.length() - 4);
                        }
                        string3 = string3.replace('-', '.');
                        String string4 = S.asString(new FileInputStream(file5), true);
                        boolean bl2 = treeSet.contains(string3);
                        if (!bl2 && pattern != null) {
                            bl2 = pattern.matcher(string3).matches();
                        }
                        if (!bl2) continue;
                        S.enableModule(string4, bl, bl2, new File(file2, file5.getName()));
                    }
                }
            }
        }

        private static void enableModule(String string, boolean bl, boolean bl2, File file) throws IOException {
            Object object;
            Matcher matcher;
            boolean bl3 = false;
            Matcher matcher2 = ENABLED.matcher(string);
            if (matcher2.find()) {
                bl3 = "false".equals(matcher2.group(1));
            }
            if ((matcher = EAGER.matcher(string)).find() && "true".equals(matcher.group(1))) {
                return;
            }
            if (!bl && ((Matcher)(object = AUTO.matcher(string))).find() && "true".equals(((Matcher)object).group(1))) {
                return;
            }
            if (bl3) {
                assert (matcher2.groupCount() == 1) : "Groups: " + matcher2.groupCount() + " for:\n" + string;
                try {
                    object = string.substring(0, matcher2.start(1)) + (bl2 ? "true" : "false") + string.substring(matcher2.end(1));
                    S.writeModule(file, (String)object);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new IOException("Unparsable:\n" + string, illegalStateException);
                }
            }
            if ((matcher2 = AUTO.matcher(string)).find()) {
                int n = string.indexOf("<param name=\"autoload");
                int n2 = string.indexOf("<param name=\"jar");
                String string2 = "<param name=\"autoload\">false</param>\n    <param name=\"eager\">false</param>\n    <param name=\"enabled\">true</param>\n    ";
                String string3 = string.substring(0, n) + string2 + string.substring(n2);
                try {
                    S.writeModule(file, string3);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new IOException("Unparsable:\n" + string, illegalStateException);
                }
            }
        }

        private static void writeModule(File file, String string) throws IOException {
            if (file.exists()) {
                String string2 = S.asString(new FileInputStream(file), true);
                if (string2.equals(string)) {
                    return;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "rewrite module file: {0}", file);
                    S.charDump(Level.FINEST, string2);
                    LOG.finest("new----");
                    S.charDump(Level.FINEST, string);
                    LOG.finest("end----");
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            fileOutputStream.close();
        }

        private static void charDump(Level level, String string) {
            StringBuilder stringBuilder = new StringBuilder(5 * string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c;
                if (i % 8 == 0) {
                    if (i > 0) {
                        stringBuilder.append('\n');
                    }
                } else {
                    stringBuilder.append(' ');
                }
                if (' ' <= (c = string.charAt(i)) && c <= 'z') {
                    stringBuilder.append('\'').append(c).append('\'');
                    continue;
                }
                stringBuilder.append('x').append(S.two(Integer.toHexString(c).toUpperCase()));
            }
            stringBuilder.append('\n');
            LOG.log(level, stringBuilder.toString());
        }

        private static String two(String string) {
            int n = string.length();
            switch (n) {
                case 0: {
                    return "00";
                }
                case 1: {
                    return "0" + string;
                }
                case 2: {
                    return string;
                }
            }
            return string.substring(n - 2);
        }

        static {
            pseudoModules = new HashSet<String>(Arrays.asList("org.openide.util", "org.openide.util.ui", "org.openide.util.lookup", "org.openide.modules", "org.netbeans.bootstrap", "org.openide.filesystems", "org.openide.filesystems.compat8", "org.netbeans.core.startup", "org.netbeans.core.startup.base", "org.netbeans.libs.asm"));
            MANIFEST = Pattern.compile("jar:(file:.*)!/META-INF/MANIFEST.MF", 8);
            try {
                fileToPath = File.class.getMethod("toPath", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (fileToPath != null) {
                try {
                    Class<?> clazz = Class.forName("java.nio.file.Path");
                    pathToUri = clazz.getMethod("toUri", new Class[0]);
                    pathsGet = Class.forName("java.nio.file.Paths").getMethod("get", URI.class);
                    pathToFile = clazz.getMethod("toFile", new Class[0]);
                }
                catch (Exception exception) {
                    throw new ExceptionInInitializerError(exception);
                }
            }
            ENABLED = Pattern.compile("<param name=[\"']enabled[\"']>([^<]*)</param>", 8);
            AUTO = Pattern.compile("<param name=[\"']autoload[\"']>([^<]*)</param>", 8);
            EAGER = Pattern.compile("<param name=[\"']eager[\"']>([^<]*)</param>", 8);
        }

        private static final class JUnitLoader
        extends ClassLoader {
            private final ClassLoader junit;

            public JUnitLoader(ClassLoader classLoader, ClassLoader classLoader2) {
                super(classLoader);
                this.junit = classLoader2;
            }

            @Override
            protected Class<?> findClass(String string) throws ClassNotFoundException {
                if (this.isUnit(string)) {
                    return this.junit.loadClass(string);
                }
                return super.findClass(string);
            }

            @Override
            public URL findResource(String string) {
                if (this.isUnit(string)) {
                    return this.junit.getResource(string);
                }
                if (string.equals("META-INF/services/java.util.logging.Handler")) {
                    return this.junit.getResource("org/netbeans/junit/internal/FakeMetaInf.txt");
                }
                return super.findResource(string);
            }

            @Override
            public Enumeration<URL> findResources(String string) throws IOException {
                if (this.isUnit(string)) {
                    return this.junit.getResources(string);
                }
                if (string.equals("META-INF/services/java.util.logging.Handler")) {
                    return this.junit.getResources("org/netbeans/junit/internal/FakeMetaInf.txt");
                }
                return super.findResources(string);
            }

            private boolean isUnit(String string) {
                if (string.startsWith("junit")) {
                    return true;
                }
                if (string.startsWith("org.junit") || string.startsWith("org/junit")) {
                    return true;
                }
                if (string.startsWith("org.hamcrest") || string.startsWith("org/hamcrest")) {
                    return true;
                }
                if (string.startsWith("org.netbeans.junit") || string.startsWith("org/netbeans/junit")) {
                    return !string.startsWith("org.netbeans.junit.ide") && !string.startsWith("org/netbeans/junit/ide");
                }
                return false;
            }
        }

        private static class Shutdown
        extends NbTestCase {
            private final ClassLoader global;

            Shutdown(ClassLoader classLoader, String string) throws Exception {
                super("shuttingDown[" + string + "]");
                this.global = classLoader;
            }

            @Override
            protected int timeOut() {
                return 180000;
            }

            @Override
            protected Level logLevel() {
                return Level.FINE;
            }

            @Override
            protected String logRoot() {
                return "org.netbeans.core.NbLifecycleManager";
            }

            private static void waitForAWT() throws InvocationTargetException, InterruptedException {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        countDownLatch.countDown();
                    }
                });
                countDownLatch.await(10L, TimeUnit.SECONDS);
            }

            protected void runTest() throws Throwable {
                JFrame jFrame;
                try {
                    jFrame = new JFrame("Shutting down NetBeans...");
                    jFrame.setBounds(new Rectangle(-100, -100, 50, 50));
                    jFrame.setVisible(true);
                }
                catch (HeadlessException headlessException) {
                    jFrame = null;
                }
                Class<?> clazz = this.global.loadClass("org.openide.LifecycleManager");
                Method method = clazz.getMethod("getDefault", new Class[0]);
                Method method2 = clazz.getMethod("exit", new Class[0]);
                LOG.log(Level.FINE, "Closing via LifecycleManager loaded by {0}", clazz.getClassLoader());
                Object object = method.invoke(null, new Object[0]);
                if (!object.getClass().getName().startsWith("org.openide.LifecycleManager")) {
                    System.setProperty("netbeans.close.no.exit", "true");
                    System.setProperty("netbeans.close", "true");
                    method2.invoke(object, new Object[0]);
                    Shutdown.waitForAWT();
                    System.getProperties().remove("netbeans.close");
                    System.getProperties().remove("netbeans.close.no.exit");
                }
                if (jFrame != null) {
                    jFrame.setVisible(false);
                }
            }
        }
    }

    private static final class Item {
        boolean isTestCase;
        Class<?> clazz;
        String[] fileNames;

        public Item(boolean bl, Class<?> clazz, String[] stringArray) {
            this.isTestCase = bl;
            this.clazz = clazz;
            this.fileNames = stringArray;
        }
    }

    public static final class Configuration {
        final List<Item> tests;
        final Class<? extends TestCase> latestTestCaseClass;
        final List<String> clusterRegExp;
        final List<String> moduleRegExp;
        final List<String> startupArgs;
        final ClassLoader parentClassLoader;
        final boolean reuseUserDir;
        final boolean gui;
        final boolean enableClasspathModules;
        final boolean honorAutoEager;
        final boolean hideExtraModules;
        final Level failOnMessage;
        final Level failOnException;

        private Configuration(List<String> list, List<String> list2, List<String> list3, ClassLoader classLoader, List<Item> list4, Class<? extends TestCase> clazz, boolean bl, boolean bl2, boolean bl3, boolean bl4, Level level, Level level2, boolean bl5) {
            this.clusterRegExp = list;
            this.moduleRegExp = list2;
            this.startupArgs = list3;
            this.parentClassLoader = classLoader;
            this.tests = list4;
            this.reuseUserDir = bl;
            this.latestTestCaseClass = clazz;
            this.gui = bl2;
            this.enableClasspathModules = bl3;
            this.honorAutoEager = bl4;
            this.failOnException = level2;
            this.failOnMessage = level;
            this.hideExtraModules = bl5;
        }

        static Configuration create(Class<? extends TestCase> clazz) {
            return new Configuration(null, null, null, ClassLoader.getSystemClassLoader().getParent(), Collections.emptyList(), clazz, false, true, true, false, null, null, false);
        }

        public Configuration clusters(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.clusterRegExp != null) {
                arrayList.addAll(this.clusterRegExp);
            }
            if (string != null) {
                arrayList.add(string);
            }
            if (arrayList.isEmpty()) {
                arrayList = null;
            }
            return new Configuration(arrayList, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        public Configuration enableModules(String string) {
            if (string == null) {
                return this;
            }
            return this.enableModules(".*", string);
        }

        public Configuration enableModules(String string, String string2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.moduleRegExp != null) {
                arrayList.addAll(this.moduleRegExp);
            }
            arrayList.add(string);
            arrayList.add(string2);
            return new Configuration(this.clusterRegExp, arrayList, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        public Configuration addStartupArgument(String ... stringArray) {
            if (stringArray == null || stringArray.length < 1) {
                throw new IllegalStateException("Must specify at least one startup argument");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.startupArgs != null) {
                arrayList.addAll(this.startupArgs);
            }
            arrayList.addAll(Arrays.asList(stringArray));
            return new Configuration(this.clusterRegExp, this.moduleRegExp, arrayList, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        Configuration classLoader(ClassLoader classLoader) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, classLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        public Configuration addTest(String ... stringArray) {
            if (this.latestTestCaseClass == null) {
                throw new IllegalStateException();
            }
            ArrayList<Item> arrayList = new ArrayList<Item>(this.tests);
            arrayList.add(new Item(true, this.latestTestCaseClass, stringArray));
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, arrayList, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        public Configuration addTest(Class<? extends TestCase> clazz, String ... stringArray) {
            if (clazz.equals(this.latestTestCaseClass)) {
                return this.addTest(stringArray);
            }
            ArrayList<Item> arrayList = new ArrayList<Item>(this.tests);
            this.addLatest(arrayList);
            if (stringArray != null && stringArray.length != 0) {
                arrayList.add(new Item(true, clazz, stringArray));
            }
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, arrayList, clazz, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        public Configuration addTest(Class<? extends Test> clazz) {
            if (TestCase.class.isAssignableFrom(clazz)) {
                Class<TestCase> clazz2 = clazz.asSubclass(TestCase.class);
                return this.addTest(clazz2, new String[0]);
            }
            ArrayList<Item> arrayList = new ArrayList<Item>(this.tests);
            arrayList.add(new Item(false, clazz, null));
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, arrayList, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        public Configuration enableClasspathModules(boolean bl) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, bl, this.honorAutoEager, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        public Configuration honorAutoloadEager(boolean bl) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, bl, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        public Configuration hideExtraModules(boolean bl) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException, bl);
        }

        public Configuration failOnMessage(Level level) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, level, this.failOnException, this.hideExtraModules);
        }

        public Configuration failOnException(Level level) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, level, this.hideExtraModules);
        }

        private void addLatest(List<Item> list) {
            if (this.latestTestCaseClass == null) {
                return;
            }
            for (Item item : list) {
                if (!item.clazz.equals(this.latestTestCaseClass)) continue;
                return;
            }
            list.add(new Item(true, this.latestTestCaseClass, null));
        }

        private Configuration getReady() {
            ArrayList<Item> arrayList = new ArrayList<Item>(this.tests);
            this.addLatest(arrayList);
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, arrayList, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        public Configuration gui(boolean bl) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, bl, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        public Configuration reuseUserDir(boolean bl) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, this.parentClassLoader, this.tests, this.latestTestCaseClass, bl, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        public Configuration parentClassLoader(ClassLoader classLoader) {
            return new Configuration(this.clusterRegExp, this.moduleRegExp, this.startupArgs, classLoader, this.tests, this.latestTestCaseClass, this.reuseUserDir, this.gui, this.enableClasspathModules, this.honorAutoEager, this.failOnMessage, this.failOnException, this.hideExtraModules);
        }

        public Test suite() {
            return new S(this);
        }
    }
}

