/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import junit.framework.Assert;

final class ControlFlow {
    ControlFlow() {
    }

    static void registerSwitches(Logger logger, Logger logger2, URL uRL, int n) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = uRL.openStream();
        while ((n2 = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n2);
        }
        byteArrayOutputStream.close();
        inputStream.close();
        ControlFlow.registerSwitches(logger, logger2, new String(byteArrayOutputStream.toByteArray(), "utf-8"), n);
    }

    static void registerSwitches(Logger logger, Logger logger2, String string, int n) {
        int n2;
        LinkedList<Switch> linkedList = new LinkedList<Switch>();
        HashMap<String, Pattern> hashMap = new HashMap<String, Pattern>();
        int n3 = 0;
        while ((n2 = string.indexOf("THREAD:", n3)) != -1) {
            int n4;
            int n5 = string.indexOf("MSG:", n2);
            if (n5 == -1) {
                Assert.fail((String)("After THREAD: there must be MSG: " + string.substring(n2)));
            }
            if ((n4 = string.indexOf("THREAD:", n5)) == -1) {
                n4 = string.length();
            }
            String string2 = string.substring(n3 + 7, n5).trim();
            String string3 = string.substring(n5 + 4, n4).trim();
            Pattern pattern = (Pattern)hashMap.get(string3);
            if (pattern == null) {
                pattern = Pattern.compile(string3);
                hashMap.put(string3, pattern);
            }
            Switch switch_ = new Switch(string2, pattern);
            linkedList.add(switch_);
            n3 = n4;
        }
        ErrManager errManager = new ErrManager(linkedList, logger, logger2, n);
        logger.addHandler(errManager);
    }

    private static final class Switch {
        private Pattern msg;
        private String name;

        public Switch(String string, Pattern pattern) {
            this.name = string;
            this.msg = pattern;
        }

        public boolean matchesThread() {
            String string = Thread.currentThread().getName();
            return this.name.equals(string);
        }

        public boolean matchesMessage(String string) {
            return this.msg.matcher(string).matches();
        }

        public String toString() {
            return "Switch[" + this.name + "]: " + this.msg;
        }
    }

    private static final class ErrManager
    extends Handler {
        private LinkedList<Switch> switches;
        private int timeout;
        private Map<String, Thread> threads = new HashMap<String, Thread>();
        private Logger msg;
        private Logger assigned;

        public ErrManager(LinkedList<Switch> linkedList, Logger logger, Logger logger2, int n) {
            this.switches = linkedList;
            this.msg = logger2;
            this.timeout = n;
            this.assigned = logger;
            this.setLevel(Level.FINEST);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void publish(LogRecord logRecord) {
            if (this.switches == null) {
                this.assigned.removeHandler(this);
                return;
            }
            String string = logRecord.getMessage();
            if (string != null && logRecord.getParameters() != null) {
                string = MessageFormat.format(string, logRecord.getParameters());
            }
            boolean bl = this.msg != null;
            boolean bl2 = false;
            while (true) {
                LinkedList<Switch> linkedList = this.switches;
                synchronized (linkedList) {
                    if (this.switches.isEmpty()) {
                        return;
                    }
                    Switch switch_ = this.switches.getFirst();
                    String string2 = Thread.currentThread().getName();
                    boolean bl3 = false;
                    if (switch_.matchesThread()) {
                        if (!switch_.matchesMessage(string)) {
                            return;
                        }
                        this.switches.removeFirst();
                        if (this.switches.isEmpty()) {
                            this.switches.notifyAll();
                            return;
                        }
                        switch_ = this.switches.getFirst();
                        if (switch_.matchesThread()) {
                            return;
                        }
                        bl2 = true;
                        bl3 = true;
                    } else {
                        for (Switch switch_2 : this.switches) {
                            if (!switch_2.matchesMessage(string)) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    Thread thread = this.threads.get(switch_.name);
                    if (thread != null) {
                        if (bl) {
                            this.loginternal("t: " + string2 + " interrupts: " + thread.getName());
                        }
                        thread.interrupt();
                    }
                    this.threads.put(string2, Thread.currentThread());
                    if (!bl2) {
                        return;
                    }
                    Thread.interrupted();
                    try {
                        if (bl) {
                            this.loginternal("t: " + string2 + " log: " + string + " waiting");
                        }
                        this.switches.wait(this.timeout);
                        if (bl) {
                            this.loginternal("t: " + string2 + " log: " + string + " timeout");
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        if (bl) {
                            this.loginternal("t: " + string2 + " log: " + string + " interrupted");
                        }
                        if (bl3) {
                            return;
                        }
                    }
                }
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }

        private void loginternal(String string) {
            this.msg.info(string);
        }
    }
}

