/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util;

import com.oracle.bmc.io.internal.WrappedByteArrayInputStream;
import com.oracle.bmc.io.internal.WrappedFileInputStream;
import com.oracle.bmc.util.internal.Validate;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StreamUtils.class);

    private StreamUtils() {
    }

    public static void closeQuietly(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.debug("Did not close steam successfully", (Throwable)e);
            }
        }
    }

    public static InputStream toInputStream(File file) {
        return WrappedFileInputStream.create(file);
    }

    public static ByteArrayInputStream createByteArrayInputStream(byte[] buffer) {
        return new WrappedByteArrayInputStream(buffer);
    }

    public static String toString(InputStream is, Charset charset) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, charset));){
            int ch;
            while ((ch = ((Reader)reader).read()) != -1) {
                sb.append((char)ch);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return sb.toString();
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        byte[] buf = new byte[4096];
        int bytesRead = 0;
        while (-1 != (bytesRead = inputStream.read(buf))) {
            baos.write(buf, 0, bytesRead);
        }
        return baos.toByteArray();
    }

    public static Optional<String> contentDiffers(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        int ch;
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        long offset = 0L;
        while (-1 != (ch = input1.read())) {
            ch2 = input2.read();
            if (ch != ch2) {
                return Optional.of(String.format("At offset %d: %d != %d", offset, ch, ch2));
            }
            ++offset;
        }
        ch2 = input2.read();
        if (ch != ch2) {
            return Optional.of(String.format("At offset %d: %d != %d", offset, ch, ch2));
        }
        return Optional.empty();
    }

    public static long skipBytesInStream(InputStream is, long count) throws IOException {
        int read;
        long bytesRead;
        for (bytesRead = 0L; bytesRead < count && (read = is.read()) != -1; ++bytesRead) {
        }
        return bytesRead;
    }

    public static InputStream limitRemainingStreamLength(final InputStream is, final long limit) {
        Validate.notNull(is, "input stream must not be null", new Object[0]);
        InputStream limitedStream = new InputStream(){
            private volatile long remainingBytes;
            {
                this.remainingBytes = limit;
            }

            @Override
            public synchronized int read() throws IOException {
                if (this.remainingBytes > 0L) {
                    --this.remainingBytes;
                    return is.read();
                }
                return -1;
            }
        };
        return new BufferedInputStream(limitedStream);
    }
}

