/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.internal;

import com.oracle.bmc.util.internal.Validate;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

public class ClientThreadFactory
implements ThreadFactory {
    private final String nameFormat;
    private final Boolean isDaemon;
    private final AtomicLong count = new AtomicLong(0L);

    private ClientThreadFactory(@Nonnull String nameFormat, Boolean isDaemon) {
        this.nameFormat = nameFormat;
        this.isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        if (this.nameFormat != null) {
            thread.setName(String.format(this.nameFormat, this.count.getAndIncrement()));
        }
        if (this.isDaemon != null) {
            thread.setDaemon(this.isDaemon);
        }
        return thread;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String nameFormat;
        private Boolean isDaemon;

        public Builder isDaemon(boolean isDaemon) {
            this.isDaemon = isDaemon;
            return this;
        }

        public Builder nameFormat(String nameFormat) {
            this.nameFormat = nameFormat;
            return this;
        }

        public ClientThreadFactory build() {
            Validate.notBlank(this.nameFormat, "nameFormat must not be blank", new Object[0]);
            return new ClientThreadFactory(this.nameFormat, this.isDaemon);
        }
    }
}

