/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing.internal;

import com.oracle.bmc.http.signing.internal.SignedRequestException;
import com.oracle.bmc.util.internal.Validate;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class SignatureSigner {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureSigner.class);

    @Nonnull
    public byte[] sign(@Nonnull RSAPrivateKey privateKey, @Nonnull byte[] message, @Nonnull String algorithm) {
        Validate.isTrue(null != privateKey, "privateKey must not be null", new Object[0]);
        Validate.isTrue(null != message && 0 < message.length, "message must not be null or empty", new Object[0]);
        Validate.notBlank(algorithm, "algorithm must be set to non-blank string", new Object[0]);
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey);
            signature.update(message);
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            LOG.debug("Error signing message", (Throwable)e);
            throw new SignedRequestException(e);
        }
    }
}

