/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing.internal;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.signing.internal.BouncyCastleHelper;
import com.oracle.bmc.http.signing.internal.KeySupplier;
import com.oracle.bmc.internal.GuavaUtils;
import com.oracle.bmc.util.internal.Validate;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPrivateKey;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PEMFileRSAPrivateKeySupplier
implements KeySupplier<RSAPrivateKey> {
    private static final Logger LOG = LoggerFactory.getLogger(PEMFileRSAPrivateKeySupplier.class);
    private final JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
    private final RSAPrivateKey key;

    public PEMFileRSAPrivateKeySupplier(@Nonnull InputStream inputStream, @Nullable char[] passphraseCharacters) {
        try {
            LOG.debug("Initializing private key");
            try (PEMParser keyReader = new PEMParser((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                PrivateKeyInfo keyInfo;
                Object object = keyReader.readObject();
                if (object instanceof PEMEncryptedKeyPair) {
                    Validate.notNull(passphraseCharacters, "The provided private key requires a passphrase", new Object[0]);
                    JcePEMDecryptorProviderBuilder decryptorProviderBuilder = new JcePEMDecryptorProviderBuilder();
                    if (!BouncyCastleHelper.getInstance().isProviderInstalled()) {
                        decryptorProviderBuilder.setProvider(BouncyCastleHelper.getInstance().getBouncyCastleProvider());
                    }
                    PEMDecryptorProvider decProv = decryptorProviderBuilder.build(passphraseCharacters);
                    try {
                        keyInfo = ((PEMEncryptedKeyPair)object).decryptKeyPair(decProv).getPrivateKeyInfo();
                    }
                    catch (EncryptionException ex) {
                        throw new IllegalArgumentException("The provided passphrase is incorrect.", ex);
                    }
                } else if (object instanceof PrivateKeyInfo) {
                    keyInfo = (PrivateKeyInfo)object;
                } else if (object instanceof PEMKeyPair) {
                    keyInfo = ((PEMKeyPair)object).getPrivateKeyInfo();
                } else {
                    if (object instanceof SubjectPublicKeyInfo) {
                        throw new IllegalArgumentException("Public key provided instead of private key");
                    }
                    if (object != null) {
                        throw new IllegalArgumentException("Private key must be in PEM format, was: " + object.getClass());
                    }
                    throw new IllegalArgumentException("Private key must be in PEM format");
                }
                this.key = (RSAPrivateKey)this.converter.getPrivateKey(keyInfo);
            }
        }
        catch (IOException ex) {
            LOG.debug("Failed to read RSA private key from file ", (Throwable)ex);
            throw new PEMFileRSAPrivateKeySupplierException(ex);
        }
    }

    @Override
    @InternalSdk(backwardCompatibilityRequired=true)
    public Optional<RSAPrivateKey> supplyKey(@Nonnull String ignored) {
        return this.supplyKey();
    }

    @Override
    @Deprecated
    @InternalSdk(backwardCompatibilityRequired=true)
    public com.google.common.base.Optional<RSAPrivateKey> getKey(@Nonnull String ignored) {
        return GuavaUtils.adaptToGuava(this.supplyKey(ignored));
    }

    @Nonnull
    @InternalSdk(backwardCompatibilityRequired=true)
    public Optional<RSAPrivateKey> supplyKey() {
        return Optional.of(this.key);
    }

    @Deprecated
    @Nonnull
    @InternalSdk(backwardCompatibilityRequired=true)
    public com.google.common.base.Optional<RSAPrivateKey> getKey() {
        return GuavaUtils.adaptToGuava(this.supplyKey());
    }

    public static class PEMFileRSAPrivateKeySupplierException
    extends RuntimeException {
        public PEMFileRSAPrivateKeySupplierException(String message, Throwable cause) {
            super(message, cause);
        }

        public PEMFileRSAPrivateKeySupplierException(Throwable cause) {
            super(cause);
        }
    }
}

