/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.waiter.MaxAttemptsTerminationStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import javax.annotation.Nonnull;

public class RetryUtils {
    private static final String OPC_CLIENT_RETRIES_HEADER = "opc-client-retries";

    public static void setClientRetriesHeader(@Nonnull WrappedInvocationBuilder ib, @Nonnull BmcGenericRetrier retrier) {
        if (ib == null) {
            throw new NullPointerException("ib is marked non-null but is null");
        }
        if (retrier == null) {
            throw new NullPointerException("retrier is marked non-null but is null");
        }
        if (ib.getHeaders() != null && ib.getHeaders().getFirst((Object)OPC_CLIENT_RETRIES_HEADER) != null) {
            return;
        }
        TerminationStrategy terminationStrategy = retrier.getWaiter().getWaiterConfiguration().getTerminationStrategy();
        boolean sendOpcClientRetries = false;
        if (terminationStrategy instanceof MaxAttemptsTerminationStrategy && ((MaxAttemptsTerminationStrategy)terminationStrategy).getMaxAttempts() > 1) {
            sendOpcClientRetries = true;
        }
        ib.header(OPC_CLIENT_RETRIES_HEADER, sendOpcClientRetries);
    }
}

