/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.Options;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.Serialization;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.io.internal.AutoCloseableContentLengthVerifyingInputStream;
import com.oracle.bmc.io.internal.ContentLengthVerifyingInputStream;
import com.oracle.bmc.io.internal.WrappedResponseInputStream;
import com.oracle.bmc.model.BmcException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHelper.class);
    private static final ObjectReader STRING_READER = Serialization.getObjectMapper().readerFor(String.class);
    private static final int MAX_RESPONSE_BUFFER_BYTES = 4096;
    private static final String OPC_REQUEST_ID_HEADER = "opc-request-id";
    private static final Map<Integer, String> DEFAULT_ERROR_MESSAGES = new HashMap<Integer, String>();

    public static void throwIfNotSuccessful(@Nonnull Response response) {
        ResponseHelper.throwIfNotSuccessful(response, ServiceDetails.UNKNOWN_SERVICE_DETAILS);
    }

    public static void throwIfNotSuccessful(@Nonnull Response response, @Nonnull ServiceDetails serviceDetails) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Response response2 = response;
        synchronized (response2) {
            if (Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
                return;
            }
            if (response.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode()) {
                return;
            }
            String opcRequestId = response.getHeaderString(OPC_REQUEST_ID_HEADER);
            if (!ResponseHelper.typeEqual(MediaType.APPLICATION_JSON_TYPE, response.getMediaType())) {
                String responseBody = "Cannot read response body!";
                try {
                    responseBody = (String)response.readEntity(String.class);
                }
                catch (ProcessingException e) {
                    LOG.warn("Unable to read response body", (Throwable)e);
                }
                try {
                    throw new BmcException(response.getStatus(), "Unknown", String.format("Unexpected Content-Type: %s instead of %s. Response body: %s", response.getMediaType(), MediaType.APPLICATION_JSON_TYPE, responseBody), opcRequestId, serviceDetails);
                }
                catch (Throwable throwable) {
                    ResponseHelper.closeResponseSilently(response);
                    throw throwable;
                }
            }
            boolean isBuffered = false;
            try {
                ErrorCodeAndMessage errorCodeAndMessage;
                if (response.getLength() < 4096) {
                    try {
                        isBuffered = response.bufferEntity();
                    }
                    catch (IllegalStateException e) {
                        LOG.info("Unable to buffer response entity as the response has already been closed", (Throwable)e);
                    }
                }
                if ((errorCodeAndMessage = (ErrorCodeAndMessage)response.readEntity(ErrorCodeAndMessage.class)) == null) {
                    String message = DEFAULT_ERROR_MESSAGES.get(response.getStatus());
                    throw new BmcException(response.getStatus(), "Unknown", message != null ? message : "Detailed exception information not available", opcRequestId, serviceDetails);
                }
                throw new BmcException(response.getStatus(), errorCodeAndMessage.getCode(), errorCodeAndMessage.getMessage(), opcRequestId, serviceDetails, errorCodeAndMessage.getOriginalMessage(), errorCodeAndMessage.getOriginalMessageTemplate(), errorCodeAndMessage.getMessageArguments());
            }
            catch (ProcessingException e) {
                String message = isBuffered ? "Unable to parse error response: " + (String)response.readEntity(String.class) : "Unable to parse error response.";
                int status = response.getStatus();
                ResponseHelper.closeResponseSilently(response);
                throw new BmcException(status, "Unknown", message, opcRequestId, e, serviceDetails);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readWithoutEntity(@Nonnull Response response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Response response2 = response;
        synchronized (response2) {
            ResponseHelper.closeResponseSilently(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readEntity(@Nonnull Response response, GenericType<T> entityType) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Response response2 = response;
        synchronized (response2) {
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                response.bufferEntity();
                return (T)response.readEntity(entityType);
            }
            if (response.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode()) {
                ResponseHelper.closeResponseSilently(response);
                return null;
            }
        }
        throw new IllegalStateException("Attempted to read entity from unsuccessful response, should have called throwIfNotSuccessful first");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readEntity(@Nonnull Response response, Class<T> entityType) throws BmcException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Response response2 = response;
        synchronized (response2) {
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                if (entityType == InputStream.class) {
                    long contentLength;
                    List contentType = (List)response.getHeaders().remove((Object)"Content-Type");
                    LOG.debug("Entity type is InputStream, ignoring contentType {} and processing as stream", (Object)contentType);
                    InputStream rawInputStream = (InputStream)response.readEntity(InputStream.class);
                    InputStream inputStream = new WrappedResponseInputStream(rawInputStream, response);
                    Optional<List<String>> contentLengthHeader = HeaderUtils.getHeadersWithName((MultivaluedMap<String, String>)response.getStringHeaders(), "Content-Length");
                    if (contentLengthHeader.isPresent() && response.getHeaders().get((Object)"Content-Encoding") == null && (contentLength = HeaderUtils.toValue("Content-Length", contentLengthHeader.get().get(0), Long.class).longValue()) > 0L) {
                        if (Options.getShouldAutoCloseResponseInputStream()) {
                            if (ApacheUtils.isExtraStreamLogsEnabled()) {
                                LOG.warn("Wrapping response stream into auto closeable stream, to disable this, please use " + Options.class.getName() + ".shouldAutoCloseResponseInputStream(false)");
                            }
                            inputStream = new AutoCloseableContentLengthVerifyingInputStream(inputStream, contentLength);
                        } else {
                            inputStream = new ContentLengthVerifyingInputStream(inputStream, contentLength);
                        }
                    }
                    T t = entityType.cast(inputStream);
                    return t;
                    finally {
                        if (contentType != null) {
                            response.getHeaders().addAll((Object)"Content-Type", contentType);
                        }
                    }
                }
                response.bufferEntity();
                Object entity = response.readEntity(entityType);
                Object entityAsJsonString = ResponseHelper.readResponseAsJsonString(entity, response, entityType);
                if (entityAsJsonString != null) {
                    return (T)entityAsJsonString;
                }
                return (T)entity;
            }
            if (response.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode()) {
                ResponseHelper.closeResponseSilently(response);
                return null;
            }
            throw new IllegalStateException("Attempted to read entity from unsuccessful response, should have called throwIfNotSuccessful first");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeResponseSilently(Response response) {
        Response response2 = response;
        synchronized (response2) {
            try {
                response.close();
            }
            catch (Throwable t) {
                LOG.debug("Exception while closing response", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeResponseSilentlyIfNotBuffered(@Nonnull Response response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        Response response2 = response;
        synchronized (response2) {
            boolean isResponseAlreadyClosed = true;
            try {
                isResponseAlreadyClosed = response.bufferEntity();
            }
            catch (IllegalStateException ex) {
                LOG.trace("Exception while buffering the entity before closing the response", (Throwable)ex);
            }
            if (!isResponseAlreadyClosed) {
                ResponseHelper.closeResponseSilently(response);
            }
        }
    }

    private static boolean typeEqual(MediaType m1, MediaType m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return m1.getSubtype().equalsIgnoreCase(m2.getSubtype()) && m1.getType().equalsIgnoreCase(m2.getType());
    }

    private static <T> T readResponseAsJsonString(T entity, Response response, Class<T> entityType) {
        String contentType = response.getHeaderString("Content-Type");
        if (contentType == null) {
            return null;
        }
        if (!"application/json".equalsIgnoreCase(contentType)) {
            return null;
        }
        if (entityType != String.class) {
            return null;
        }
        String stringEntity = (String)entity;
        if (stringEntity.startsWith("\"") && stringEntity.endsWith("\"")) {
            try {
                return entityType.cast(STRING_READER.readValue(stringEntity));
            }
            catch (IOException e) {
                LOG.error("Unable to extract string response", (Throwable)e);
            }
        }
        return null;
    }

    @Deprecated
    public static void shouldAutoCloseResponseInputStream(boolean shouldAutoClose) {
        Options.shouldAutoCloseResponseInputStream(shouldAutoClose);
    }

    static {
        DEFAULT_ERROR_MESSAGES.put(Response.Status.NOT_FOUND.getStatusCode(), "The resource does not exist or the request was not authorized");
        DEFAULT_ERROR_MESSAGES.put(Response.Status.PRECONDITION_FAILED.getStatusCode(), "Precondition failed");
    }

    @JsonDeserialize(builder=Builder.class)
    public static final class ErrorCodeAndMessage {
        private final String code;
        private final String message;
        private final String originalMessage;
        private final String originalMessageTemplate;
        private final Map<String, String> messageArguments;

        @ConstructorProperties(value={"code", "message", "originalMessage", "originalMessageTemplate", "messageArguments"})
        ErrorCodeAndMessage(String code, String message, String originalMessage, String originalMessageTemplate, Map<String, String> messageArguments) {
            this.code = code;
            this.message = message;
            this.originalMessage = originalMessage;
            this.originalMessageTemplate = originalMessageTemplate;
            this.messageArguments = messageArguments;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String getOriginalMessage() {
            return this.originalMessage;
        }

        public String getOriginalMessageTemplate() {
            return this.originalMessageTemplate;
        }

        public Map<String, String> getMessageArguments() {
            return this.messageArguments;
        }

        public boolean equals(Object o) {
            Map<String, String> other$messageArguments;
            String other$originalMessageTemplate;
            String other$originalMessage;
            String other$message;
            String other$code;
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorCodeAndMessage)) {
                return false;
            }
            ErrorCodeAndMessage other = (ErrorCodeAndMessage)o;
            String this$code = this.getCode();
            if (!Objects.equals(this$code, other$code = other.getCode())) {
                return false;
            }
            String this$message = this.getMessage();
            if (!Objects.equals(this$message, other$message = other.getMessage())) {
                return false;
            }
            if (!Objects.equals(this$message, other$message)) {
                return false;
            }
            String this$originalMessage = this.getOriginalMessage();
            if (!Objects.equals(this$originalMessage, other$originalMessage = other.getOriginalMessage())) {
                return false;
            }
            String this$originalMessageTemplate = this.getOriginalMessageTemplate();
            if (!Objects.equals(this$originalMessageTemplate, other$originalMessageTemplate = other.getOriginalMessageTemplate())) {
                return false;
            }
            Map<String, String> this$messageArguments = this.getMessageArguments();
            return Objects.equals(this$messageArguments, other$messageArguments = other.getMessageArguments());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $originalMessage = this.getOriginalMessage();
            result = result * 59 + ($originalMessage == null ? 43 : $originalMessage.hashCode());
            String $originalMessageTemplate = this.getOriginalMessageTemplate();
            result = result * 59 + ($originalMessageTemplate == null ? 43 : $originalMessageTemplate.hashCode());
            Map<String, String> $messageArguments = this.getMessageArguments();
            result = result * 59 + ($messageArguments == null ? 43 : ((Object)$messageArguments).hashCode());
            return result;
        }

        public String toString() {
            return "ResponseHelper.ErrorCodeAndMessage(code=" + this.getCode() + ", message=" + this.getMessage() + ", originalMessage=" + this.getOriginalMessage() + ", originalMessageTemplate=" + this.getOriginalMessageTemplate() + ", templateArguments=" + this.getMessageArguments() + ")";
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private String code;
            private String message;
            private String originalMessage;
            private String originalMessageTemplate;
            private Map<String, String> messageArguments;

            Builder() {
            }

            public Builder code(String code) {
                this.code = code;
                return this;
            }

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Builder originalMessage(String originalMessage) {
                this.originalMessage = originalMessage;
                return this;
            }

            public Builder originalMessageTemplate(String originalMessageTemplate) {
                this.originalMessageTemplate = originalMessageTemplate;
                return this;
            }

            public Builder messageArguments(Map<String, String> messageArguments) {
                this.messageArguments = messageArguments;
                return this;
            }

            public ErrorCodeAndMessage build() {
                return new ErrorCodeAndMessage(this.code, this.message, this.originalMessage, this.originalMessageTemplate, this.messageArguments);
            }

            public String toString() {
                return "ResponseHelper.ErrorCodeAndMessage.Builder(code=" + this.code + ", message=" + this.message + ")";
            }
        }
    }
}

