/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.auth.internal.JwtClaimsSet;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SecurityTokenAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityTokenAdapter.class);
    private final Optional<JwtClaimsSet> jwt;
    private final SessionKeySupplier sessionKeySupplier;
    private final String securityToken;

    SecurityTokenAdapter(String securityToken, SessionKeySupplier sessionKeySupplier) {
        this.securityToken = securityToken;
        this.jwt = securityToken != null && !securityToken.isEmpty() ? Optional.of(new JwtClaimsSet(securityToken)) : Optional.empty();
        this.sessionKeySupplier = sessionKeySupplier;
    }

    boolean isValid() {
        return this.isValid(Optional.empty());
    }

    boolean isValid(Optional<Duration> time) {
        if (!this.jwt.isPresent()) {
            LOG.debug("Security token is not valid.");
            return false;
        }
        try {
            Date exp = this.jwt.get().getExpirationTime();
            if (exp != null) {
                Duration bufferTime;
                Duration duration = bufferTime = time.isPresent() ? time.get() : Duration.ZERO;
                if (exp.toInstant().minus(bufferTime).isAfter(Instant.now())) {
                    Optional<RSAPublicKey> jwkRsa;
                    LOG.debug("Security token is not expired");
                    String jwk = this.jwt.get().getStringClaim("jwk");
                    if (jwk != null && (jwkRsa = AuthUtils.toPublicKeyFromJson(jwk)).isPresent() && this.isEqualPublicKey(jwkRsa.get(), (RSAPublicKey)this.sessionKeySupplier.getKeyPair().getPublic())) {
                        LOG.debug("Security token is still valid. Public key matches with the JWK.");
                        return true;
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.debug("JWT parsing failed");
            return false;
        }
        catch (ParseException e) {
            LOG.debug("JWT parsing failed");
            return false;
        }
        return false;
    }

    private boolean isEqualPublicKey(RSAPublicKey a, RSAPublicKey b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException("Public key cannot be null");
        }
        String encodedKey1 = AuthUtils.base64EncodeNoChunking(a);
        String encodedKey2 = AuthUtils.base64EncodeNoChunking(b);
        return encodedKey1.equals(encodedKey2);
    }

    public String getStringClaim(String key) {
        if (!this.jwt.isPresent()) {
            LOG.debug("Security token is not valid.");
            return null;
        }
        try {
            return this.jwt.get().getStringClaim(key);
        }
        catch (ParseException e) {
            throw new IllegalStateException("JWT parsing failed");
        }
    }

    public String getSecurityToken() {
        return this.securityToken;
    }
}

