/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.AbstractFederationClientAuthenticationDetailsProviderBuilder;
import com.oracle.bmc.auth.internal.AbstractTemplateRptPathProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImdsRptPathProvider
extends AbstractTemplateRptPathProvider {
    private static final String IMDS_PATH_TEMPLATE = "/20180711/resourcePrincipalToken/{id}";
    protected static final String METADATA_SERVICE_BASE_URL = "http://169.254.169.254/opc/v2/";
    private static final String AUTHORIZATION_HEADER_VALUE = "Bearer Oracle";
    private static final Logger LOG = LoggerFactory.getLogger(ImdsRptPathProvider.class);
    private final Map<String, String> replacements = ImdsRptPathProvider.buildReplacements();

    public ImdsRptPathProvider(String pathTemplate) {
        super(pathTemplate);
    }

    @Override
    protected Map<String, String> getReplacements() {
        return this.replacements;
    }

    static String getPathTemplate() {
        return IMDS_PATH_TEMPLATE;
    }

    static Map<String, String> buildReplacements() {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("id", ImdsRptPathProvider.getInstanceIdFromIMDS());
        return Collections.unmodifiableMap(replacements);
    }

    private static String getInstanceIdFromIMDS() {
        String INSTANCE_ID = "id";
        String instanceId = (String)AbstractFederationClientAuthenticationDetailsProviderBuilder.simpleRetry(base -> {
            String instanceIdentity = (String)base.path("id").request(new String[]{"text/plain"}).header("Authorization", (Object)AUTHORIZATION_HEADER_VALUE).get(String.class);
            return instanceIdentity;
        }, METADATA_SERVICE_BASE_URL, "id");
        return instanceId;
    }
}

