/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import java.math.BigDecimal;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PCTemplate;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.BigDecimalHelper;

public class FaceToken
extends AbstractNonEmptyToken<PCTemplate>
implements CDOMPrimaryToken<PCTemplate> {
    public String getTokenName() {
        return "FACE";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, PCTemplate template, String value) {
        return this.parseFace(context, template, value);
    }

    protected ParseResult parseFace(LoadContext context, PCTemplate fObj, String value) {
        int commaLoc = value.indexOf(",");
        if (commaLoc != value.lastIndexOf(",")) {
            return new ParseResult.Fail(this.getTokenName() + " must be of the form: " + this.getTokenName() + ":<num>[,<num>]", context);
        }
        if (commaLoc > -1) {
            if (commaLoc == 0) {
                return new ParseResult.Fail(this.getTokenName() + " should not start with a comma.  Must be of the form: " + this.getTokenName() + ":<num>[,<num>]", context);
            }
            if (commaLoc == value.length() - 1) {
                return new ParseResult.Fail(this.getTokenName() + " should not end with a comma.  Must be of the form: " + this.getTokenName() + ":<num>[,<num>]", context);
            }
            try {
                String widthString = value.substring(0, commaLoc).trim();
                BigDecimal width = new BigDecimal(widthString);
                if (width.compareTo(BigDecimal.ZERO) < 0) {
                    return new ParseResult.Fail("Cannot have negative width in " + this.getTokenName() + ": " + value, context);
                }
                context.getObjectContext().put((CDOMObject)fObj, ObjectKey.FACE_WIDTH, (Object)width);
            }
            catch (NumberFormatException nfe) {
                return new ParseResult.Fail("Misunderstood Double Width in Tag: " + value, context);
            }
            try {
                String heightString = value.substring(commaLoc + 1).trim();
                BigDecimal height = new BigDecimal(heightString);
                if (height.compareTo(BigDecimal.ZERO) < 0) {
                    return new ParseResult.Fail("Cannot have negative height in " + this.getTokenName() + ": " + value, context);
                }
                context.getObjectContext().put((CDOMObject)fObj, ObjectKey.FACE_HEIGHT, (Object)height);
            }
            catch (NumberFormatException ne) {
                return new ParseResult.Fail("Misunderstood Double Height in Tag: " + value, context);
            }
        }
        try {
            String widthString = value;
            BigDecimal width = new BigDecimal(widthString);
            if (width.compareTo(BigDecimal.ZERO) < 0) {
                return new ParseResult.Fail("Cannot have negative width in " + this.getTokenName() + ": " + value, context);
            }
            context.getObjectContext().put((CDOMObject)fObj, ObjectKey.FACE_WIDTH, (Object)width);
            context.getObjectContext().put((CDOMObject)fObj, ObjectKey.FACE_HEIGHT, (Object)BigDecimal.ZERO);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail("Misunderstood Double in Tag: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCTemplate pct) {
        BigDecimal width = (BigDecimal)context.getObjectContext().getObject((CDOMObject)pct, ObjectKey.FACE_WIDTH);
        BigDecimal height = (BigDecimal)context.getObjectContext().getObject((CDOMObject)pct, ObjectKey.FACE_HEIGHT);
        if (width == null && height == null) {
            return null;
        }
        if (width == null || height == null) {
            context.addWriteMessage("Must have both width and height in " + this.getTokenName() + ": " + width + " " + height);
            return null;
        }
        if (width.compareTo(BigDecimal.ZERO) < 0) {
            context.addWriteMessage("Cannot have negative width in " + this.getTokenName() + ": " + width);
            return null;
        }
        if (height.compareTo(BigDecimal.ZERO) < 0) {
            context.addWriteMessage("Cannot have negative height in " + this.getTokenName() + ": " + height);
            return null;
        }
        StringBuilder sb = new StringBuilder();
        BigDecimal w = BigDecimalHelper.trimBigDecimal((BigDecimal)width);
        sb.append(w);
        if (height.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal h = BigDecimalHelper.trimBigDecimal((BigDecimal)height);
            sb.append(',').append(h);
        }
        return new String[]{sb.toString()};
    }

    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }
}

