/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.substitute;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.substitute.AttributeValue;
import org.apache.fop.fonts.substitute.FontWeightRange;

public class FontQualifier {
    private static Log log = LogFactory.getLog((Class)FontQualifier.class);
    private AttributeValue fontFamilyAttributeValue = null;
    private AttributeValue fontStyleAttributeValue = null;
    private AttributeValue fontWeightAttributeValue = null;

    public void setFontFamily(String fontFamily) {
        AttributeValue fontFamilyAttribute = AttributeValue.valueOf(fontFamily);
        if (fontFamilyAttribute == null) {
            log.error((Object)("Invalid font-family value '" + fontFamily + "'"));
            return;
        }
        this.fontFamilyAttributeValue = fontFamilyAttribute;
    }

    public void setFontStyle(String fontStyle) {
        AttributeValue fontStyleAttribute = AttributeValue.valueOf(fontStyle);
        if (fontStyleAttribute != null) {
            this.fontStyleAttributeValue = fontStyleAttribute;
        }
    }

    public void setFontWeight(String fontWeight) {
        AttributeValue fontWeightAttribute = AttributeValue.valueOf(fontWeight);
        if (fontWeightAttribute != null) {
            Iterator it = fontWeightAttribute.iterator();
            while (it.hasNext()) {
                Object weightObj = it.next();
                if (!(weightObj instanceof String)) continue;
                String weightString = ((String)weightObj).trim();
                try {
                    FontUtil.parseCSS2FontWeight(weightString);
                }
                catch (IllegalArgumentException ex) {
                    log.error((Object)("Invalid font-weight value '" + weightString + "'"));
                    return;
                }
            }
            this.fontWeightAttributeValue = fontWeightAttribute;
        }
    }

    public AttributeValue getFontFamily() {
        return this.fontFamilyAttributeValue;
    }

    public AttributeValue getFontStyle() {
        if (this.fontStyleAttributeValue == null) {
            return AttributeValue.valueOf("normal");
        }
        return this.fontStyleAttributeValue;
    }

    public AttributeValue getFontWeight() {
        if (this.fontWeightAttributeValue == null) {
            return AttributeValue.valueOf(Integer.toString(400));
        }
        return this.fontWeightAttributeValue;
    }

    public boolean hasFontWeight() {
        return this.fontWeightAttributeValue != null;
    }

    public boolean hasFontStyle() {
        return this.fontStyleAttributeValue != null;
    }

    protected List match(FontInfo fontInfo) {
        AttributeValue fontFamilyValue = this.getFontFamily();
        AttributeValue weightValue = this.getFontWeight();
        AttributeValue styleValue = this.getFontStyle();
        ArrayList<FontTriplet> matchingTriplets = new ArrayList<FontTriplet>();
        Iterator attrIt = fontFamilyValue.iterator();
        while (attrIt.hasNext()) {
            String fontFamilyString = (String)attrIt.next();
            Map triplets = fontInfo.getFontTriplets();
            if (triplets == null) continue;
            Set tripletSet = triplets.keySet();
            Iterator tripletIt = tripletSet.iterator();
            while (tripletIt.hasNext()) {
                FontTriplet triplet = (FontTriplet)tripletIt.next();
                String fontName = triplet.getName();
                if (!fontFamilyString.toLowerCase().equals(fontName.toLowerCase())) continue;
                boolean weightMatched = false;
                int fontWeight = triplet.getWeight();
                Iterator weightIt = weightValue.iterator();
                while (weightIt.hasNext()) {
                    Integer fontWeightInteger;
                    int fontWeightValue;
                    Object weightObj = weightIt.next();
                    if (weightObj instanceof FontWeightRange) {
                        FontWeightRange intRange = (FontWeightRange)weightObj;
                        if (!intRange.isWithinRange(fontWeight)) continue;
                        weightMatched = true;
                        continue;
                    }
                    if (weightObj instanceof String) {
                        String fontWeightString = (String)weightObj;
                        fontWeightValue = FontUtil.parseCSS2FontWeight(fontWeightString);
                        if (fontWeightValue != fontWeight) continue;
                        weightMatched = true;
                        continue;
                    }
                    if (!(weightObj instanceof Integer) || (fontWeightValue = (fontWeightInteger = (Integer)weightObj).intValue()) != fontWeight) continue;
                    weightMatched = true;
                }
                boolean styleMatched = false;
                String fontStyleString = triplet.getStyle();
                Iterator styleIt = styleValue.iterator();
                while (styleIt.hasNext()) {
                    String style = (String)styleIt.next();
                    if (!fontStyleString.equals(style)) continue;
                    styleMatched = true;
                }
                if (!weightMatched || !styleMatched) continue;
                matchingTriplets.add(triplet);
            }
        }
        return matchingTriplets;
    }

    protected FontTriplet bestMatch(FontInfo fontInfo) {
        List matchingTriplets = this.match(fontInfo);
        FontTriplet bestTriplet = null;
        if (matchingTriplets.size() == 1) {
            bestTriplet = (FontTriplet)matchingTriplets.get(0);
        } else {
            Iterator iterator = matchingTriplets.iterator();
            while (iterator.hasNext()) {
                FontTriplet triplet = (FontTriplet)iterator.next();
                if (bestTriplet == null) {
                    bestTriplet = triplet;
                    continue;
                }
                int priority = triplet.getPriority();
                if (priority >= bestTriplet.getPriority()) continue;
                bestTriplet = triplet;
            }
        }
        return bestTriplet;
    }

    public List getTriplets() {
        ArrayList<FontTriplet> triplets = new ArrayList<FontTriplet>();
        AttributeValue fontFamilyValue = this.getFontFamily();
        Iterator fontFamilyIt = fontFamilyValue.iterator();
        while (fontFamilyIt.hasNext()) {
            String name = (String)fontFamilyIt.next();
            AttributeValue styleValue = this.getFontStyle();
            Iterator styleIt = styleValue.iterator();
            while (styleIt.hasNext()) {
                String style = (String)styleIt.next();
                AttributeValue weightValue = this.getFontWeight();
                Iterator weightIt = weightValue.iterator();
                while (weightIt.hasNext()) {
                    Object weightObj = weightIt.next();
                    if (weightObj instanceof FontWeightRange) {
                        FontWeightRange fontWeightRange = (FontWeightRange)weightObj;
                        int[] weightRange = fontWeightRange.toArray();
                        for (int i = 0; i < weightRange.length; ++i) {
                            triplets.add(new FontTriplet(name, style, weightRange[i]));
                        }
                        continue;
                    }
                    if (weightObj instanceof String) {
                        String weightString = (String)weightObj;
                        int weight = FontUtil.parseCSS2FontWeight(weightString);
                        triplets.add(new FontTriplet(name, style, weight));
                        continue;
                    }
                    if (!(weightObj instanceof Integer)) continue;
                    Integer weightInteger = (Integer)weightObj;
                    int weight = weightInteger;
                    triplets.add(new FontTriplet(name, style, weight));
                }
            }
        }
        return triplets;
    }

    public String toString() {
        String str = new String();
        if (this.fontFamilyAttributeValue != null) {
            str = str + "font-family=" + this.fontFamilyAttributeValue;
        }
        if (this.fontStyleAttributeValue != null) {
            if (str.length() > 0) {
                str = str + ", ";
            }
            str = str + "font-style=" + this.fontStyleAttributeValue;
        }
        if (this.fontWeightAttributeValue != null) {
            if (str.length() > 0) {
                str = str + ", ";
            }
            str = str + "font-weight=" + this.fontWeightAttributeValue;
        }
        return str;
    }
}

