/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.parser;

import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.utils.ParsingSeparator;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreVariableParser
extends AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"VAR", "VAREQ", "VARLTEQ", "VARLT", "VARNEQ", "VARGT", "VARGTEQ"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        prereq.setKind("var");
        String compType = kind.substring(3);
        if (compType.length() == 0) {
            compType = "gteq";
        }
        ParsingSeparator ps = new ParsingSeparator(formula, ',');
        try {
            int count = 0;
            while (ps.hasNext()) {
                Prerequisite subreq;
                String first = ps.next();
                if (!ps.hasNext()) {
                    throw new PersistenceLayerException("Unable to parse prerequisite 'PRE" + kind + ":" + formula + "'. Incorrect parameter count (must be even)");
                }
                String second = ps.next();
                if (!ps.hasNext() && count == 0) {
                    subreq = prereq;
                } else {
                    prereq.setKind(null);
                    subreq = new Prerequisite();
                    subreq.setKind("var");
                    prereq.addPrerequisite(subreq);
                    ++count;
                }
                subreq.setOperator(compType.intern());
                subreq.setKey(first.intern());
                subreq.setOperand(second.intern());
            }
            if (count > 0) {
                prereq.setOperand(Integer.toString(count));
            }
        }
        catch (PrerequisiteException pe) {
            throw new PersistenceLayerException("Unable to parse prerequisite 'PRE" + kind + ":" + formula + "'. " + pe.getLocalizedMessage());
        }
        if (invertResult) {
            prereq.setOperator(prereq.getOperator().invert());
        }
        prereq.setOverrideQualify(overrideQualify);
        return prereq;
    }
}

