/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Color;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.BorderInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.StyleSheetRenderState;

public class ImageRenderState
extends StyleSheetRenderState {
    public ImageRenderState(RenderState prevRenderState, HTMLElementImpl element) {
        super(prevRenderState, element);
    }

    public HtmlInsets getMarginInsets() {
        HtmlInsets mi = this.marginInsets;
        if (mi != INVALID_INSETS) {
            return mi;
        }
        AbstractCSS2Properties props = this.getCssProperties();
        mi = props == null ? null : HtmlValues.getMarginInsets(props, this);
        if (mi == null) {
            String vspaceText;
            int hspace = 0;
            int vspace = 0;
            boolean createNew = false;
            String hspaceText = this.element.getAttribute("hspace");
            if (hspaceText != null && hspaceText.length() != 0) {
                createNew = true;
                try {
                    hspace = Integer.parseInt(hspaceText);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((vspaceText = this.element.getAttribute("vspace")) != null && vspaceText.length() != 0) {
                createNew = true;
                try {
                    vspace = Integer.parseInt(vspaceText);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (createNew) {
                mi = new HtmlInsets();
                mi.top = vspace;
                mi.topType = 1;
                mi.bottom = vspace;
                mi.bottomType = 1;
                mi.left = hspace;
                mi.leftType = 1;
                mi.right = hspace;
                mi.rightType = 1;
            }
        }
        this.marginInsets = mi;
        return mi;
    }

    public BorderInfo getBorderInfo() {
        BorderInfo binfo = this.borderInfo;
        if (binfo != INVALID_BORDER_INFO) {
            return binfo;
        }
        binfo = super.getBorderInfo();
        if (binfo == null || binfo.topStyle == 0 && binfo.bottomStyle == 0 && binfo.leftStyle == 0 && binfo.rightStyle == 0) {
            String border;
            HTMLElementImpl element;
            if (binfo == null) {
                binfo = new BorderInfo();
            }
            if ((element = this.element) != null && (border = element.getAttribute("border")) != null) {
                int value;
                int valueType;
                if ((border = border.trim()).endsWith("%")) {
                    valueType = 3;
                    try {
                        value = Integer.parseInt(border.substring(0, border.length() - 1));
                    }
                    catch (NumberFormatException nfe) {
                        value = 0;
                    }
                } else {
                    valueType = 1;
                    try {
                        value = Integer.parseInt(border);
                    }
                    catch (NumberFormatException nfe) {
                        value = 0;
                    }
                }
                HtmlInsets borderInsets = new HtmlInsets();
                borderInsets.right = borderInsets.bottom = value;
                borderInsets.left = borderInsets.bottom;
                borderInsets.top = borderInsets.bottom;
                borderInsets.rightType = borderInsets.bottomType = valueType;
                borderInsets.leftType = borderInsets.bottomType;
                borderInsets.topType = borderInsets.bottomType;
                binfo.insets = borderInsets;
                if (binfo.topColor == null) {
                    binfo.topColor = Color.BLACK;
                }
                if (binfo.leftColor == null) {
                    binfo.leftColor = Color.BLACK;
                }
                if (binfo.rightColor == null) {
                    binfo.rightColor = Color.BLACK;
                }
                if (binfo.bottomColor == null) {
                    binfo.bottomColor = Color.BLACK;
                }
                if (value != 0) {
                    binfo.bottomStyle = 4;
                    binfo.rightStyle = 4;
                    binfo.leftStyle = 4;
                    binfo.topStyle = 4;
                }
            }
        }
        this.borderInfo = binfo;
        return binfo;
    }
}

