/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.spells;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.content.KnownSpellIdentifier;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.kit.KitSpells;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class SpellsToken
extends AbstractNonEmptyToken<KitSpells>
implements CDOMPrimaryToken<KitSpells> {
    private static final Class<Spell> SPELL_CLASS = Spell.class;
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getTokenName() {
        return "SPELLS";
    }

    public Class<KitSpells> getTokenClass() {
        return KitSpells.class;
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, KitSpells kitSpell, String value) {
        StringTokenizer aTok = new StringTokenizer(value, "|");
        ComplexParseResult pr = new ComplexParseResult();
        while (aTok.hasMoreTokens()) {
            String field = aTok.nextToken();
            if (field.startsWith("SPELLBOOK=")) {
                if (kitSpell.getSpellBook() != null) {
                    return new ParseResult.Fail("Cannot reset SPELLBOOK in SPELLS: " + value, context);
                }
                String spellBook = field.substring(10);
                if (spellBook.length() == 0) {
                    return new ParseResult.Fail("Cannot set SPELLBOOK to empty value in SPELLS: " + value, context);
                }
                kitSpell.setSpellBook(spellBook);
                continue;
            }
            if (field.startsWith("CLASS=")) {
                if (kitSpell.getCastingClass() != null) {
                    return new ParseResult.Fail("Cannot reset CLASS in SPELLS: " + value, context);
                }
                String className = field.substring(6);
                if (className.length() == 0) {
                    return new ParseResult.Fail("Cannot set CLASS to empty value in SPELLS: " + value, context);
                }
                if (className.equalsIgnoreCase("Default")) {
                    pr.addWarningMessage("Use of Default for CLASS= in KIT SPELLS line is unnecessary: Ignoring");
                    continue;
                }
                kitSpell.setCastingClass(context.getReferenceContext().getCDOMReference(PCClass.class, className));
                continue;
            }
            int count = 1;
            int equalLoc = field.indexOf("=");
            if (equalLoc != -1) {
                String countStr = field.substring(equalLoc + 1);
                try {
                    count = Integer.parseInt(countStr);
                }
                catch (NumberFormatException e) {
                    return new ParseResult.Fail("Expected an Integer COUNT, but found: " + countStr + " in " + value, context);
                }
                field = field.substring(0, equalLoc);
            }
            if (field.length() == 0) {
                return new ParseResult.Fail("Expected an Spell in SPELLS but found: " + value, context);
            }
            StringTokenizer subTok = new StringTokenizer(field, "[]");
            String filterString = subTok.nextToken();
            CDOMReference sp = null;
            sp = TokenUtilities.getTypeOrPrimitive((LoadContext)context, SPELL_CLASS, (String)filterString);
            if (sp == null) {
                return new ParseResult.Fail("  encountered Invalid limit in " + this.getTokenName() + ": " + value, context);
            }
            KnownSpellIdentifier ksi = new KnownSpellIdentifier(sp, null);
            ArrayList<CDOMSingleRef> featList = new ArrayList<CDOMSingleRef>();
            while (subTok.hasMoreTokens()) {
                String featName = subTok.nextToken();
                CDOMSingleRef feat = context.getReferenceContext().getCDOMReference(ABILITY_CLASS, (Category)AbilityCategory.FEAT, featName);
                featList.add(feat);
            }
            kitSpell.addSpell(ksi, featList, count);
        }
        if (kitSpell.getSpellBook() == null) {
            kitSpell.setSpellBook(Globals.getDefaultSpellBook());
        }
        return pr;
    }

    public String[] unparse(LoadContext context, KitSpells kitSpell) {
        Collection spells;
        CDOMSingleRef castingClass;
        StringBuilder sb = new StringBuilder();
        String spellBook = kitSpell.getSpellBook();
        String globalSpellbook = Globals.getDefaultSpellBook();
        if (spellBook != null && !globalSpellbook.equals(spellBook)) {
            sb.append("SPELLBOOK=").append(spellBook);
        }
        if ((castingClass = kitSpell.getCastingClass()) != null) {
            if (sb.length() != 0) {
                sb.append("|");
            }
            sb.append("CLASS=").append(castingClass.getLSTformat(false));
        }
        if ((spells = kitSpell.getSpells()) != null) {
            boolean needPipe = sb.length() > 0;
            for (KnownSpellIdentifier ksi : spells) {
                if (needPipe) {
                    sb.append("|");
                }
                needPipe = true;
                Collection abilities = kitSpell.getAbilities(ksi);
                for (List abils : abilities) {
                    Integer count;
                    StringBuilder spell = new StringBuilder();
                    spell.append(StringUtil.replaceAll((String)ksi.getLSTformat(), (String)"TYPE=", (String)"TYPE."));
                    if (abils != null && !abils.isEmpty()) {
                        spell.append('[');
                        spell.append(ReferenceUtilities.joinLstFormat((Collection)abils, (String)"]["));
                        spell.append(']');
                    }
                    if ((count = kitSpell.getSpellCount(ksi, abils)) != 1) {
                        spell.append('=').append(count);
                    }
                    sb.append((CharSequence)spell);
                }
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return new String[]{sb.toString()};
    }
}

