/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.ability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Ability;
import pcgen.core.Description;
import pcgen.core.prereq.Prerequisite;
import pcgen.io.EntityEncoder;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.PatternChanges;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class BenefitToken
extends AbstractNonEmptyToken<Ability>
implements CDOMPrimaryToken<Ability> {
    @Override
    public String getTokenName() {
        return "BENEFIT";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, Ability ability, String value) {
        if (".CLEAR".equals(value)) {
            context.getObjectContext().removeList(ability, ListKey.BENEFIT);
            return ParseResult.SUCCESS;
        }
        if (value.startsWith(".CLEAR.")) {
            context.getObjectContext().removePatternFromList(ability, ListKey.BENEFIT, value.substring(7));
            return ParseResult.SUCCESS;
        }
        Description ben = this.parseBenefit(value);
        if (ben == null) {
            return ParseResult.INTERNAL_ERROR;
        }
        context.getObjectContext().addToList(ability, ListKey.BENEFIT, ben);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Ability ability) {
        PatternChanges<Description> changes = context.getObjectContext().getListPatternChanges(ability, ListKey.BENEFIT);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Collection<String> removedItems = changes.getRemoved();
        if (changes.includesGlobalClear()) {
            if (removedItems != null && !removedItems.isEmpty()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR");
        } else if (removedItems != null && !removedItems.isEmpty()) {
            for (String d : removedItems) {
                list.add(".CLEAR." + d);
            }
        }
        Collection<Description> added = changes.getAdded();
        if (added != null && !added.isEmpty()) {
            for (Description d : added) {
                list.add(d.getPCCText());
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Description parseBenefit(String aDesc) {
        if (this.isEmpty(aDesc) || this.hasIllegalSeparator('|', aDesc)) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(aDesc, "|");
        String firstToken = tok.nextToken();
        if (PreParserFactory.isPreReqString(firstToken)) {
            Logging.errorPrint("Invalid " + this.getTokenName() + ": " + aDesc);
            Logging.errorPrint("  PRExxx can not be only value");
            return null;
        }
        String ds = EntityEncoder.decode(firstToken);
        if (!StringUtil.hasBalancedParens((String)ds)) {
            Logging.log(Logging.LST_ERROR, this.getTokenName() + " encountered imbalanced Parenthesis: " + aDesc);
            return null;
        }
        Description desc = new Description(ds);
        boolean isPre = false;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (PreParserFactory.isPreReqString(token)) {
                Prerequisite prereq = this.getPrerequisite(token);
                if (prereq == null) {
                    Logging.errorPrint(this.getTokenName() + " had invalid prerequisite : " + token);
                    return null;
                }
                desc.addPrerequisite(prereq);
                isPre = true;
                continue;
            }
            if (isPre) {
                Logging.errorPrint("Invalid " + this.getTokenName() + ": " + aDesc);
                Logging.errorPrint("  PRExxx must be at the END of the Token");
                return null;
            }
            desc.addVariable(token);
        }
        return desc;
    }

    @Override
    public Class<Ability> getTokenClass() {
        return Ability.class;
    }
}

