/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import pcgen.core.ChronicleEntry;
import pcgen.core.PlayerCharacter;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;

public class CampaignHistoryToken
extends Token {
    public static final String TOKENNAME = "CAMPAIGNHISTORY";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        Visibility visibility = Visibility.VISIBLE;
        String entryIndex = aTok.nextToken();
        if (!StringUtils.isNumeric(entryIndex)) {
            if (entryIndex.equals("ALL")) {
                visibility = Visibility.ALL;
            } else if (entryIndex.equals("HIDDEN")) {
                visibility = Visibility.HIDDEN;
            } else if (!entryIndex.equals("VISIBLE")) {
                Logging.log(Logging.LST_ERROR, "Invalid visibility entry '" + entryIndex + "'. Should be one of ALL, VISIBLE or HIDDEN. Token was " + tokenSource);
                return "";
            }
            entryIndex = aTok.nextToken();
        }
        if (!StringUtils.isNumeric(entryIndex)) {
            Logging.log(Logging.LST_ERROR, "Invalid position entry '" + entryIndex + "', it should be a number. Token was " + tokenSource);
            return "";
        }
        int index = Integer.parseInt(entryIndex);
        ChronicleEntry entry = this.getTargetChronicleEntry(index, visibility, pc.getDisplay());
        if (entry == null) {
            return "";
        }
        String token = aTok.hasMoreTokens() ? aTok.nextToken() : "TEXT";
        String value = this.getChronicleValue(entry, token.toUpperCase());
        if (value == null) {
            Logging.log(Logging.LST_ERROR, "Invalid property '" + token + "'. Token was " + tokenSource);
            return "";
        }
        return value;
    }

    private ChronicleEntry getTargetChronicleEntry(int targetIndex, Visibility visibility, CharacterDisplay display) {
        Collection<ChronicleEntry> entries = display.getChronicleEntries();
        int i = 0;
        for (ChronicleEntry chronicleEntry : entries) {
            if (chronicleEntry.isOutputEntry() && visibility == Visibility.HIDDEN || !chronicleEntry.isOutputEntry() && visibility == Visibility.VISIBLE) continue;
            if (i == targetIndex) {
                return chronicleEntry;
            }
            ++i;
        }
        return null;
    }

    private String getChronicleValue(ChronicleEntry entry, String token) {
        if (token.equals("TEXT")) {
            return entry.getChronicle();
        }
        if (token.equals("CAMPAIGN")) {
            return entry.getCampaign();
        }
        if (token.equals("ADVENTURE")) {
            return entry.getAdventure();
        }
        if (token.equals("PARTY")) {
            return entry.getParty();
        }
        if (token.equals("DATE")) {
            return entry.getDate();
        }
        if (token.equals("XP")) {
            NumberFormat fmt = NumberFormat.getNumberInstance();
            return fmt.format(entry.getXpField());
        }
        if (token.equals("GM")) {
            return entry.getGmField();
        }
        return null;
    }

    private static enum Visibility {
        ALL,
        HIDDEN,
        VISIBLE;

    }
}

