/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.token;

import java.util.Collection;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Converter;
import pcgen.cdom.base.PrimitiveCollection;
import pcgen.cdom.base.PrimitiveFilter;
import pcgen.cdom.converter.AddFilterConverter;
import pcgen.cdom.converter.NegateFilterConverter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.SelectionCreator;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.QualifierToken;
import pcgen.util.Logging;

public abstract class AbstractPCQualifierToken<T extends CDOMObject>
implements QualifierToken<T>,
PrimitiveFilter<T> {
    private Class<T> refClass;
    private PrimitiveCollection<T> pcs = null;
    private boolean wasRestricted = false;
    private boolean negated = false;

    @Override
    public String getTokenName() {
        return "PC";
    }

    @Override
    public boolean initialize(LoadContext context, SelectionCreator<T> sc, String condition, String value, boolean negate) {
        if (condition != null) {
            Logging.addParseMessage(Level.SEVERE, "Cannot make " + this.getTokenName() + " into a conditional Qualifier, remove =");
            return false;
        }
        if (sc == null) {
            throw new IllegalArgumentException();
        }
        this.refClass = sc.getReferenceClass();
        this.negated = negate;
        if (value == null) {
            this.pcs = sc.getAllReference();
        } else {
            this.pcs = context.getPrimitiveChoiceFilter(sc, value);
            this.wasRestricted = true;
        }
        return this.pcs != null;
    }

    protected abstract Collection<T> getPossessed(PlayerCharacter var1);

    @Override
    public String getLSTformat(boolean useAny) {
        StringBuilder sb = new StringBuilder();
        if (this.negated) {
            sb.append('!');
        }
        sb.append(this.getTokenName());
        if (this.wasRestricted) {
            sb.append('[').append(this.pcs.getLSTformat(useAny)).append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.pcs == null ? 0 : this.pcs.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractPCQualifierToken) {
            AbstractPCQualifierToken other = (AbstractPCQualifierToken)o;
            if (this.pcs == null ? other.pcs != null : !this.pcs.equals(other.pcs)) {
                return false;
            }
            if (this.refClass == null) {
                if (other.refClass != null) {
                    return false;
                }
                return this.getClass().equals(other.getClass());
            }
            if (!this.refClass.equals(other.refClass)) {
                return false;
            }
            return this.negated == other.negated;
        }
        return false;
    }

    @Override
    public GroupingState getGroupingState() {
        GroupingState gs = this.pcs == null ? GroupingState.ANY : this.pcs.getGroupingState().reduce();
        return this.negated ? gs.negate() : gs;
    }

    @Override
    public <R> Collection<? extends R> getCollection(PlayerCharacter pc, Converter<T, R> c) {
        Converter conv = c;
        conv = this.negated ? new NegateFilterConverter(conv) : conv;
        conv = new AddFilterConverter(conv, this);
        return this.pcs.getCollection(pc, conv);
    }

    @Override
    public boolean allow(PlayerCharacter pc, T po) {
        return this.getPossessed(pc).contains(po);
    }
}

