/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Campaign;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.persistence.lst.SourceEntry;
import pcgen.persistence.lst.SourceLoader;
import pcgen.rules.context.LoadContext;
import pcgen.system.LanguageBundle;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;

public abstract class LstObjectFileLoader<T extends CDOMObject>
extends Observable {
    public static final String FIELD_SEPARATOR = "\t";
    public static final String LINE_SEPARATOR = "\r\n";
    public static final String INCLUDE_TAG = "INCLUDE";
    public static final String EXCLUDE_TAG = "EXCLUDE";
    public static final String COPY_SUFFIX = ".COPY";
    public static final String MOD_SUFFIX = ".MOD";
    public static final String FORGET_SUFFIX = ".FORGET";
    private List<ModEntry> copyLineList = new ArrayList<ModEntry>();
    private List<String> forgetLineList = new ArrayList<String>();
    private List<List<ModEntry>> modEntryList = new ArrayList<List<ModEntry>>();
    private boolean processComplete = true;
    protected List<String> excludedObjects = new ArrayList<String>();

    public void loadLstFiles(LoadContext context, List<CampaignSourceEntry> fileList) throws PersistenceLayerException {
        this.processComplete = true;
        HashSet<CampaignSourceEntry> loadedFiles = new HashSet<CampaignSourceEntry>();
        for (CampaignSourceEntry sourceEntry : fileList) {
            if (sourceEntry == null || loadedFiles.contains(sourceEntry)) continue;
            this.loadLstFile(context, sourceEntry);
            loadedFiles.add(sourceEntry);
        }
        this.processCopies(context);
        this.processComplete = false;
        this.processMods(context);
        this.processForgets(context);
    }

    public abstract T parseLine(LoadContext var1, T var2, String var3, SourceEntry var4) throws PersistenceLayerException;

    public void completeObject(LoadContext context, SourceEntry source, T pObj) throws PersistenceLayerException {
        if (!this.processComplete || pObj == null) {
            return;
        }
        if (this.includeObject(source, (CDOMObject)pObj)) {
            this.storeObject(context, pObj);
        } else {
            this.excludedObjects.add(((CDOMObject)pObj).getKeyName());
            context.getReferenceContext().forget(pObj);
        }
    }

    protected void storeObject(LoadContext context, T pObj) {
        T currentObj = this.getMatchingObject(context, (CDOMObject)pObj);
        if (!context.consolidate() || currentObj == null || !pObj.equals(currentObj)) {
            this.addGlobalObject((CDOMObject)pObj);
        } else if (currentObj != pObj) {
            boolean allowoverride = PCGenSettings.OPTIONS_CONTEXT.initBoolean("allowOverrideDuplicates", true);
            if (allowoverride) {
                Date pObjDate = ((CDOMObject)pObj).get(ObjectKey.SOURCE_DATE);
                Date currentObjDate = ((CDOMObject)currentObj).get(ObjectKey.SOURCE_DATE);
                if (pObjDate != null && (currentObjDate == null || pObjDate.compareTo(currentObjDate) > 0)) {
                    this.performForget(context, currentObj);
                    this.addGlobalObject((CDOMObject)pObj);
                } else {
                    context.getReferenceContext().forget(pObj);
                }
            } else {
                Logging.errorPrintLocalised("Warnings.LstFileLoader.DuplicateObject", ((CDOMObject)pObj).getKeyName(), ((CDOMObject)currentObj).getSourceURI(), ((CDOMObject)pObj).getSourceURI());
            }
        }
    }

    protected void addGlobalObject(CDOMObject cdo) {
    }

    protected boolean includeObject(SourceEntry source, CDOMObject cdo) {
        if (cdo == null || cdo.getDisplayName() == null || cdo.getDisplayName().trim().length() == 0 || cdo.getKeyName() == null || cdo.getKeyName().trim().length() == 0) {
            return false;
        }
        List<String> includeItems = source.getIncludeItems();
        if (!includeItems.isEmpty()) {
            return includeItems.contains(cdo.getKeyName());
        }
        List<String> excludeItems = source.getExcludeItems();
        if (!excludeItems.isEmpty()) {
            return !excludeItems.contains(cdo.getKeyName());
        }
        return true;
    }

    protected abstract T getObjectKeyed(LoadContext var1, String var2);

    protected T getMatchingObject(LoadContext context, CDOMObject key) {
        return this.getObjectKeyed(context, key.getKeyName());
    }

    protected void loadLstFile(LoadContext context, CampaignSourceEntry sourceEntry) {
        block20: {
            StringBuilder dataBuffer;
            this.setChanged();
            URI uri = sourceEntry.getURI();
            this.notifyObservers(uri);
            try {
                dataBuffer = LstFileLoader.readFromURI(uri);
            }
            catch (PersistenceLayerException ple) {
                String message = LanguageBundle.getFormattedString("Errors.LstFileLoader.LoadError", uri, ple.getMessage());
                Logging.errorPrint(message);
                this.setChanged();
                return;
            }
            String aString = dataBuffer.toString();
            if (context != null) {
                context.setSourceURI(uri);
            }
            Object target = null;
            ArrayList<ModEntry> classModLines = null;
            boolean allowMultiLine = PCGenSettings.OPTIONS_CONTEXT.initBoolean("optionSourcesAllowMultiLine", false);
            if (allowMultiLine) {
                aString = aString.replaceAll("\r?\n\t", FIELD_SEPARATOR);
            }
            String[] fileLines = aString.split("(\r\n?|\n)");
            for (int i = 0; i < fileLines.length; ++i) {
                String message;
                String line = fileLines[i];
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                int sepLoc = line.indexOf(FIELD_SEPARATOR);
                String firstToken = sepLoc == -1 ? line : line.substring(0, sepLoc);
                if (classModLines != null) {
                    if (firstToken.startsWith("CLASS:")) {
                        this.modEntryList.add(classModLines);
                        classModLines = null;
                    } else {
                        classModLines.add(new ModEntry(sourceEntry, line, i + 1));
                        continue;
                    }
                }
                if (line.startsWith("SOURCE")) {
                    SourceLoader.parseLine(context, line, uri);
                    continue;
                }
                if (line.trim().length() == 0) continue;
                if (firstToken.indexOf(COPY_SUFFIX) > 0) {
                    this.copyLineList.add(new ModEntry(sourceEntry, line, i + 1));
                    continue;
                }
                if (firstToken.indexOf(MOD_SUFFIX) > 0) {
                    if (firstToken.startsWith("CLASS:")) {
                        classModLines = new ArrayList<ModEntry>();
                        classModLines.add(new ModEntry(sourceEntry, line, i + 1));
                        continue;
                    }
                    ArrayList<ModEntry> modLines = new ArrayList<ModEntry>(1);
                    modLines.add(new ModEntry(sourceEntry, line, i + 1));
                    this.modEntryList.add(modLines);
                    continue;
                }
                if (firstToken.indexOf(FORGET_SUFFIX) > 0) {
                    this.forgetLineList.add(line);
                    continue;
                }
                try {
                    target = this.parseLine(context, target, line, sourceEntry);
                    continue;
                }
                catch (PersistenceLayerException ple) {
                    message = LanguageBundle.getFormattedString("Errors.LstFileLoader.ParseError", uri, i + 1, ple.getMessage());
                    Logging.errorPrint(message);
                    this.setChanged();
                    if (!Logging.isDebugMode()) continue;
                    Logging.debugPrint("Parse error:", ple);
                    continue;
                }
                catch (Throwable t) {
                    message = LanguageBundle.getFormattedString("Errors.LstFileLoader.ParseError", uri, i + 1, t.getMessage());
                    Logging.errorPrint(message, t);
                    this.setChanged();
                    Logging.errorPrint(LanguageBundle.getString("Errors.LstFileLoader.Ignoring: " + t.getMessage()));
                    if (!Logging.isDebugMode()) continue;
                    Logging.errorPrint(LanguageBundle.getString("Errors.LstFileLoader.Ignoring"), t);
                    t.printStackTrace();
                }
            }
            if (classModLines != null) {
                this.modEntryList.add(classModLines);
            }
            if (target != null) {
                try {
                    this.completeObject(context, sourceEntry, target);
                }
                catch (PersistenceLayerException ple) {
                    Logging.errorPrint("Error in completing " + target.getClass().getSimpleName() + " " + ((CDOMObject)target).getKeyName());
                    this.setChanged();
                    if (!Logging.isDebugMode()) break block20;
                    Logging.debugPrint("Parse error:", ple);
                }
            }
        }
    }

    protected void performForget(LoadContext context, T objToForget) {
        context.getReferenceContext().forget(objToForget);
    }

    private void performCopy(LoadContext context, ModEntry me) throws PersistenceLayerException {
        String copyName;
        int nameEnd;
        String lstLine = me.getLstLine();
        int sepLoc = lstLine.indexOf(FIELD_SEPARATOR);
        String name = sepLoc != -1 ? lstLine.substring(0, sepLoc) : lstLine;
        String baseName = name.substring(0, nameEnd = name.indexOf(COPY_SUFFIX));
        T copy = this.getCopy(context, baseName, (copyName = name.substring(nameEnd + 6)).intern(), me.source);
        if (copy != null) {
            if (sepLoc != -1) {
                String restOfLine = me.getLstLine().substring(nameEnd + 6);
                this.parseLine(context, copy, restOfLine, me.getSource());
            }
            this.completeObject(context, me.getSource(), copy);
        }
    }

    protected T getCopy(LoadContext context, String baseName, String copyName, CampaignSourceEntry source) throws PersistenceLayerException {
        T object = this.getObjectKeyed(context, baseName);
        if (object == null) {
            List<String> includeItems = source.getIncludeItems();
            if (!includeItems.isEmpty() && !includeItems.contains(copyName)) {
                return null;
            }
            List<String> excludeItems = source.getExcludeItems();
            if (excludeItems.contains(copyName)) {
                return null;
            }
            String message = LanguageBundle.getFormattedString("Errors.LstFileLoader.CopyObjectNotFound", baseName);
            Logging.errorPrint(message);
            this.setChanged();
            return null;
        }
        T obj = context.performCopy(object, copyName);
        if (obj == null) {
            this.setChanged();
        }
        return obj;
    }

    private void performMod(LoadContext context, List<ModEntry> entryList) {
        T object;
        ModEntry entry = entryList.get(0);
        int nameEnd = entry.getLstLine().indexOf(MOD_SUFFIX);
        String key = entry.getLstLine().substring(0, nameEnd);
        List<String> includeItems = entry.source.getIncludeItems();
        int nameStart = key.indexOf(58);
        if (nameStart > 0) {
            key = key.substring(nameStart + 1);
        }
        if ((object = context.getReferenceContext().performMod(this.getObjectKeyed(context, key))) == null) {
            if (!includeItems.isEmpty() && !includeItems.contains(key)) {
                return;
            }
            if (this.excludedObjects.contains(key)) {
                return;
            }
            String message = LanguageBundle.getFormattedString("Errors.LstFileLoader.ModObjectNotFound", entry.getSource().getURI(), entry.getLineNumber(), key);
            Logging.log(Logging.LST_ERROR, message);
            this.setChanged();
            return;
        }
        try {
            if (includeItems.isEmpty() || includeItems.contains(key)) {
                for (ModEntry element : entryList) {
                    context.setSourceURI(element.source.getURI());
                    try {
                        String origPage = ((CDOMObject)object).get(StringKey.SOURCE_PAGE);
                        this.parseLine(context, object, element.getLstLine(), element.getSource());
                        if (origPage == ((CDOMObject)object).get(StringKey.SOURCE_PAGE)) continue;
                        Campaign campaign = element.source.getCampaign();
                        ((CDOMObject)object).put(ObjectKey.SOURCE_CAMPAIGN, (Campaign)campaign);
                        ((CDOMObject)object).put(StringKey.SOURCE_SHORT, campaign.get(StringKey.SOURCE_SHORT));
                        ((CDOMObject)object).put(StringKey.SOURCE_LONG, campaign.get(StringKey.SOURCE_LONG));
                        ((CDOMObject)object).put(ObjectKey.SOURCE_DATE, (Date)campaign.get(ObjectKey.SOURCE_DATE));
                        ((CDOMObject)object).put(StringKey.SOURCE_WEB, campaign.get(StringKey.SOURCE_WEB));
                        ((CDOMObject)object).setSourceURI(element.source.getURI());
                    }
                    catch (PersistenceLayerException ple) {
                        String message = LanguageBundle.getFormattedString("Errors.LstFileLoader.ModParseError", element.getSource().getURI(), element.getLineNumber(), ple.getMessage());
                        Logging.errorPrint(message);
                        this.setChanged();
                    }
                }
            }
            this.completeObject(context, entry.getSource(), object);
        }
        catch (PersistenceLayerException ple) {
            String message = LanguageBundle.getFormattedString("Errors.LstFileLoader.ModParseError", entry.getSource().getURI(), entry.getLineNumber(), ple.getMessage());
            Logging.errorPrint(message);
            this.setChanged();
        }
    }

    private void processCopies(LoadContext context) throws PersistenceLayerException {
        for (ModEntry me : this.copyLineList) {
            context.setSourceURI(me.source.getURI());
            this.performCopy(context, me);
        }
        this.copyLineList.clear();
    }

    private void processForgets(LoadContext context) {
        for (String forgetKey : this.forgetLineList) {
            T objToForget;
            if (this.excludedObjects.contains(forgetKey = forgetKey.substring(0, forgetKey.indexOf(FORGET_SUFFIX))) || (objToForget = this.getObjectKeyed(context, forgetKey)) == null) continue;
            this.performForget(context, objToForget);
        }
        this.forgetLineList.clear();
    }

    private void processMods(LoadContext context) {
        for (List<ModEntry> modEntry : this.modEntryList) {
            this.performMod(context, modEntry);
        }
        this.modEntryList.clear();
    }

    public static class ModEntry {
        private CampaignSourceEntry source = null;
        private String lstLine = null;
        private int lineNumber = 0;

        public ModEntry(CampaignSourceEntry aSource, String aLstLine, int aLineNumber) {
            if (aSource == null) {
                throw new IllegalArgumentException("source must not be null");
            }
            if (aLstLine == null) {
                throw new IllegalArgumentException("lstLine must not be null");
            }
            this.source = aSource;
            this.lstLine = aLstLine;
            this.lineNumber = aLineNumber;
        }

        public String getLstLine() {
            return this.lstLine;
        }

        public CampaignSourceEntry getSource() {
            return this.source;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

