/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.util.List;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class Compatibility {
    public static PCTemplate getTemplateFor(PCTemplate template, String templateKey, String feat) {
        if (templateKey.charAt(0) == 'L') {
            int level = Integer.parseInt(templateKey.substring(1));
            List<PCTemplate> levelTemplates = template.getListFor(ListKey.LEVEL_TEMPLATES);
            for (PCTemplate templ : levelTemplates) {
                if (level != templ.get(IntegerKey.LEVEL)) continue;
                return templ;
            }
        } else {
            int maxhd;
            int minhd;
            String hdString = templateKey.substring(1);
            int minusLoc = hdString.indexOf(45);
            if (minusLoc == -1) {
                if (hdString.indexOf(43) == hdString.length() - 1) {
                    minhd = Integer.parseInt(hdString.substring(0, hdString.length() - 1));
                    maxhd = Integer.MAX_VALUE;
                } else {
                    maxhd = minhd = Integer.parseInt(hdString);
                }
            } else {
                minhd = Integer.parseInt(hdString.substring(0, minusLoc));
                maxhd = Integer.parseInt(hdString.substring(minusLoc + 1));
            }
            List<PCTemplate> levelTemplates = template.getListFor(ListKey.HD_TEMPLATES);
            for (PCTemplate templ : levelTemplates) {
                if (minhd != templ.get(IntegerKey.HD_MIN) || maxhd != templ.get(IntegerKey.HD_MAX)) continue;
                return templ;
            }
        }
        Logging.errorPrint("Unable to find appropriate Template for " + templateKey + ":" + feat + " in " + template.getDisplayName());
        return null;
    }

    public static String getKeyFor(PCTemplate pct) {
        Integer level = pct.get(IntegerKey.LEVEL);
        StringBuilder hd = new StringBuilder();
        if (level == null) {
            hd.append('H');
            Integer min = pct.get(IntegerKey.HD_MIN);
            Integer max = pct.get(IntegerKey.HD_MAX);
            hd.append(min);
            if (max == Integer.MAX_VALUE) {
                hd.append('+');
            } else if (!max.equals(min)) {
                hd.append('-').append(max);
            }
        } else {
            hd.append('L');
            hd.append(level);
        }
        return hd.toString();
    }

    public static PersistentTransitionChoice<?> processOldAdd(LoadContext context, String first) throws PersistenceLayerException {
        int openParenLoc = first.indexOf(40);
        if (openParenLoc == -1) {
            Logging.errorPrint("Expected to have a ( : " + first);
            return null;
        }
        int closeParenLoc = first.lastIndexOf(41);
        if (openParenLoc == -1) {
            Logging.errorPrint("Expected to have a ) : " + first);
            return null;
        }
        String key = first.substring(7, openParenLoc);
        String choices = first.substring(openParenLoc + 1, closeParenLoc);
        String count = "";
        if (closeParenLoc != first.length() - 1) {
            count = first.substring(closeParenLoc + 1) + '|';
        }
        PCClass applied = new PCClass();
        ParseResult pr = context.processSubToken(applied, "ADD", key, count + choices);
        pr.printMessages();
        if (!pr.passed()) {
            return null;
        }
        context.commit();
        PersistentTransitionChoice<?> ptc = applied.getListFor(ListKey.ADD).get(0);
        return ptc;
    }
}

