/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.prefs;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.GameMode;
import pcgen.core.SettingsHandler;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.prefs.PCGenPrefsPanel;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.JComboBoxEx;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;

public class DefaultsPanel
extends PCGenPrefsPanel {
    private static final String DEFAULT_PREVIEW_SHEET_KEY = "CharacterSheetInfoTab.defaultPreviewSheet.";
    private static String in_defaults = LanguageBundle.getString("in_Prefs_defaults");
    private JComboBoxEx xpTableCombo = new JComboBoxEx();
    private JComboBoxEx characterTypeCombo = new JComboBoxEx();
    private JComboBoxEx previewSheetCombo = new JComboBoxEx();

    public DefaultsPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, in_defaults);
        title1.setTitleJustification(1);
        this.setBorder(title1);
        gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        Utility.buildConstraints(c, 0, 0, 2, 1, 0.0, 0.0);
        JLabel label = new JLabel(LanguageBundle.getString("in_Prefs_xpTable"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 2, 0, 1, 1, 0.0, 0.0);
        gridbag.setConstraints(this.xpTableCombo, c);
        this.add(this.xpTableCombo);
        Utility.buildConstraints(c, 0, 1, 2, 1, 0.0, 0.0);
        label = new JLabel(LanguageBundle.getString("in_Prefs_characterType"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 2, 1, 1, 1, 0.0, 0.0);
        gridbag.setConstraints(this.characterTypeCombo, c);
        this.add(this.characterTypeCombo);
        Utility.buildConstraints(c, 0, 2, 2, 1, 0.0, 0.0);
        label = new JLabel(LanguageBundle.getString("in_Prefs_previewSheet"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 2, 2, 1, 1, 0.0, 0.0);
        gridbag.setConstraints(this.previewSheetCombo, c);
        this.add(this.previewSheetCombo);
        Utility.buildConstraints(c, 5, 20, 1, 1, 1.0, 1.0);
        c.fill = 1;
        label = new JLabel(" ");
        gridbag.setConstraints(label, c);
        this.add(label);
    }

    @Override
    public String getTitle() {
        return in_defaults;
    }

    @Override
    public void setOptionsBasedOnControls() {
        GameMode gameMode = SettingsHandler.getGame();
        gameMode.setDefaultXPTableName(String.valueOf(this.xpTableCombo.getSelectedItem()));
        gameMode.setDefaultCharacterType(String.valueOf(this.characterTypeCombo.getSelectedItem()));
        gameMode.setDefaultPreviewSheet(String.valueOf(this.previewSheetCombo.getSelectedItem()));
        UIPropertyContext.getInstance().setProperty(DEFAULT_PREVIEW_SHEET_KEY + gameMode.getName(), String.valueOf(this.previewSheetCombo.getSelectedItem()));
    }

    @Override
    public void applyOptionValuesToControls() {
        GameMode gameMode = SettingsHandler.getGame();
        String xpTableName = gameMode.getDefaultXPTableName();
        List<String> xpTableNames = gameMode.getXPTableNames();
        this.xpTableCombo.removeAllItems();
        for (String name : xpTableNames) {
            this.xpTableCombo.addItem(name);
        }
        this.xpTableCombo.setSelectedItem(xpTableName);
        String characterType = gameMode.getDefaultCharacterType();
        List<String> characterTypes = gameMode.getCharacterTypeList();
        this.characterTypeCombo.removeAllItems();
        for (String name : characterTypes) {
            this.characterTypeCombo.addItem(name);
        }
        this.characterTypeCombo.setSelectedItem(characterType);
        String previewSheet = UIPropertyContext.getInstance().initProperty(DEFAULT_PREVIEW_SHEET_KEY + gameMode, gameMode.getDefaultPreviewSheet());
        String previewDir = ConfigurationSettings.getPreviewDir();
        File sheetDir = new File(previewDir, gameMode.getCharSheetDir());
        if (sheetDir.exists() && sheetDir.isDirectory()) {
            String[] files = sheetDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File path, String filename) {
                    File file = new File(path, filename);
                    return file.isFile() && !file.isHidden();
                }
            });
            this.previewSheetCombo.removeAllItems();
            this.previewSheetCombo.setModel(new DefaultComboBoxModel<String>(files));
            this.previewSheetCombo.sortItems();
            this.previewSheetCombo.setSelectedItem(previewSheet);
        }
    }
}

