/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.LogRecord;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import pcgen.cdom.content.Sponsor;
import pcgen.core.Globals;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.facade.core.CampaignFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterStubFacade;
import pcgen.facade.core.ChooserFacade;
import pcgen.facade.core.CompanionFacade;
import pcgen.facade.core.DataSetFacade;
import pcgen.facade.core.EquipmentBuilderFacade;
import pcgen.facade.core.GameModeFacade;
import pcgen.facade.core.PartyFacade;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.facade.core.SpellBuilderFacade;
import pcgen.facade.core.UIDelegate;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.CharacterTabs;
import pcgen.gui2.InfoGuidePane;
import pcgen.gui2.PCGenActionMap;
import pcgen.gui2.PCGenMenuBar;
import pcgen.gui2.PCGenStatusBar;
import pcgen.gui2.PCGenToolBar;
import pcgen.gui2.PCGenUIManager;
import pcgen.gui2.PcgFileFilter;
import pcgen.gui2.PcpFileFilter;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.dialog.AboutDialog;
import pcgen.gui2.dialog.ChooserDialog;
import pcgen.gui2.dialog.EquipCustomizerDialog;
import pcgen.gui2.dialog.PostLevelUpDialog;
import pcgen.gui2.dialog.RadioChooserDialog;
import pcgen.gui2.dialog.SpellChoiceDialog;
import pcgen.gui2.dialog.TipOfTheDay;
import pcgen.gui2.sources.SourceSelectionDialog;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.ShowMessageGuiObserver;
import pcgen.gui2.util.SwingWorker;
import pcgen.io.PCGFile;
import pcgen.persistence.SourceFileLoader;
import pcgen.system.CharacterManager;
import pcgen.system.ConfigurationSettings;
import pcgen.system.FacadeFactory;
import pcgen.system.LanguageBundle;
import pcgen.system.Main;
import pcgen.system.PCGenPropBundle;
import pcgen.system.PCGenSettings;
import pcgen.system.PropertyContext;
import pcgen.util.Logging;
import pcgen.util.chooser.ChoiceHandler;
import pcgen.util.chooser.ChooserFactory;

public final class PCGenFrame
extends JFrame
implements UIDelegate {
    private final PCGenActionMap actionMap;
    private final CharacterTabs characterTabs;
    private final PCGenStatusBar statusBar;
    private final DefaultReferenceFacade<SourceSelectionFacade> currentSourceSelection;
    private final DefaultReferenceFacade<CharacterFacade> currentCharacterRef;
    private final DefaultReferenceFacade<DataSetFacade> currentDataSetRef;
    private final FilenameListener filenameListener;
    private final JFileChooser chooser;
    private JDialog sourceSelectionDialog = null;
    private SourceLoadWorker sourceLoader = null;
    private String section15 = null;
    private String lastCharacterPath = null;

    public PCGenFrame() {
        Globals.setRootFrame(this);
        this.currentSourceSelection = new DefaultReferenceFacade();
        this.currentCharacterRef = new DefaultReferenceFacade();
        this.currentDataSetRef = new DefaultReferenceFacade();
        this.actionMap = new PCGenActionMap(this);
        this.characterTabs = new CharacterTabs(this);
        this.statusBar = new PCGenStatusBar(this);
        this.filenameListener = new FilenameListener();
        this.chooser = new JFileChooser();
        ShowMessageGuiObserver messageObserver = new ShowMessageGuiObserver(this);
        ShowMessageDelegate.getInstance().addObserver(messageObserver);
        ChooserFactory.setDelegate(this);
        this.initComponents();
        this.pack();
        this.initSettings();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JRootPane root = this.getRootPane();
        root.setActionMap(this.actionMap);
        root.setInputMap(1, PCGenFrame.createInputMap(this.actionMap));
        this.characterTabs.add(new InfoGuidePane(this));
        this.setJMenuBar(new PCGenMenuBar(this));
        this.add((Component)new PCGenToolBar(this), "North");
        this.add((Component)this.characterTabs, "Center");
        this.add((Component)this.statusBar, "South");
        this.updateTitle();
        this.setIconImage(Icons.PCGenApp.getImageIcon().getImage());
    }

    private boolean checkBounds(Rectangle rect) {
        if (rect.isEmpty()) {
            return false;
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice device : env.getScreenDevices()) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            if (!bounds.contains(rect) && !bounds.intersects(rect)) continue;
            return true;
        }
        return false;
    }

    private void initSettings() {
        final UIPropertyContext frameContext = UIPropertyContext.createContext("PCGenFrame");
        Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
        this.setSize(1060, 725);
        this.setLocationRelativeTo(null);
        if (!screenBounds.contains(this.getBounds())) {
            this.setSize(5 * screenBounds.width / 6, 5 * screenBounds.height / 6);
            this.setLocationRelativeTo(null);
        }
        Rectangle frameBounds = this.getBounds();
        frameBounds.x = frameContext.initInt("bounds.x", frameBounds.x);
        frameBounds.y = frameContext.initInt("bounds.y", frameBounds.x);
        frameBounds.width = frameContext.initInt("bounds.width", frameBounds.width);
        frameBounds.height = frameContext.initInt("bounds.height", frameBounds.height);
        int extendedState = frameContext.initInt("extendedState", 0);
        if (extendedState == 1) {
            extendedState = 0;
            frameContext.setInt("extendedState", 0);
        }
        this.setExtendedState(extendedState);
        if (this.checkBounds(frameBounds)) {
            this.setBounds(frameBounds);
        }
        this.addPropertyChangeListener("extendedState", frameContext);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                this.updateBounds();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.updateBounds();
            }

            private void updateBounds() {
                Rectangle bounds = PCGenFrame.this.getBounds();
                frameContext.setInt("bounds.x", bounds.x);
                frameContext.setInt("bounds.y", bounds.y);
                frameContext.setInt("bounds.width", bounds.width);
                frameContext.setInt("bounds.height", bounds.height);
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PCGenUIManager.closePCGen();
            }
        });
    }

    public void startPCGenFrame() {
        this.setVisible(true);
        new StartupWorker().start();
    }

    private static InputMap createInputMap(ActionMap actionMap) {
        InputMap inputMap = new InputMap();
        for (Object obj : actionMap.keys()) {
            KeyStroke key = (KeyStroke)actionMap.get(obj).getValue("AcceleratorKey");
            if (key == null) continue;
            inputMap.put(key, obj);
        }
        return inputMap;
    }

    public PCGenActionMap getActionMap() {
        return this.actionMap;
    }

    public void setSelectedCharacter(CharacterFacade character) {
        if (this.currentCharacterRef.getReference() != null) {
            this.currentCharacterRef.getReference().getFileRef().removeReferenceListener(this.filenameListener);
        }
        this.currentCharacterRef.setReference(character);
        this.updateTitle();
        if (character != null && character.getFileRef() != null) {
            character.getFileRef().addReferenceListener(this.filenameListener);
        }
    }

    public ReferenceFacade<SourceSelectionFacade> getCurrentSourceSelectionRef() {
        return this.currentSourceSelection;
    }

    public ReferenceFacade<CharacterFacade> getSelectedCharacterRef() {
        return this.currentCharacterRef;
    }

    public ReferenceFacade<DataSetFacade> getLoadedDataSetRef() {
        return this.currentDataSetRef;
    }

    public final PCGenStatusBar getStatusBar() {
        return this.statusBar;
    }

    public void unloadSources() {
        if (this.closeAllCharacters()) {
            this.currentSourceSelection.setReference(null);
            this.currentDataSetRef.setReference(null);
            Globals.emptyLists();
            this.updateTitle();
        }
    }

    public boolean loadSourceSelection(SourceSelectionFacade sources) {
        if (sources == null) {
            return false;
        }
        if (this.sourceLoader != null && this.sourceLoader.isAlive()) {
            return this.checkSourceEquality(sources, this.sourceLoader.sources);
        }
        if (this.checkSourceEquality(sources, this.currentSourceSelection.getReference())) {
            return true;
        }
        if (this.closeAllCharacters()) {
            this.sourceLoader = new SourceLoadWorker(sources, this);
            this.sourceLoader.start();
            return true;
        }
        return false;
    }

    private boolean checkSourceEquality(SourceSelectionFacade source1, SourceSelectionFacade source2) {
        if (source1 == source2) {
            return true;
        }
        if (source1 == null ^ source2 == null) {
            return false;
        }
        if (source1.getGameMode().getReference() != source2.getGameMode().getReference()) {
            return false;
        }
        ListFacade<CampaignFacade> campaigns1 = source1.getCampaigns();
        ListFacade<CampaignFacade> campaigns2 = source2.getCampaigns();
        if (campaigns1.getSize() != campaigns2.getSize()) {
            return false;
        }
        for (CampaignFacade campaignFacade : campaigns1) {
            if (campaigns2.containsElement(campaignFacade)) continue;
            return false;
        }
        return true;
    }

    private boolean checkGameModeEquality(SourceSelectionFacade source1, SourceSelectionFacade source2) {
        if (source1 == source2) {
            return true;
        }
        if (source1 == null ^ source2 == null) {
            return false;
        }
        return source1.getGameMode().getReference() == source2.getGameMode().getReference();
    }

    public boolean saveCharacter(CharacterFacade character) {
        if (!CharacterManager.characterFilenameValid(character)) {
            return this.showSaveCharacterChooser(character);
        }
        this.prepareForSave(character, false);
        if (!this.reallySaveCharacter(character)) {
            return this.showSaveCharacterChooser(character);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reallySaveCharacter(CharacterFacade character) {
        boolean result = false;
        String msg = "Saving character...";
        this.statusBar.startShowingProgress("Saving character...", true);
        try {
            result = CharacterManager.saveCharacter(character);
        }
        catch (Exception e) {
            Logging.errorPrint(e.getLocalizedMessage(), e);
        }
        finally {
            this.statusBar.endShowingProgress();
        }
        return result;
    }

    private void prepareForSave(CharacterFacade character, boolean savingAll) {
        CharacterStubFacade master;
        ArrayList<CompanionFacade> tobeSaved = new ArrayList<CompanionFacade>();
        for (CompanionFacade companionFacade : character.getCompanionSupport().getCompanions()) {
            if (!StringUtils.isEmpty(companionFacade.getFileRef().getReference().getName()) || CharacterManager.getCharacterMatching(companionFacade) == null) continue;
            tobeSaved.add(companionFacade);
        }
        if (!tobeSaved.isEmpty() && (savingAll || this.showMessageConfirm("PCGen", LanguageBundle.getString("in_unsavedCompanions")))) {
            for (CompanionFacade companionFacade : tobeSaved) {
                CharacterFacade compChar = CharacterManager.getCharacterMatching(companionFacade);
                this.showSaveCharacterChooser(compChar);
            }
        }
        if ((master = character.getMaster()) != null && (master.getFileRef().getReference() == null || StringUtils.isEmpty(master.getFileRef().getReference().getName())) && (savingAll || this.showMessageConfirm("PCGen", LanguageBundle.getString("in_unsavedMaster")))) {
            CharacterFacade characterFacade = CharacterManager.getCharacterMatching(master);
            this.showSaveCharacterChooser(characterFacade);
        }
    }

    public void closeCharacter(CharacterFacade character) {
        if (character.isDirty()) {
            int ret = JOptionPane.showConfirmDialog(this, LanguageBundle.getFormattedString("in_savePcChoice", character.getNameRef().getReference()), "PCGen", 1);
            if (ret == 2) {
                return;
            }
            if (ret == 0) {
                this.saveCharacter(character);
            }
        }
        CharacterManager.removeCharacter(character);
    }

    public boolean closeAllCharacters() {
        int CLOSE_OPT_CHOOSE = 2;
        PartyFacade characters = CharacterManager.getCharacters();
        if (characters.isEmpty()) {
            return true;
        }
        int saveAllChoice = 2;
        ArrayList<CharacterFacade> characterList = new ArrayList<CharacterFacade>();
        ArrayList<CharacterFacade> unsavedPCs = new ArrayList<CharacterFacade>();
        for (CharacterFacade characterFacade : characters) {
            if (characterFacade.isDirty()) {
                unsavedPCs.add(characterFacade);
                continue;
            }
            characterList.add(characterFacade);
        }
        if (unsavedPCs.size() > 1) {
            Object[] options = new Object[]{LanguageBundle.getString("in_closeOptSaveAll"), LanguageBundle.getString("in_closeOptSaveNone"), LanguageBundle.getString("in_closeOptChoose"), LanguageBundle.getString("in_cancel")};
            saveAllChoice = JOptionPane.showOptionDialog(this, LanguageBundle.getString("in_closeOptSaveTitle"), "PCGen", 1, 3, null, options, options[0]);
        }
        if (saveAllChoice == 3) {
            return false;
        }
        if (saveAllChoice == 1) {
            CharacterManager.removeAllCharacters();
            return true;
        }
        for (CharacterFacade character : unsavedPCs) {
            int saveSingleChoice = 0;
            if (saveAllChoice == 2) {
                saveSingleChoice = JOptionPane.showConfirmDialog(this, LanguageBundle.getFormattedString("in_savePcChoice", character.getNameRef().getReference()), "PCGen", 1);
            }
            if (saveSingleChoice == 0) {
                if (!this.saveCharacter(character)) continue;
                characterList.add(character);
                continue;
            }
            if (saveSingleChoice == 1) {
                characterList.add(character);
                continue;
            }
            if (saveSingleChoice != 2) continue;
            return false;
        }
        for (CharacterFacade character : characterList) {
            CharacterManager.removeCharacter(character);
        }
        return characters.isEmpty();
    }

    boolean showSavePartyChooser() {
        boolean overwrite;
        PartyFacade party = CharacterManager.getCharacters();
        PCGenSettings context = PCGenSettings.getInstance();
        String parentPath = context.getProperty("pcgen.files.parties");
        this.chooser.setCurrentDirectory(new File(parentPath));
        File file = party.getFileRef().getReference();
        this.chooser.setSelectedFile(file);
        this.chooser.resetChoosableFileFilters();
        PcpFileFilter filter = new PcpFileFilter();
        this.chooser.addChoosableFileFilter(filter);
        this.chooser.setFileFilter(filter);
        int ret = this.chooser.showSaveDialog(this);
        if (ret != 0) {
            return false;
        }
        file = this.chooser.getSelectedFile();
        if (!file.getName().endsWith(".pcp")) {
            file = new File(file.getParent(), file.getName() + ".pcp");
        }
        if (file.isDirectory()) {
            this.showErrorMessage("PCGen", LanguageBundle.getString("in_savePcDirOverwrite"));
            return this.showSavePartyChooser();
        }
        if (file.exists() && !(overwrite = this.showWarningConfirm(LanguageBundle.getFormattedString("in_savePcConfirmOverTitle", file.getName()), LanguageBundle.getFormattedString("in_savePcConfirmOverMsg", file.getName())))) {
            return this.showSavePartyChooser();
        }
        party.setFile(file);
        context.setProperty("pcgen.files.parties", file.getParent());
        if (!this.saveAllCharacters()) {
            this.showErrorMessage(LanguageBundle.getString("in_savePartyFailTitle"), LanguageBundle.getString("in_savePartyFailMsg"));
            return false;
        }
        if (!CharacterManager.saveCurrentParty()) {
            return this.showSavePartyChooser();
        }
        return true;
    }

    boolean saveAllCharacters() {
        boolean ok = true;
        for (CharacterFacade character : CharacterManager.getCharacters()) {
            File file = character.getFileRef().getReference();
            if (file == null || StringUtils.isEmpty(file.getName())) {
                ok &= this.showSaveCharacterChooser(character);
                continue;
            }
            this.prepareForSave(character, true);
            ok &= this.reallySaveCharacter(character);
        }
        return ok;
    }

    boolean showSaveCharacterChooser(CharacterFacade character) {
        File file;
        PCGenSettings context = PCGenSettings.getInstance();
        String parentPath = this.lastCharacterPath;
        if (parentPath == null) {
            parentPath = context.getProperty("pcgen.files.characters");
        }
        this.chooser.setCurrentDirectory(new File(parentPath));
        File prevFile = file = character.getFileRef().getReference();
        if (file == null || StringUtils.isEmpty(file.getName())) {
            file = new File(parentPath, character.getNameRef().getReference() + ".pcg");
        }
        this.chooser.setSelectedFile(file);
        this.chooser.resetChoosableFileFilters();
        PcgFileFilter filter = new PcgFileFilter();
        this.chooser.addChoosableFileFilter(filter);
        this.chooser.setFileFilter(filter);
        int ret = this.chooser.showSaveDialog(this);
        if (ret == 0) {
            boolean overwrite;
            file = this.chooser.getSelectedFile();
            if (!file.getName().endsWith(".pcg")) {
                file = new File(file.getParent(), file.getName() + ".pcg");
            }
            UIDelegate delegate = character.getUIDelegate();
            if (file.isDirectory()) {
                delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_savePcDirOverwrite"));
                return this.showSaveCharacterChooser(character);
            }
            if (!(!file.exists() || prevFile != null && file.getName().equals(prevFile.getName()) || (overwrite = delegate.showWarningConfirm(LanguageBundle.getFormattedString("in_savePcConfirmOverTitle", file.getName()), LanguageBundle.getFormattedString("in_savePcConfirmOverMsg", file.getName()))))) {
                return this.showSaveCharacterChooser(character);
            }
            try {
                character.setFile(file);
                this.prepareForSave(character, false);
                if (!this.reallySaveCharacter(character)) {
                    return this.showSaveCharacterChooser(character);
                }
                this.lastCharacterPath = this.chooser.getCurrentDirectory().toString();
                return true;
            }
            catch (Exception e) {
                Logging.errorPrint("Error saving character to new file " + file, e);
                delegate.showErrorMessage("PCGen", LanguageBundle.getFormattedString("in_saveFailMsg", file.getName()));
            }
        }
        return false;
    }

    public void revertCharacter(CharacterFacade character) {
        int ret;
        if (character.isDirty() && (ret = JOptionPane.showConfirmDialog(this, LanguageBundle.getFormattedString("in_revertPcChoice", character.getNameRef().getReference()), "PCGen", 0)) == 0) {
            CharacterManager.removeCharacter(character);
            if (character.getFileRef().getReference() != null && character.getFileRef().getReference().exists()) {
                this.openCharacter(character.getFileRef().getReference(), this.currentDataSetRef.getReference());
            } else {
                this.createNewCharacter();
            }
        }
    }

    void showOpenCharacterChooser() {
        PCGenSettings context = PCGenSettings.getInstance();
        String path = this.lastCharacterPath;
        if (path == null) {
            path = context.getProperty("pcgen.files.characters");
        }
        this.chooser.setCurrentDirectory(new File(path));
        this.chooser.setSelectedFile(new File(""));
        this.chooser.resetChoosableFileFilters();
        PcgFileFilter filter = new PcgFileFilter();
        this.chooser.addChoosableFileFilter(filter);
        this.chooser.setFileFilter(filter);
        int ret = this.chooser.showOpenDialog(this);
        if (ret == 0) {
            File file = this.chooser.getSelectedFile();
            this.loadCharacterFromFile(file);
            this.lastCharacterPath = this.chooser.getCurrentDirectory().toString();
        }
    }

    void showOpenPartyChooser() {
        PCGenSettings context = PCGenSettings.getInstance();
        this.chooser.setCurrentDirectory(new File(context.getProperty("pcgen.files.parties")));
        this.chooser.resetChoosableFileFilters();
        this.chooser.setFileFilter(new PcpFileFilter());
        int returnVal = this.chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = this.chooser.getSelectedFile();
            this.loadPartyFromFile(file);
        }
    }

    public void createNewCharacter() {
        this.createNewCharacter(null);
    }

    private void createNewCharacter(File file) {
        DataSetFacade data = this.getLoadedDataSetRef().getReference();
        CharacterFacade character = CharacterManager.createNewCharacter(this, data);
        if (file != null) {
            character.setFile(file);
        }
        this.setSelectedCharacter(character);
    }

    public void loadCharacterFromFile(File pcgFile) {
        if (!PCGFile.isPCGenCharacterFile(pcgFile)) {
            JOptionPane.showMessageDialog(this, LanguageBundle.getFormattedString("in_loadPcInvalid", pcgFile), LanguageBundle.getString("in_loadPcFailTtile"), 0);
            return;
        }
        if (!pcgFile.canRead()) {
            JOptionPane.showMessageDialog(this, LanguageBundle.getFormattedString("in_loadPcNoRead", pcgFile), LanguageBundle.getString("in_loadPcFailTtile"), 0);
            return;
        }
        SourceSelectionFacade sources = CharacterManager.getRequiredSourcesForCharacter(pcgFile, this);
        if (sources == null) {
            JOptionPane.showMessageDialog(this, LanguageBundle.getFormattedString("in_loadPcNoSources", pcgFile), LanguageBundle.getString("in_loadPcFailTtile"), 0);
        } else if (!sources.getCampaigns().isEmpty()) {
            boolean dontLoadSources = this.currentSourceSelection.getReference() != null && !PCGenSettings.OPTIONS_CONTEXT.initBoolean("autoloadSourcesWithPC", true);
            boolean sourcesSame = this.checkSourceEquality(sources, this.currentSourceSelection.getReference());
            boolean gameModesSame = this.checkGameModeEquality(sources, this.currentSourceSelection.getReference());
            if (!dontLoadSources && !sourcesSame && gameModesSame) {
                Object[] btnNames = new Object[]{LanguageBundle.getString("in_loadPcDiffSourcesLoaded"), LanguageBundle.getString("in_loadPcDiffSourcesCharacter"), LanguageBundle.getString("in_cancel")};
                int choice = JOptionPane.showOptionDialog(this, LanguageBundle.getFormattedString("in_loadPcDiffSources", this.getFormattedCampaigns(this.currentSourceSelection.getReference()), this.getFormattedCampaigns(sources)), LanguageBundle.getString("in_loadPcSourcesLoadTitle"), 1, 3, null, btnNames, null);
                if (choice == 2) {
                    return;
                }
                if (choice == 0) {
                    this.openCharacter(pcgFile, this.currentDataSetRef.getReference());
                    return;
                }
            }
            if (dontLoadSources) {
                if (!this.checkSourceEquality(sources, this.currentSourceSelection.getReference())) {
                    Logging.log(Logging.WARNING, "Loading character with different sources. Character: " + sources + " current: " + this.currentSourceSelection.getReference());
                }
                this.openCharacter(pcgFile, this.currentDataSetRef.getReference());
            } else if (this.loadSourceSelection(sources)) {
                this.loadSourcesThenCharacter(pcgFile);
            } else {
                JOptionPane.showMessageDialog(this, LanguageBundle.getString("in_loadPcIncompatSource"), LanguageBundle.getString("in_loadPcFailTtile"), 0);
            }
        } else if (this.currentDataSetRef.getReference() != null) {
            if (this.showWarningConfirm("PCGen", LanguageBundle.getFormattedString("in_loadPcSourcesLoadQuery", pcgFile))) {
                this.openCharacter(pcgFile, this.currentDataSetRef.getReference());
            }
        } else {
            JOptionPane.showMessageDialog(this, LanguageBundle.getFormattedString("in_loadPcNoSources", pcgFile), LanguageBundle.getString("in_loadPcFailTtile"), 0);
        }
    }

    private void openCharacter(final File pcgFile, final DataSetFacade reference) {
        String msg = LanguageBundle.getFormattedString("in_loadPcLoadingFile", pcgFile.getName());
        this.statusBar.startShowingProgress(msg, false);
        this.statusBar.getProgressBar().getModel().setRangeProperties(0, 1, 0, 2, false);
        this.statusBar.getProgressBar().setString(LanguageBundle.getString("in_loadPcOpening"));
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CharacterManager.openCharacter(pcgFile, PCGenFrame.this, reference);
                    PCGenFrame.this.statusBar.getProgressBar().getModel().setRangeProperties(1, 1, 0, 2, false);
                }
                catch (Exception e) {
                    Logging.errorPrint("Error loading character: " + pcgFile.getName(), e);
                }
                finally {
                    PCGenFrame.this.statusBar.endShowingProgress();
                }
            }
        });
    }

    private String getFormattedCampaigns(SourceSelectionFacade sources) {
        StringBuilder campList = new StringBuilder(100);
        campList.append("<UL>");
        int count = 1;
        int maxListLen = 6;
        for (CampaignFacade facade : sources.getCampaigns()) {
            campList.append("<li>");
            if (count >= 6 && sources.getCampaigns().getSize() > 6) {
                int numExtra = sources.getCampaigns().getSize() - 6 + 1;
                campList.append(LanguageBundle.getFormattedString("in_loadPcDiffSourcesExcessSources", String.valueOf(numExtra)));
                break;
            }
            campList.append(facade.toString());
            campList.append("</li>");
            ++count;
        }
        campList.append("</UL>");
        return campList.toString();
    }

    private void loadSourcesThenCharacter(final File pcgFile) {
        new Thread(){

            @Override
            public void run() {
                try {
                    PCGenFrame.this.sourceLoader.join();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            String msg = LanguageBundle.getFormattedString("in_loadPcLoadingFile", pcgFile.getName());
                            PCGenFrame.this.statusBar.startShowingProgress(msg, false);
                            PCGenFrame.this.statusBar.getProgressBar().getModel().setRangeProperties(0, 1, 0, 2, false);
                            PCGenFrame.this.statusBar.getProgressBar().setString(LanguageBundle.getString("in_loadPcOpening"));
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                CharacterManager.openCharacter(pcgFile, PCGenFrame.this, (DataSetFacade)PCGenFrame.this.currentDataSetRef.getReference());
                                PCGenFrame.this.statusBar.getProgressBar().getModel().setRangeProperties(1, 1, 0, 2, false);
                            }
                            catch (Exception e) {
                                Logging.errorPrint("Error loading character: " + pcgFile.getName(), e);
                            }
                            finally {
                                PCGenFrame.this.statusBar.endShowingProgress();
                            }
                        }
                    });
                }
                catch (InterruptedException ex) {
                }
                catch (InvocationTargetException e1) {
                    Logging.errorPrint("Error showing progress bar.", e1);
                }
            }
        }.start();
    }

    public void loadPartyFromFile(final File pcpFile) {
        if (!PCGFile.isPCGenPartyFile(pcpFile)) {
            JOptionPane.showMessageDialog(this, LanguageBundle.getFormattedString("in_loadPartyInvalid", pcpFile), LanguageBundle.getString("in_loadPartyFailTtile"), 0);
            return;
        }
        if (!pcpFile.canRead()) {
            JOptionPane.showMessageDialog(this, LanguageBundle.getFormattedString("in_loadPartyNoRead", pcpFile), LanguageBundle.getString("in_loadPartyFailTtile"), 0);
            return;
        }
        SourceSelectionFacade sources = CharacterManager.getRequiredSourcesForParty(pcpFile, this);
        if (sources == null) {
            JOptionPane.showMessageDialog(this, LanguageBundle.getFormattedString("in_loadPartyNoSources", pcpFile), LanguageBundle.getString("in_loadPartyFailTtile"), 0);
        } else if (!sources.getCampaigns().isEmpty()) {
            boolean dontLoadSources;
            boolean bl = dontLoadSources = this.currentSourceSelection.getReference() != null && !PCGenSettings.OPTIONS_CONTEXT.initBoolean("autoloadSourcesWithPC", true);
            if (dontLoadSources) {
                if (!this.checkSourceEquality(sources, this.currentSourceSelection.getReference())) {
                    Logging.log(Logging.WARNING, "Loading party with different sources. Party: " + sources + " current: " + this.currentSourceSelection.getReference());
                }
                CharacterManager.openParty(pcpFile, this, this.currentDataSetRef.getReference());
            } else if (this.loadSourceSelection(sources)) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            PCGenFrame.this.sourceLoader.join();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CharacterManager.openParty(pcpFile, PCGenFrame.this, (DataSetFacade)PCGenFrame.this.currentDataSetRef.getReference());
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }.start();
            } else {
                JOptionPane.showMessageDialog(this, LanguageBundle.getString("in_loadPcIncompatSource"), LanguageBundle.getString("in_loadPartyFailTtile"), 0);
            }
        }
    }

    private void updateTitle() {
        StringBuilder title = new StringBuilder(100);
        File characterFile = null;
        String characterFileName = null;
        String sourceName = null;
        if (this.currentCharacterRef != null && this.currentCharacterRef.getReference() != null) {
            characterFile = this.currentCharacterRef.getReference().getFileRef().getReference();
            characterFileName = characterFile == null || StringUtils.isEmpty(characterFile.getName()) ? LanguageBundle.getString("in_unsaved_char") : characterFile.getName();
        }
        if (this.currentSourceSelection.getReference() != null) {
            sourceName = this.currentSourceSelection.getReference().toString();
        }
        if (characterFileName != null && characterFileName.length() > 0) {
            title.append(characterFileName);
            title.append(" - ");
        }
        if (sourceName != null && sourceName.length() > 0) {
            title.append(sourceName);
            title.append(" - ");
        }
        title.append("PCGen v");
        title.append(PCGenPropBundle.getVersionNumber());
        this.setTitle(title.toString());
    }

    public void showTipsOfTheDay() {
        TipOfTheDay tips = new TipOfTheDay(this);
        Utility.setDialogRelativeLocation(this, tips);
        tips.setVisible(true);
    }

    public void showSourceSelectionDialog() {
        if (this.sourceSelectionDialog == null) {
            this.sourceSelectionDialog = new SourceSelectionDialog(this);
        }
        Utility.setDialogRelativeLocation(this, this.sourceSelectionDialog);
        this.sourceSelectionDialog.setVisible(true);
    }

    public static JPanel buildMessageLabelPanel(String message, JCheckBox checkbox) {
        JLabel label;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        cons.anchor = 17;
        cons.insets = new Insets(0, 0, 3, 0);
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        int start = 0;
        int sepPos = -1;
        do {
            String part;
            if ((sepPos = message.indexOf("\n", start)) >= 0) {
                part = message.substring(start, sepPos);
                start = sepPos + 1;
            } else {
                part = message.substring(start);
                start = -1;
            }
            label = new JLabel(part, 10);
            panel.add((Component)label, cons);
            ++cons.gridy;
        } while (start >= 0);
        if (checkbox != null) {
            label = new JLabel("", 10);
            panel.add((Component)label, cons);
            ++cons.gridy;
            panel.add((Component)checkbox, cons);
            ++cons.gridy;
        }
        return panel;
    }

    @Override
    public Boolean maybeShowWarningConfirm(String title, String message, String checkBoxText, final PropertyContext context, final String contextProp) {
        if (!context.getBoolean(contextProp, true)) {
            return null;
        }
        final JCheckBox checkBox = new JCheckBox(checkBoxText, true);
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                context.setBoolean(contextProp, checkBox.isSelected());
            }
        });
        JPanel panel = PCGenFrame.buildMessageLabelPanel(message, checkBox);
        int ret = JOptionPane.showConfirmDialog(this, panel, title, 0, 2);
        return ret == 0;
    }

    @Override
    public boolean showWarningConfirm(String title, String message) {
        JComponent msgComp = this.getComponentForMessage(message);
        int ret = JOptionPane.showConfirmDialog(this, msgComp, title, 0, 2);
        return ret == 0;
    }

    private JComponent getComponentForMessage(String message) {
        JLabel jLabel = new JLabel(message);
        JScrollPane scroller = new JScrollPane(jLabel);
        Dimension size = jLabel.getPreferredSize();
        int decorationHeight = 80;
        int decorationWidth = 70;
        Rectangle screenBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        boolean scrollerNeeded = false;
        if (size.height > screenBounds.height - 80) {
            size.height = screenBounds.height - 80;
            scrollerNeeded = true;
        }
        if (size.width > screenBounds.width - 70) {
            size.width = screenBounds.width - 70;
            scrollerNeeded = true;
        } else if (scrollerNeeded) {
            scroller.setHorizontalScrollBarPolicy(31);
        }
        scroller.setPreferredSize(size);
        return scrollerNeeded ? scroller : jLabel;
    }

    private boolean showMessageConfirm(String title, String message) {
        JComponent msgComp = this.getComponentForMessage(message);
        int ret = JOptionPane.showConfirmDialog(this, msgComp, title, 0);
        return ret == 0;
    }

    @Override
    public void showErrorMessage(String title, String message) {
        JComponent msgComp = this.getComponentForMessage(message);
        JOptionPane.showMessageDialog(this, msgComp, title, 0);
    }

    @Override
    public void showInfoMessage(String title, String message) {
        JComponent msgComp = this.getComponentForMessage(message);
        JOptionPane.showMessageDialog(this, msgComp, title, 1);
    }

    @Override
    public void showWarningMessage(String title, String message) {
        JComponent msgComp = this.getComponentForMessage(message);
        JOptionPane.showMessageDialog(this, msgComp, title, 2);
    }

    @Override
    public boolean showWarningPrompt(String title, String message) {
        JComponent msgComp = this.getComponentForMessage(message);
        int ret = JOptionPane.showConfirmDialog(this, msgComp, title, 2, 2);
        return ret == 0;
    }

    @Override
    public String showInputDialog(String title, String message, String initialValue) {
        Object ret = JOptionPane.showInputDialog(this, message, title, 3, null, null, initialValue);
        return ret == null ? null : String.valueOf(ret);
    }

    @Override
    public void showLevelUpInfo(CharacterFacade character, int oldLevel) {
        PostLevelUpDialog.showPostLevelUpDialog(this, character, oldLevel);
    }

    @Override
    public boolean showGeneralChooser(ChooserFacade chooserFacade) {
        ChoiceHandler choiceHandler = ChooserFactory.getChoiceHandler();
        if (choiceHandler != null) {
            return choiceHandler.makeChoice(chooserFacade);
        }
        if (chooserFacade.isPreferRadioSelection() && chooserFacade.getAvailableList().getSize() <= 20 && chooserFacade.getRemainingSelections().getReference() == 1) {
            RadioChooserDialog dialog = new RadioChooserDialog((Frame)this, chooserFacade);
            Utility.setDialogRelativeLocation(this, dialog);
            dialog.setVisible(true);
            return dialog.isCommitted();
        }
        ChooserDialog dialog = new ChooserDialog((Frame)this, chooserFacade);
        Utility.setDialogRelativeLocation(this, dialog);
        dialog.setVisible(true);
        return dialog.isCommitted();
    }

    public void showOGLDialog() {
        this.showLicenseDialog(LanguageBundle.getString("in_oglTitle"), this.section15);
    }

    private void showLicenseDialog(String title, String htmlString) {
        if (htmlString == null) {
            htmlString = LanguageBundle.getString("in_licNoInfo");
        }
        final PropertyContext context = PCGenSettings.OPTIONS_CONTEXT;
        final JDialog aFrame = new JDialog(this, title, true);
        JButton jClose = new JButton(LanguageBundle.getString("in_close"));
        jClose.setMnemonic(LanguageBundle.getMnemonic("in_mn_close"));
        JPanel jPanel = new JPanel();
        final JCheckBox jCheckBox = new JCheckBox(LanguageBundle.getString("in_licShowOnLoad"));
        jPanel.add(jCheckBox);
        jCheckBox.setSelected(context.getBoolean("showLicense"));
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                context.setBoolean("showLicense", jCheckBox.isSelected());
            }
        });
        jPanel.add(jClose);
        jClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                aFrame.dispose();
            }
        });
        HtmlPanel htmlPanel = new HtmlPanel();
        SimpleHtmlRendererContext theRendererContext = new SimpleHtmlRendererContext(htmlPanel, new SimpleUserAgentContext());
        htmlPanel.setHtml(htmlString, "", theRendererContext);
        aFrame.getContentPane().setLayout(new BorderLayout());
        aFrame.getContentPane().add((Component)htmlPanel, "Center");
        aFrame.getContentPane().add((Component)jPanel, "South");
        aFrame.setSize(new Dimension(700, 500));
        aFrame.setLocationRelativeTo(this);
        Utility.setDialogRelativeLocation(this, aFrame);
        aFrame.getRootPane().setDefaultButton(jClose);
        Utility.installEscapeCloseOperation(aFrame);
        aFrame.setVisible(true);
    }

    private void showMatureDialog(String text) {
        Logging.errorPrint("Warning: The following datasets contains mature themes. User discretion is advised.");
        Logging.errorPrint(text);
        final JDialog aFrame = new JDialog(this, LanguageBundle.getString("in_matureTitle"), true);
        JPanel jPanel1 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel1 = new JLabel(LanguageBundle.getString("in_matureWarningLine1"), 0);
        JLabel jLabel2 = new JLabel(LanguageBundle.getString("in_matureWarningLine2"), 0);
        final JCheckBox jCheckBox1 = new JCheckBox(LanguageBundle.getString("in_licShowOnLoad"));
        JButton jClose = new JButton(LanguageBundle.getString("in_close"));
        jClose.setMnemonic(LanguageBundle.getMnemonic("in_mn_close"));
        jPanel1.setLayout(new BorderLayout());
        jPanel1.add((Component)jLabel1, "North");
        jPanel1.add((Component)jLabel2, "South");
        HtmlPanel htmlPanel = new HtmlPanel();
        SimpleHtmlRendererContext theRendererContext = new SimpleHtmlRendererContext(htmlPanel, new SimpleUserAgentContext());
        htmlPanel.setHtml(text, "", theRendererContext);
        jPanel3.add(jCheckBox1);
        jPanel3.add(jClose);
        final PropertyContext context = PCGenSettings.OPTIONS_CONTEXT;
        jCheckBox1.setSelected(context.getBoolean("showMatureOnLoad"));
        jClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                aFrame.dispose();
            }
        });
        jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                context.setBoolean("showMatureOnLoad", jCheckBox1.isSelected());
            }
        });
        aFrame.getContentPane().setLayout(new BorderLayout());
        aFrame.getContentPane().add((Component)jPanel1, "North");
        aFrame.getContentPane().add((Component)htmlPanel, "Center");
        aFrame.getContentPane().add((Component)jPanel3, "South");
        aFrame.setSize(new Dimension(456, 176));
        Utility.setDialogRelativeLocation(this, aFrame);
        aFrame.setVisible(true);
    }

    public void showSponsorsDialog() {
        Collection<Sponsor> sponsors = Globals.getGlobalContext().getReferenceContext().getConstructedCDOMObjects(Sponsor.class);
        if (sponsors.size() <= 1) {
            return;
        }
        String title = LanguageBundle.getString("in_sponsorTitle");
        final JDialog aFrame = new JDialog(this, title, true);
        JButton jClose = new JButton(LanguageBundle.getString("in_close"));
        jClose.setMnemonic(LanguageBundle.getMnemonic("in_mn_close"));
        JPanel jPanel = new JPanel();
        final JCheckBox jCheckBox = new JCheckBox(LanguageBundle.getString("in_licShowOnLoad"));
        jPanel.add(jCheckBox);
        final PropertyContext context = PCGenSettings.OPTIONS_CONTEXT;
        jCheckBox.setSelected(context.getBoolean("showSponsorsOnLoad"));
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                context.setBoolean("showSponsorsOnLoad", jCheckBox.isSelected());
            }
        });
        jPanel.add(jClose);
        jClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                aFrame.dispose();
            }
        });
        StringBuilder sb = new StringBuilder(500);
        sb.append("<html>");
        for (Sponsor sponsor : sponsors) {
            if (!"PCGEN".equals(sponsor.getKeyName())) continue;
            sb.append("<img src='").append(sponsor.getBannerImage()).append("'><br>");
        }
        String s = "";
        if (sponsors.size() > 2) {
            s = "s";
        }
        sb.append("<H2><CENTER>").append(LanguageBundle.getString("in_sponsorThanks")).append(s).append(":</CENTER></h2>");
        int size = 172;
        for (Sponsor sponsor : sponsors) {
            if ("PCGEN".equals(sponsor.getKeyName())) continue;
            size += 70;
            sb.append("<img src='").append(sponsor.getBannerImage()).append("'><br>");
        }
        sb.append("</html>");
        HtmlPanel htmlPanel = new HtmlPanel();
        SimpleHtmlRendererContext theRendererContext = new SimpleHtmlRendererContext(htmlPanel, new SimpleUserAgentContext());
        htmlPanel.setHtml(sb.toString(), "", theRendererContext);
        aFrame.getContentPane().setLayout(new BorderLayout());
        aFrame.getContentPane().add((Component)htmlPanel, "Center");
        aFrame.getContentPane().add((Component)jPanel, "South");
        aFrame.setSize(new Dimension(505, size));
        Utility.setDialogRelativeLocation(this, aFrame);
        aFrame.setVisible(true);
    }

    public void showAboutDialog() {
        new AboutDialog(this).setVisible(true);
    }

    @Override
    public UIDelegate.CustomEquipResult showCustomEquipDialog(CharacterFacade character, EquipmentBuilderFacade equipBuilder) {
        EquipCustomizerDialog eqDialog = new EquipCustomizerDialog(this, character, equipBuilder);
        Utility.setDialogRelativeLocation(this, eqDialog);
        eqDialog.setVisible(true);
        UIDelegate.CustomEquipResult result = eqDialog.isCancelled() ? UIDelegate.CustomEquipResult.CANCELLED : (eqDialog.isPurchase() ? UIDelegate.CustomEquipResult.PURCHASE : UIDelegate.CustomEquipResult.OK);
        return result;
    }

    @Override
    public boolean showCustomSpellDialog(SpellBuilderFacade spellBuilderFI) {
        SpellChoiceDialog spellDialog = new SpellChoiceDialog(this, spellBuilderFI);
        Utility.setDialogRelativeLocation(this, spellDialog);
        spellDialog.setVisible(true);
        return !spellDialog.isCancelled();
    }

    private static String readTextFromFile(String fileName) {
        String aString;
        File aFile = new File(fileName);
        if (!aFile.exists()) {
            Logging.errorPrint("Could not find license at " + fileName);
            String aString2 = LanguageBundle.getString("in_licNoInfo");
            return aString2;
        }
        try {
            BufferedReader theReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aFile), "UTF-8"));
            int length = (int)aFile.length();
            char[] inputLine = new char[length];
            theReader.read(inputLine, 0, length);
            theReader.close();
            aString = new String(inputLine);
        }
        catch (IOException e) {
            Logging.errorPrint("Could not read license at " + fileName, e);
            aString = "No license information found";
        }
        return aString;
    }

    private class FilenameListener
    implements ReferenceListener<File> {
        private FilenameListener() {
        }

        @Override
        public void referenceChanged(ReferenceEvent<File> e) {
            PCGenFrame.this.updateTitle();
        }
    }

    private class SourceLoadWorker
    extends Thread {
        private final SourceSelectionFacade sources;
        private final SourceFileLoader loader;
        private final SwingWorker<List<LogRecord>> worker;
        private final UIDelegate delegate;

        public SourceLoadWorker(SourceSelectionFacade sources, UIDelegate delegate) {
            this.sources = sources;
            this.delegate = delegate;
            this.loader = new SourceFileLoader(sources, delegate);
            this.worker = PCGenFrame.this.statusBar.createWorker(LanguageBundle.getString("in_taskLoadSources"), this.loader);
        }

        @Override
        public void run() {
            this.worker.start();
            PCGenFrame.this.statusBar.setSourceLoadErrors(this.worker.get());
            StringBuilder sec15 = new StringBuilder(" ");
            sec15.append(PCGenFrame.readTextFromFile(ConfigurationSettings.getSystemsDir() + File.separator + "opengaminglicense.10a.txt"));
            sec15.append(this.loader.getOGL());
            PCGenFrame.this.section15 = sec15.toString();
            try {
                this.showLicenses();
            }
            catch (Throwable e) {
                Logging.errorPrint("Failed to show licences.", e);
            }
            DataSetFacade data = this.loader.getDataSetFacade();
            if (data != null) {
                PCGenFrame.this.currentSourceSelection.setReference(this.sources);
                StringBuilder sourceString = new StringBuilder(100);
                ListFacade<CampaignFacade> campaigns = this.sources.getCampaigns();
                for (int i = 0; i < campaigns.getSize(); ++i) {
                    if (i > 0) {
                        sourceString.append('|');
                    }
                    sourceString.append(campaigns.getElementAt(i));
                }
                PCGenSettings.getInstance().setProperty("lastLoadedGame", this.sources.getGameMode().toString());
                PCGenSettings.getInstance().setProperty("lastLoadedSources", sourceString.toString());
            } else {
                PCGenFrame.this.currentSourceSelection.setReference(null);
            }
            PCGenFrame.this.currentDataSetRef.setReference(data);
            PCGenFrame.this.updateTitle();
        }

        private void showLicenses() {
            PropertyContext context = PCGenSettings.OPTIONS_CONTEXT;
            if (context.initBoolean("showLicense", true)) {
                if (this.loader.hasOGLCampaign()) {
                    PCGenFrame.this.showOGLDialog();
                }
                if (this.loader.hasLicensedCampaign()) {
                    String licenses = this.loader.getLicenses();
                    if (licenses.trim().length() > 0) {
                        PCGenFrame.this.showLicenseDialog(LanguageBundle.getString("in_specialLicenses"), licenses);
                    }
                    for (String license : this.loader.getOtherLicenses()) {
                        PCGenFrame.this.showLicenseDialog(LanguageBundle.getString("in_specialLicenses"), license);
                    }
                }
            }
            if (this.loader.hasMatureCampaign() && context.initBoolean("showMatureOnLoad", true)) {
                PCGenFrame.this.showMatureDialog(this.loader.getMatureInfo());
            }
            if (context.initBoolean("showSponsorsOnLoad", true)) {
                PCGenFrame.this.showSponsorsDialog();
            }
        }
    }

    private class StartupWorker
    extends Thread {
        private StartupWorker() {
        }

        @Override
        public void run() {
            try {
                boolean alternateStartup = false;
                alternateStartup |= this.maybeLoadCampaign();
                alternateStartup |= this.maybeLoadOrCreateCharacter();
                alternateStartup |= this.maybeStartInNPCGen();
                alternateStartup |= this.maybeStartInGMGen();
                if (!(alternateStartup |= this.maybeAutoLoadSources())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (TipOfTheDay.showTipOfTheDay()) {
                                PCGenFrame.this.showTipsOfTheDay();
                            }
                            if (!SourceSelectionDialog.skipSourceSelection()) {
                                PCGenFrame.this.showSourceSelectionDialog();
                            }
                        }
                    });
                }
            }
            catch (InterruptedException ex) {
                Logging.errorPrint("Unexepected exception", ex);
            }
            catch (InvocationTargetException ex) {
                Logging.errorPrint("Unexepected exception", ex.getCause());
            }
        }

        private boolean maybeAutoLoadSources() throws InterruptedException {
            boolean autoLoadSources = PCGenSettings.OPTIONS_CONTEXT.initBoolean("autoloadSourcesAtStart", false);
            if (autoLoadSources) {
                String gameModeName = PCGenSettings.getInstance().getProperty("lastLoadedGame");
                String sourcesNameString = PCGenSettings.getInstance().getProperty("lastLoadedSources");
                if (StringUtils.isEmpty(gameModeName) || StringUtils.isEmpty(sourcesNameString)) {
                    return false;
                }
                GameModeFacade gameMode = null;
                for (GameModeFacade facade : FacadeFactory.getGameModes()) {
                    if (!gameModeName.equals(facade.toString())) continue;
                    gameMode = facade;
                    break;
                }
                if (gameMode == null) {
                    return false;
                }
                ArrayList<CampaignFacade> campaigns = new ArrayList<CampaignFacade>();
                String[] sourceNames = sourcesNameString.split("\\|");
                block1: for (CampaignFacade camp : FacadeFactory.getCampaigns()) {
                    for (String name : sourceNames) {
                        if (!name.equals(camp.toString())) continue;
                        campaigns.add(camp);
                        continue block1;
                    }
                }
                SourceSelectionFacade selection = FacadeFactory.createSourceSelection(gameMode, campaigns);
                if (selection != null) {
                    PCGenFrame.this.loadSourceSelection(selection);
                    PCGenFrame.this.sourceLoader.join();
                    return true;
                }
            }
            return false;
        }

        private boolean maybeLoadCampaign() throws InterruptedException {
            String camp = Main.getStartupCampaign();
            if (camp != null) {
                SourceSelectionFacade selection = null;
                ListFacade<SourceSelectionFacade> sources = FacadeFactory.getSourceSelections();
                for (SourceSelectionFacade sourceSelectionFacade : sources) {
                    if (!sourceSelectionFacade.toString().equals(camp)) continue;
                    selection = sourceSelectionFacade;
                    break;
                }
                if (selection != null) {
                    PCGenFrame.this.loadSourceSelection(selection);
                    PCGenFrame.this.sourceLoader.join();
                    return true;
                }
                Logging.errorPrint("Ignoring invalid campaign requested in -m flag: '" + camp + "'.");
                return false;
            }
            return false;
        }

        private boolean maybeLoadOrCreateCharacter() throws InterruptedException, InvocationTargetException {
            if (Main.getStartupCharacterFile() == null) {
                return false;
            }
            final File file = new File(Main.getStartupCharacterFile());
            final DataSetFacade dataset = (DataSetFacade)PCGenFrame.this.currentDataSetRef.getReference();
            if (!file.exists() && dataset == null) {
                return false;
            }
            if (Main.shouldStartInCharacterSheet()) {
                String key = "initialTab";
                key = UIPropertyContext.createFilePropertyKey(file, key);
                UIPropertyContext.getInstance().setInt(key, 10);
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (!file.exists()) {
                        PCGenFrame.this.createNewCharacter(file);
                    } else if (dataset == null) {
                        PCGenFrame.this.loadCharacterFromFile(file);
                    } else {
                        PCGenFrame.this.openCharacter(file, dataset);
                    }
                }
            });
            return true;
        }

        private boolean maybeStartInNPCGen() {
            return Main.shouldStartInNPCGen();
        }

        private boolean maybeStartInGMGen() {
            if (!Main.shouldStartInGMGen()) {
                return false;
            }
            PCGenUIManager.displayGmGen();
            return true;
        }
    }
}

