/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import pcgen.cdom.helper.ClassSource;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.term.BasePCTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class PCMaxCastableDomainTermEvaluator
extends BasePCTermEvaluator
implements TermEvaluator {
    private final String domainKey;

    public PCMaxCastableDomainTermEvaluator(String originalText, String domainKey) {
        this.domainKey = domainKey;
        this.originalText = originalText;
    }

    @Override
    public Float resolve(PlayerCharacter pc) {
        Domain domain = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Domain.class, this.domainKey);
        if (domain == null) {
            return Float.valueOf(0.0f);
        }
        ClassSource source = pc.getDomainSource(domain);
        if (source == null) {
            return Float.valueOf(0.0f);
        }
        String classKey = source.getPcclass().getKeyName();
        PCClass spClass = pc.getClassKeyed(classKey);
        int cutoff = pc.getSpellSupport(spClass).getHighestLevelSpell();
        Float max = Float.valueOf(0.0f);
        if (pc.getSpellSupport(spClass).hasCastList()) {
            for (int i = 0; i < cutoff; ++i) {
                if (pc.getSpellSupport(spClass).getCastForLevel(i, pc) == 0) continue;
                max = Float.valueOf(Math.max(max.floatValue(), (float)i));
            }
        } else {
            for (int i = 0; i < cutoff; ++i) {
                if (pc.getSpellSupport(spClass).getKnownForLevel(i, "null", pc) == 0) continue;
                max = Float.valueOf(Math.max(max.floatValue(), (float)i));
            }
        }
        return max;
    }

    @Override
    public boolean isSourceDependant() {
        return true;
    }

    public boolean isStatic() {
        return false;
    }
}

