/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitGear;

public class KitTable
extends BaseKit {
    private String tableName;
    private List<TableEntry> list = new ArrayList<TableEntry>();

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void addGear(KitGear optionInfo, Formula min, Formula max) {
        this.list.add(new TableEntry(optionInfo, min, max));
    }

    public List<TableEntry> getList() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public void apply(PlayerCharacter aPC) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getObjectName() {
        return "Table";
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        throw new UnsupportedOperationException();
    }

    public KitGear getEntry(PlayerCharacter pc, int value) {
        for (TableEntry entry : this.list) {
            if (!entry.isIn(pc, value)) continue;
            return entry.gear;
        }
        return null;
    }

    public static class TableEntry {
        public final KitGear gear;
        public final Formula lowRange;
        public final Formula highRange;

        public TableEntry(KitGear optionInfo, Formula min, Formula max) {
            this.gear = optionInfo;
            this.lowRange = min;
            this.highRange = max;
        }

        public boolean isIn(PlayerCharacter pc, int inValue) {
            int lv = this.lowRange.resolve(pc, "").intValue();
            int hv = this.highRange.resolve(pc, "").intValue();
            return inValue >= lv && inValue <= hv;
        }
    }
}

