/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.Globals;
import pcgen.core.PCTemplate;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreTemplateTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    private static final Class<PCTemplate> PCTEMPLATE_CLASS = PCTemplate.class;

    @Override
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) throws PrerequisiteException {
        int number;
        int runningTotal = 0;
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException exceptn) {
            throw new PrerequisiteException(LanguageBundle.getFormattedString("PreTemplate.error", prereq.toString()));
        }
        if (display.hasTemplates()) {
            String templateKey = prereq.getKey().toUpperCase();
            int wildCard = templateKey.indexOf(37);
            if (wildCard >= 0) {
                templateKey = templateKey.substring(0, wildCard);
                for (PCTemplate aTemplate : display.getTemplateSet()) {
                    if (!aTemplate.getKeyName().toUpperCase().startsWith(templateKey)) continue;
                    ++runningTotal;
                }
            } else {
                PCTemplate template = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCTEMPLATE_CLASS, templateKey);
                if (display.hasTemplate(template)) {
                    ++runningTotal;
                }
            }
        }
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String kindHandled() {
        return "TEMPLATE";
    }
}

