/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PCClass;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreSpellCastMemorizeTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    @Override
    public String kindHandled() {
        return "spellcast.memorize";
    }

    @Override
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) {
        int requiredNumber = Integer.parseInt(prereq.getOperand());
        boolean prereqMemorized = prereq.getKey().toUpperCase().startsWith("Y");
        int runningTotal = 0;
        for (PCClass aClass : display.getClassSet()) {
            if (aClass.getSafe(ObjectKey.MEMORIZE_SPELLS) != prereqMemorized) continue;
            ++runningTotal;
        }
        runningTotal = prereq.getOperator().compare(runningTotal, requiredNumber);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String toHtmlString(Prerequisite prereq) {
        boolean prereqMemorized = prereq.getKey().toUpperCase().startsWith("Y");
        Object[] args = new Object[]{prereq.getOperator().toDisplayString(), prereq.getOperand()};
        if (prereqMemorized) {
            return LanguageBundle.getFormattedString("PreSpellCastMemorize.toHtml_does_memorise", args);
        }
        return LanguageBundle.getFormattedString("PreSpellCastMemorize.toHtml_does_not_memorise", args);
    }
}

