/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.content.CampaignURL;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Campaign;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class UrlToken
implements CDOMPrimaryToken<Campaign> {
    private static final String URL_KIND_NAME_WEBSITE = "WEBSITE";
    private static final String URL_KIND_NAME_SURVEY = "SURVEY";

    @Override
    public String getTokenName() {
        return "URL";
    }

    @Override
    public ParseResult parseToken(LoadContext context, Campaign campaign, String value) {
        URI uri;
        CampaignURL.URLKind urlType;
        StringTokenizer tok = new StringTokenizer(value, "|");
        if (tok.countTokens() != 3) {
            return new ParseResult.Fail("URL token requires three arguments. Link kind, link and description.  : " + value, context);
        }
        String urlTypeName = tok.nextToken();
        String urlText = tok.nextToken();
        String urlDesc = tok.nextToken();
        if (urlTypeName.equalsIgnoreCase(URL_KIND_NAME_WEBSITE)) {
            if (!urlTypeName.equals(URL_KIND_NAME_WEBSITE)) {
                Logging.log(Logging.LST_WARNING, "URL type should be WEBSITE in upper case : " + value);
            }
            urlType = CampaignURL.URLKind.WEBSITE;
            urlTypeName = "";
        } else if (urlTypeName.equalsIgnoreCase(URL_KIND_NAME_SURVEY)) {
            if (!urlTypeName.equals(URL_KIND_NAME_SURVEY)) {
                Logging.log(Logging.LST_WARNING, "URL type should be SURVEY in upper case : " + value);
            }
            urlType = CampaignURL.URLKind.SURVEY;
            urlTypeName = "";
        } else {
            urlType = CampaignURL.URLKind.PURCHASE;
        }
        try {
            uri = new URI(urlText);
        }
        catch (URISyntaxException e) {
            return new ParseResult.Fail("Invalid URL (" + e.getMessage() + ") : " + value, context);
        }
        CampaignURL campUrl = new CampaignURL(urlType, urlTypeName, uri, urlDesc);
        context.getObjectContext().addToList(campaign, ListKey.CAMPAIGN_URL, campUrl);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Campaign campaign) {
        Changes<CampaignURL> changes = context.getObjectContext().getListChanges(campaign, ListKey.CAMPAIGN_URL);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection<CampaignURL> added = changes.getAdded();
        if (added != null && !added.isEmpty()) {
            ArrayList list = new ArrayList();
            for (CampaignURL curl : added) {
                StringBuilder sb = new StringBuilder();
                sb.append((Object)curl.getUrlKind());
                sb.append("|");
                sb.append(curl.getUri().toString());
                sb.append("|");
                sb.append(curl.getUrlDesc());
            }
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    @Override
    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

