/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.context;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.ListSet;
import pcgen.base.util.TreeMapToList;
import pcgen.base.util.TripleKeyMap;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMObjectUtilities;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.MasterListInterface;
import pcgen.cdom.base.SimpleAssociatedObject;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Globals;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.AssociatedCollectionChanges;
import pcgen.rules.context.Changes;
import pcgen.rules.context.CollectionChanges;
import pcgen.rules.context.ListChanges;
import pcgen.rules.context.ListCommitStrategy;

public abstract class AbstractListContext {
    private final TrackingListCommitStrategy edits = new TrackingListCommitStrategy();

    URI getSourceURI() {
        return this.edits.getSourceURI();
    }

    void setSourceURI(URI sourceURI) {
        this.edits.setSourceURI(sourceURI);
        this.getCommitStrategy().setSourceURI(sourceURI);
    }

    URI getExtractURI() {
        return this.edits.getExtractURI();
    }

    void setExtractURI(URI extractURI) {
        this.edits.setExtractURI(extractURI);
        this.getCommitStrategy().setExtractURI(extractURI);
    }

    public <T extends CDOMObject> AssociatedPrereqObject addToMasterList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<T>> list, T allowed) {
        return this.edits.addToMasterList(tokenName, owner, list, allowed);
    }

    public <T extends CDOMObject> void removeFromMasterList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<T>> list, T allowed) {
        this.edits.removeFromMasterList(tokenName, owner, list, allowed);
    }

    public void clearAllMasterLists(String tokenName, CDOMObject owner) {
        this.edits.clearAllMasterLists(tokenName, owner);
    }

    public <T extends CDOMObject> void clearMasterList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<T>> list) {
        this.edits.clearMasterList(tokenName, owner, list);
    }

    public <T extends CDOMObject> AssociatedPrereqObject addToList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<? super T>> list, CDOMReference<T> allowed) {
        return this.edits.addToList(tokenName, owner, list, allowed);
    }

    public <T extends CDOMObject> AssociatedPrereqObject removeFromList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<? super T>> list, CDOMReference<T> ref) {
        return this.edits.removeFromList(tokenName, owner, list, ref);
    }

    public void removeAllFromList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<?>> swl) {
        this.edits.removeAllFromList(tokenName, owner, swl);
    }

    void commit() {
        Collection<CDOMReference<CDOMList<?>>> modifiedLists;
        CDOMObject neg;
        ListCommitStrategy commit = this.getCommitStrategy();
        for (CDOMReference list : this.edits.positiveMasterMap.getKeySet()) {
            this.commitDirect(list);
        }
        for (CDOMReference list : this.edits.negativeMasterMap.getKeySet()) {
            this.removeDirect(list);
        }
        for (URI uri : this.edits.globalClearSet.getKeySet()) {
            for (CDOMObject owner : this.edits.globalClearSet.getSecondaryKeySet((Object)uri)) {
                for (String tokenName : this.edits.globalClearSet.getTertiaryKeySet((Object)uri, (Object)owner)) {
                    for (CDOMReference<CDOMList<Object>> cDOMReference : this.edits.globalClearSet.getListFor((Object)uri, (Object)owner, (Object)tokenName)) {
                        commit.removeAllFromList(tokenName, owner, cDOMReference);
                    }
                }
            }
        }
        for (URI uri : this.edits.negativeMap.getKeySet()) {
            for (CDOMObject owner : this.edits.negativeMap.getSecondaryKeySet((Object)uri)) {
                neg = (CDOMObject)this.edits.negativeMap.get((Object)uri, (Object)owner);
                modifiedLists = neg.getModifiedLists();
                for (CDOMReference<CDOMList<Object>> cDOMReference : modifiedLists) {
                    this.remove(owner, neg, cDOMReference);
                }
            }
        }
        for (URI uri : this.edits.positiveMap.getKeySet()) {
            for (CDOMObject owner : this.edits.positiveMap.getSecondaryKeySet((Object)uri)) {
                neg = (CDOMObject)this.edits.positiveMap.get((Object)uri, (Object)owner);
                modifiedLists = neg.getModifiedLists();
                for (CDOMReference<CDOMList<Object>> cDOMReference : modifiedLists) {
                    this.add(owner, neg, cDOMReference);
                }
            }
        }
        for (String token : this.edits.masterAllClear.getKeySet()) {
            for (OwnerURI ou : this.edits.masterAllClear.getListFor((Object)token)) {
                commit.clearAllMasterLists(token, ou.owner);
            }
        }
        this.rollback();
    }

    private <T extends CDOMObject, L extends CDOMList<T>> void commitDirect(CDOMReference<L> list) {
        ListCommitStrategy commit = this.getCommitStrategy();
        for (OwnerURI ou : this.edits.positiveMasterMap.getSecondaryKeySet(list)) {
            for (CDOMObject child : this.edits.positiveMasterMap.getTertiaryKeySet(list, (Object)ou)) {
                AssociatedPrereqObject assoc = (AssociatedPrereqObject)this.edits.positiveMasterMap.get(list, (Object)ou, (Object)child);
                AssociatedPrereqObject edge = commit.addToMasterList(assoc.getAssociation(AssociationKey.TOKEN), ou.owner, list, child);
                Collection<AssociationKey<?>> associationKeys = assoc.getAssociationKeys();
                for (AssociationKey<?> ak : associationKeys) {
                    this.setAssoc(assoc, edge, ak);
                }
                edge.addAllPrerequisites(assoc.getPrerequisiteList());
            }
        }
    }

    private <T extends CDOMObject, U extends CDOMList<T>> void removeDirect(CDOMReference<U> list) {
        ListCommitStrategy commit = this.getCommitStrategy();
        for (OwnerURI ou : this.edits.negativeMasterMap.getSecondaryKeySet(list)) {
            for (CDOMObject child : this.edits.negativeMasterMap.getTertiaryKeySet(list, (Object)ou)) {
                AssociatedPrereqObject assoc = (AssociatedPrereqObject)this.edits.negativeMasterMap.get(list, (Object)ou, (Object)child);
                commit.removeFromMasterList(assoc.getAssociation(AssociationKey.TOKEN), ou.owner, list, child);
            }
        }
    }

    void rollback() {
        this.edits.decommit();
    }

    public Collection<CDOMReference<? extends CDOMList<?>>> getChangedLists(CDOMObject owner, Class<? extends CDOMList<?>> cl) {
        return this.getCommitStrategy().getChangedLists(owner, cl);
    }

    public <T extends CDOMObject> AssociatedChanges<CDOMReference<T>> getChangesInList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<T>> swl) {
        return this.getCommitStrategy().getChangesInList(tokenName, owner, swl);
    }

    public <T extends CDOMObject> AssociatedChanges<T> getChangesInMasterList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<T>> swl) {
        return this.getCommitStrategy().getChangesInMasterList(tokenName, owner, swl);
    }

    public <T extends CDOMList<?>> Changes<CDOMReference<T>> getMasterListChanges(String tokenName, CDOMObject owner, Class<T> cl) {
        return this.getCommitStrategy().getMasterListChanges(tokenName, owner, cl);
    }

    public boolean hasMasterLists() {
        return this.getCommitStrategy().hasMasterLists();
    }

    private <BT extends CDOMObject, L extends CDOMList<BT>> void remove(CDOMObject owner, CDOMObject neg, CDOMReference<L> list) {
        ListCommitStrategy commit = this.getCommitStrategy();
        Collection mods = neg.getListMods(list);
        for (CDOMReference ref : mods) {
            for (AssociatedPrereqObject assoc : neg.getListAssociations(list, ref)) {
                String token = assoc.getAssociation(AssociationKey.TOKEN);
                AssociatedPrereqObject edge = commit.removeFromList(token, owner, list, ref);
                Collection<AssociationKey<?>> associationKeys = assoc.getAssociationKeys();
                for (AssociationKey<?> ak : associationKeys) {
                    this.setAssoc(assoc, edge, ak);
                }
                edge.addAllPrerequisites(assoc.getPrerequisiteList());
            }
        }
    }

    private <BT extends CDOMObject, L extends CDOMList<BT>> void add(CDOMObject owner, CDOMObject neg, CDOMReference<L> list) {
        ListCommitStrategy commit = this.getCommitStrategy();
        Collection mods = neg.getListMods(list);
        for (CDOMReference ref : mods) {
            for (AssociatedPrereqObject assoc : neg.getListAssociations(list, ref)) {
                String token = assoc.getAssociation(AssociationKey.TOKEN);
                AssociatedPrereqObject edge = commit.addToList(token, owner, list, ref);
                Collection<AssociationKey<?>> associationKeys = assoc.getAssociationKeys();
                for (AssociationKey<?> ak : associationKeys) {
                    this.setAssoc(assoc, edge, ak);
                }
                edge.addAllPrerequisites(assoc.getPrerequisiteList());
            }
        }
    }

    private <T> void setAssoc(AssociatedPrereqObject assoc, AssociatedPrereqObject edge, AssociationKey<T> ak) {
        edge.setAssociation(ak, assoc.getAssociation(ak));
    }

    public boolean masterListsEqual(AbstractListContext lc) {
        return this.getCommitStrategy().equalsTracking(lc.getCommitStrategy());
    }

    protected abstract ListCommitStrategy getCommitStrategy();

    <T extends CDOMObject> void cloneInMasterLists(T cdoOld, T cdoNew) {
        MasterListInterface masterLists = Globals.getMasterLists();
        for (CDOMReference<? extends CDOMList<?>> cDOMReference : masterLists.getActiveLists()) {
            Collection<AssociatedPrereqObject> assocs = masterLists.getAssociations(cDOMReference, cdoOld);
            if (assocs == null) continue;
            for (AssociatedPrereqObject apo : assocs) {
                AssociatedPrereqObject newapo = this.getCommitStrategy().addToMasterList(apo.getAssociation(AssociationKey.TOKEN), cdoNew, cDOMReference, cdoNew);
                newapo.addAllPrerequisites(apo.getPrerequisiteList());
                for (AssociationKey<?> assocKey : apo.getAssociationKeys()) {
                    if (assocKey == AssociationKey.TOKEN || assocKey == AssociationKey.OWNER) continue;
                    newapo.setAssociation(assocKey, apo.getAssociation(assocKey));
                }
            }
        }
    }

    private static class OwnerURI {
        public final CDOMObject owner;
        public final URI source;

        public OwnerURI(URI sourceURI, CDOMObject cdo) {
            this.source = sourceURI;
            this.owner = cdo;
        }

        public int hashCode() {
            return this.owner.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof OwnerURI) {
                OwnerURI other = (OwnerURI)o;
                if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                    return false;
                }
                return this.owner.equals(other.owner);
            }
            return false;
        }
    }

    public static class TrackingListCommitStrategy
    implements ListCommitStrategy {
        private final DoubleKeyMap<URI, CDOMObject, CDOMObject> positiveMap = new DoubleKeyMap(HashMap.class, IdentityHashMap.class);
        private final DoubleKeyMap<URI, CDOMObject, CDOMObject> negativeMap = new DoubleKeyMap(HashMap.class, IdentityHashMap.class);
        private final TripleKeyMapToList<URI, CDOMObject, String, CDOMReference<? extends CDOMList<?>>> globalClearSet = new TripleKeyMapToList(HashMap.class, IdentityHashMap.class, HashMap.class);
        private final TripleKeyMap<CDOMReference<? extends CDOMList<?>>, OwnerURI, CDOMObject, AssociatedPrereqObject> positiveMasterMap = new TripleKeyMap();
        private final TripleKeyMap<CDOMReference<? extends CDOMList<?>>, OwnerURI, CDOMObject, AssociatedPrereqObject> negativeMasterMap = new TripleKeyMap();
        private final HashMapToList<CDOMReference<? extends CDOMList<?>>, OwnerURI> masterClearSet = new HashMapToList();
        private final HashMapToList<String, OwnerURI> masterAllClear = new HashMapToList();
        private URI sourceURI;
        private URI extractURI;

        public URI getExtractURI() {
            return this.extractURI;
        }

        @Override
        public void setExtractURI(URI extractURI) {
            this.extractURI = extractURI;
        }

        public URI getSourceURI() {
            return this.sourceURI;
        }

        @Override
        public void setSourceURI(URI sourceURI) {
            this.sourceURI = sourceURI;
        }

        @Override
        public <T extends CDOMObject> AssociatedPrereqObject addToMasterList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<T>> list, T allowed) {
            SimpleAssociatedObject a = new SimpleAssociatedObject();
            a.setAssociation(AssociationKey.OWNER, owner);
            a.setAssociation(AssociationKey.TOKEN, tokenName);
            this.positiveMasterMap.put(list, (Object)new OwnerURI(this.sourceURI, owner), allowed, (Object)a);
            return a;
        }

        @Override
        public <T extends CDOMObject> void removeFromMasterList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<T>> list, T allowed) {
            SimpleAssociatedObject a = new SimpleAssociatedObject();
            a.setAssociation(AssociationKey.OWNER, owner);
            a.setAssociation(AssociationKey.TOKEN, tokenName);
            this.negativeMasterMap.put(list, (Object)new OwnerURI(this.sourceURI, owner), allowed, (Object)a);
        }

        @Override
        public <T extends CDOMList<?>> Changes<CDOMReference<T>> getMasterListChanges(String tokenName, CDOMObject owner, Class<T> cl) {
            OwnerURI lo = new OwnerURI(this.extractURI, owner);
            TreeSet list = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
            Set set = this.positiveMasterMap.getKeySet();
            if (set != null) {
                block0: for (CDOMReference ref : set) {
                    if (!cl.equals(ref.getReferenceClass())) continue;
                    CDOMReference tr = ref;
                    for (CDOMObject allowed : this.positiveMasterMap.getTertiaryKeySet((Object)tr, (Object)lo)) {
                        AssociatedPrereqObject assoc = (AssociatedPrereqObject)this.positiveMasterMap.get((Object)tr, (Object)lo, (Object)allowed);
                        if (!owner.equals(assoc.getAssociation(AssociationKey.OWNER)) || !tokenName.equals(assoc.getAssociation(AssociationKey.TOKEN))) continue;
                        list.add(tr);
                        continue block0;
                    }
                }
            }
            set = this.negativeMasterMap.getKeySet();
            ArrayList<CDOMReference> removelist = new ArrayList<CDOMReference>();
            if (set != null) {
                block2: for (CDOMReference ref : set) {
                    if (!cl.equals(ref.getReferenceClass())) continue;
                    CDOMReference tr = ref;
                    for (CDOMObject allowed : this.negativeMasterMap.getTertiaryKeySet((Object)tr, (Object)lo)) {
                        AssociatedPrereqObject assoc = (AssociatedPrereqObject)this.negativeMasterMap.get((Object)tr, (Object)lo, (Object)allowed);
                        if (!owner.equals(assoc.getAssociation(AssociationKey.OWNER)) || !tokenName.equals(assoc.getAssociation(AssociationKey.TOKEN))) continue;
                        removelist.add(tr);
                        continue block2;
                    }
                }
            }
            return new CollectionChanges<CDOMReference<T>>(list, removelist, this.masterAllClear.containsInList((Object)tokenName, (Object)lo));
        }

        @Override
        public <T extends CDOMObject> AssociatedChanges<T> getChangesInMasterList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<T>> swl) {
            TreeMapToList map = new TreeMapToList(CDOMObjectUtilities.CDOM_SORTER);
            OwnerURI lo = new OwnerURI(this.extractURI, owner);
            Set added = this.positiveMasterMap.getTertiaryKeySet(swl, (Object)lo);
            for (CDOMObject lw : added) {
                AssociatedPrereqObject apo = (AssociatedPrereqObject)this.positiveMasterMap.get(swl, (Object)lo, (Object)lw);
                if (!tokenName.equals(apo.getAssociation(AssociationKey.TOKEN))) continue;
                map.addToListFor((Object)lw, (Object)apo);
            }
            TreeMapToList rmap = new TreeMapToList(CDOMObjectUtilities.CDOM_SORTER);
            Set removed = this.negativeMasterMap.getTertiaryKeySet(swl, (Object)lo);
            for (CDOMObject lw : removed) {
                AssociatedPrereqObject apo = (AssociatedPrereqObject)this.negativeMasterMap.get(swl, (Object)lo, (Object)lw);
                if (!tokenName.equals(apo.getAssociation(AssociationKey.TOKEN))) continue;
                rmap.addToListFor((Object)lw, (Object)apo);
            }
            return new AssociatedCollectionChanges(map, rmap, this.masterClearSet.containsInList(swl, (Object)lo));
        }

        public <T extends CDOMObject> void clearMasterList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<T>> list) {
            this.masterClearSet.addToListFor(list, (Object)new OwnerURI(this.sourceURI, owner));
        }

        @Override
        public void clearAllMasterLists(String tokenName, CDOMObject owner) {
            this.masterAllClear.addToListFor((Object)tokenName, (Object)new OwnerURI(this.sourceURI, owner));
        }

        private CDOMObject getPositive(URI source, CDOMObject cdo) {
            CDOMObject positive = (CDOMObject)this.positiveMap.get((Object)source, (Object)cdo);
            if (positive == null) {
                positive = new CDOMShell();
                this.positiveMap.put((Object)source, (Object)cdo, (Object)positive);
            }
            return positive;
        }

        private CDOMObject getNegative(URI source, CDOMObject cdo) {
            CDOMObject negative = (CDOMObject)this.negativeMap.get((Object)source, (Object)cdo);
            if (negative == null) {
                negative = new CDOMShell();
                this.negativeMap.put((Object)source, (Object)cdo, (Object)negative);
            }
            return negative;
        }

        @Override
        public <T extends CDOMObject> AssociatedPrereqObject addToList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<? super T>> list, CDOMReference<T> allowed) {
            SimpleAssociatedObject a = new SimpleAssociatedObject();
            a.setAssociation(AssociationKey.TOKEN, tokenName);
            this.getPositive(this.sourceURI, owner).putToList(list, allowed, a);
            return a;
        }

        @Override
        public <T extends CDOMObject> AssociatedPrereqObject removeFromList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<? super T>> list, CDOMReference<T> ref) {
            SimpleAssociatedObject a = new SimpleAssociatedObject();
            a.setAssociation(AssociationKey.TOKEN, tokenName);
            this.getNegative(this.sourceURI, owner).putToList(list, ref, a);
            return a;
        }

        @Override
        public Collection<CDOMReference<? extends CDOMList<?>>> getChangedLists(CDOMObject owner, Class<? extends CDOMList<?>> cl) {
            ListSet list = new ListSet();
            for (CDOMReference<CDOMList<?>> ref : this.getPositive(this.extractURI, owner).getModifiedLists()) {
                if (!cl.equals(ref.getReferenceClass())) continue;
                list.add(ref);
            }
            for (CDOMReference<CDOMList<?>> ref : this.getNegative(this.extractURI, owner).getModifiedLists()) {
                if (!cl.equals(ref.getReferenceClass())) continue;
                list.add(ref);
            }
            Set globalClearTokenKeys = this.globalClearSet.getTertiaryKeySet((Object)this.extractURI, (Object)owner);
            for (String key : globalClearTokenKeys) {
                List globalClearList = this.globalClearSet.getListFor((Object)this.extractURI, (Object)owner, (Object)key);
                if (globalClearList == null) continue;
                for (CDOMReference ref : globalClearList) {
                    if (!cl.equals(ref.getReferenceClass())) continue;
                    list.add(ref);
                }
            }
            return list;
        }

        @Override
        public void removeAllFromList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<?>> swl) {
            this.globalClearSet.addToListFor((Object)this.sourceURI, (Object)owner, (Object)tokenName, swl);
        }

        @Override
        public <T extends CDOMObject> AssociatedChanges<CDOMReference<T>> getChangesInList(String tokenName, CDOMObject owner, CDOMReference<? extends CDOMList<T>> swl) {
            boolean hasGlobalClear = this.globalClearSet.containsListFor((Object)this.extractURI, (Object)owner, (Object)tokenName) && this.globalClearSet.getListFor((Object)this.extractURI, (Object)owner, (Object)tokenName).contains(swl);
            return new ListChanges(tokenName, this.getPositive(this.extractURI, owner), this.getNegative(this.extractURI, owner), swl, hasGlobalClear);
        }

        @Override
        public boolean hasMasterLists() {
            return !this.positiveMasterMap.isEmpty() && !this.masterClearSet.isEmpty() && !this.masterAllClear.isEmpty();
        }

        public void decommit() {
            this.masterAllClear.clear();
            this.masterClearSet.clear();
            this.positiveMasterMap.clear();
            this.negativeMasterMap.clear();
            this.positiveMap.clear();
            this.negativeMap.clear();
            this.globalClearSet.clear();
        }

        @Override
        public boolean equalsTracking(ListCommitStrategy obj) {
            if (obj instanceof TrackingListCommitStrategy) {
                TrackingListCommitStrategy other = (TrackingListCommitStrategy)obj;
                return other.masterAllClear.equals(this.masterAllClear) && other.masterClearSet.equals(this.masterClearSet) && other.positiveMasterMap.equals(this.positiveMasterMap) && other.negativeMasterMap.equals(this.negativeMasterMap);
            }
            return false;
        }

        public void purge(CDOMObject cdo) {
            this.positiveMap.remove((Object)this.sourceURI, (Object)cdo);
            this.negativeMap.remove((Object)this.sourceURI, (Object)cdo);
            this.globalClearSet.removeListsFor((Object)this.sourceURI, (Object)cdo);
        }

        protected static class CDOMShell
        extends CDOMObject {
            protected CDOMShell() {
            }

            @Override
            public CDOMObject clone() throws CloneNotSupportedException {
                throw new CloneNotSupportedException();
            }

            @Override
            public boolean isType(String str) {
                return false;
            }
        }
    }
}

