/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.prereq;

import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.rules.persistence.token.ParseResult;

public abstract class AbstractPrerequisiteParser
implements PrerequisiteParserInterface {
    @Override
    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        boolean foundTag = false;
        for (int i = 0; i < this.kindsHandled().length; ++i) {
            String arrayElement = this.kindsHandled()[i];
            if (!arrayElement.equalsIgnoreCase(kind)) continue;
            foundTag = true;
            break;
        }
        if (!foundTag) {
            throw new PersistenceLayerException(this.getClass().getName() + " can not parse a Prerequisite tag of '" + kind + ":" + formula + "'");
        }
        Prerequisite prereq = new Prerequisite();
        prereq.setKind(kind);
        prereq.setOverrideQualify(overrideQualify);
        return prereq;
    }

    protected ParseResult checkForIllegalSeparator(String kind, char separator, String value) {
        if (value.charAt(0) == separator) {
            return new ParseResult.Fail("PRE" + kind + " arguments may not start with " + separator + " : " + value);
        }
        if (value.charAt(value.length() - 1) == separator) {
            return new ParseResult.Fail("PRE" + kind + " arguments may not end with " + separator + " : " + value);
        }
        if (value.indexOf(String.valueOf(new char[]{separator, separator})) != -1) {
            return new ParseResult.Fail("PRE" + kind + " arguments uses double separator " + separator + separator + " : " + value);
        }
        return ParseResult.SUCCESS;
    }
}

