/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.filters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import pcgen.core.utils.CoreUtility;
import pcgen.io.filters.OutputFilter;
import pcgen.system.ConfigurationSettings;
import pcgen.util.Logging;

public class PatternFilter
implements OutputFilter {
    private String outputFilterName = "";
    private List<String> match = null;
    private List<String> replace = null;

    public PatternFilter(String templateFileName) throws IOException {
        int idx = templateFileName.lastIndexOf(46);
        if (idx < 0) {
            idx = templateFileName.lastIndexOf(45);
        }
        String filterName = templateFileName;
        if (idx >= 0) {
            filterName = filterName.substring(idx + 1);
        }
        if ((filterName = filterName.toLowerCase()).equals(this.outputFilterName)) {
            return;
        }
        filterName = new File(ConfigurationSettings.getSystemsDir()) + File.separator + "outputFilters" + File.separator + "re" + filterName + ".lst";
        File filterFile = new File(filterName);
        if (filterFile.canRead() && filterFile.isFile()) {
            String aLine;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filterFile), "UTF-8"));
            this.outputFilterName = filterName;
            this.match = new ArrayList<String>();
            this.replace = new ArrayList<String>();
            while ((aLine = br.readLine()) != null) {
                if (aLine.length() == 0 || aLine.charAt(0) == '#') continue;
                String aLineWOComment = 0 < aLine.indexOf("\t#") ? aLine.substring(0, aLine.indexOf("\t#")) : aLine;
                List<String> filterEntry = CoreUtility.split(aLineWOComment, '\t');
                try {
                    if (filterEntry.size() == 2) {
                        this.match.add(filterEntry.get(0));
                        this.replace.add(filterEntry.get(1).replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t"));
                        continue;
                    }
                    if (filterEntry.size() == 1) {
                        this.match.add(filterEntry.get(0));
                        this.replace.add("");
                        continue;
                    }
                    Logging.errorPrint("Incorrect line format in PatternFilter: Line ignored");
                }
                catch (NullPointerException e) {
                    Logging.errorPrint("Exception in setCurrentOutputFilter", e);
                }
                catch (NumberFormatException e) {
                    Logging.errorPrint("Exception in setCurrentOutputFilter", e);
                }
            }
            br.close();
        }
    }

    @Override
    public String filterString(String aString) {
        String aProcessedString = aString;
        if (this.match != null && !this.match.isEmpty() && aString != null) {
            for (int i = 0; i < this.match.size(); ++i) {
                aProcessedString = aProcessedString.replaceAll(this.match.get(i), this.replace.get(i));
            }
        }
        return aProcessedString;
    }
}

