/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.plaf.TabbedPaneUI;
import pcgen.gui2.tools.Utilities;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class SpinningTabbedPane
extends JTabbedPane {
    static final long serialVersionUID = 4980035692406423131L;
    private static final int PLACE_OFFSET = 0;
    private static final int MOVE_LEFT_RIGHT_OFFSET = 4;
    private static final int MOVE_UP_DOWN_OFFSET = 8;
    private static final int GROUP_OFFSET = 12;
    private static final int TAB_OFFSET = 16;
    private static final int UNGROUP_CHILD_OFFSET = 20;
    private static final int UNGROUP_SELF_OFFSET = 24;
    private static final int UNGROUP_SINGLE_OFFSET = 28;
    private static final String[] labels = new String[]{LanguageBundle.getString("in_top"), LanguageBundle.getString("in_left"), LanguageBundle.getString("in_bottom"), LanguageBundle.getString("in_right"), LanguageBundle.getString("in_beginning"), LanguageBundle.getString("in_left"), LanguageBundle.getString("in_end"), LanguageBundle.getString("in_right"), LanguageBundle.getString("in_top"), LanguageBundle.getString("in_up"), LanguageBundle.getString("in_bottom"), LanguageBundle.getString("in_down"), LanguageBundle.getString("in_up"), LanguageBundle.getString("in_left"), LanguageBundle.getString("in_down"), LanguageBundle.getString("in_right"), null, null, null, null, LanguageBundle.getString("in_ungroupTop"), LanguageBundle.getString("in_ungroupLeft"), LanguageBundle.getString("in_ungroupBottom"), LanguageBundle.getString("in_ungroupRight"), LanguageBundle.getString("in_ungroupTop"), LanguageBundle.getString("in_ungroupLeft"), LanguageBundle.getString("in_ungroupBottom"), LanguageBundle.getString("in_ungroupRight"), LanguageBundle.getString("in_ungroupUp"), LanguageBundle.getString("in_ungroupLeft"), LanguageBundle.getString("in_ungroupDown"), LanguageBundle.getString("in_ungroupRight")};
    private static final ImageIcon[] icons = new ImageIcon[]{Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON, Utilities.BEGINNING_ICON, Utilities.LEFT_ICON, Utilities.END_ICON, Utilities.RIGHT_ICON, Utilities.TOP_ICON, Utilities.UP_ICON, Utilities.BOTTOM_ICON, Utilities.DOWN_ICON, Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON, Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON, Utilities.TOP_ICON, Utilities.BEGINNING_ICON, Utilities.BOTTOM_ICON, Utilities.END_ICON, Utilities.TOP_ICON, Utilities.BEGINNING_ICON, Utilities.BOTTOM_ICON, Utilities.END_ICON, Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON};
    private static final String[] tips = new String[]{LanguageBundle.getString("in_spinTips1"), LanguageBundle.getString("in_spinTips2"), LanguageBundle.getString("in_spinTips3"), LanguageBundle.getString("in_spinTips4"), LanguageBundle.getString("in_spinTips5"), LanguageBundle.getString("in_spinTips6"), LanguageBundle.getString("in_spinTips7"), LanguageBundle.getString("in_spinTips8"), LanguageBundle.getString("in_spinTips9"), LanguageBundle.getString("in_spinTips10"), LanguageBundle.getString("in_spinTips11"), LanguageBundle.getString("in_spinTips12"), LanguageBundle.getString("in_spinTips13"), LanguageBundle.getString("in_spinTips14"), LanguageBundle.getString("in_spinTips15"), LanguageBundle.getString("in_spinTips16"), LanguageBundle.getString("in_spinTips17"), LanguageBundle.getString("in_spinTips18"), LanguageBundle.getString("in_spinTips19"), LanguageBundle.getString("in_spinTips20"), LanguageBundle.getString("in_spinTips21"), LanguageBundle.getString("in_spinTips22"), LanguageBundle.getString("in_spinTips23"), LanguageBundle.getString("in_spinTips24"), LanguageBundle.getString("in_spinTips25"), LanguageBundle.getString("in_spinTips26"), LanguageBundle.getString("in_spinTips27"), LanguageBundle.getString("in_spinTips28"), LanguageBundle.getString("in_spinTips29"), LanguageBundle.getString("in_spinTips30"), LanguageBundle.getString("in_spinTips31"), LanguageBundle.getString("in_spinTips32")};
    private PopupMenuPolicy policy = new DefaultPopupMenuPolicy();
    private Set<Component> locked = new HashSet<Component>();
    private SpinningTabbedPane parent = null;

    public SpinningTabbedPane() {
        this.addMouseListener(new PopupListener());
    }

    @Override
    public final void setTabPlacement(int placement) {
        super.setTabPlacement(placement);
        if (this.parent != null) {
            this.parent.updateTabUIAt(this.parent.indexOfComponent(this));
        }
    }

    @Override
    public final void setTitleAt(int index, String title) {
        String extra = this.getExtraTitleAt(index);
        if (extra != null) {
            title = title == null || title.length() == 0 ? extra : title + " " + extra;
        }
        super.setTitleAt(index, title);
    }

    @Override
    public final int indexAtLocation(int x, int y) {
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).tabForCoordinate(this, x, y);
        }
        return -1;
    }

    private static void setMenuItem(JMenuItem menuItem, int offset) {
        String label = labels[offset];
        menuItem.setText(label);
        if (label != null) {
            menuItem.setMnemonic(label.charAt(0));
        }
        menuItem.setIcon(icons[offset]);
        menuItem.setToolTipText(tips[offset]);
    }

    private static final SpinningTabbedPane createPane() {
        return new SpinningTabbedPane();
    }

    private static int offsetForPlacement(int placement) {
        return placement - 1;
    }

    private static int placementForSlot(int slot, int placement) {
        return (placement - 1 + slot) % 4 + 1;
    }

    private final String getExtraTitleAt(int index) {
        Component c = this.getComponentAt(index);
        return c instanceof SpinningTabbedPane ? "(" + ((SpinningTabbedPane)c).getSpinTabCount() + ")" : null;
    }

    private final int getMovableTabCount() {
        int n = 0;
        int x = this.getTabCount();
        for (int i = 0; i < x; ++i) {
            if (!this.policy.canMove(i) || this.isTabLockedAt(i)) continue;
            ++n;
        }
        return n;
    }

    private final int[] getMovableTabIndices() {
        int x = this.getTabCount();
        int[] list1 = new int[x];
        int n = 0;
        for (int i = 0; i < x; ++i) {
            if (!this.policy.canMove(i) || this.isTabLockedAt(i)) continue;
            list1[n++] = i;
        }
        int[] list2 = new int[n];
        for (int i = 0; i < n; ++i) {
            list2[i] = list1[i];
        }
        return list2;
    }

    private final String getPlainTitleAt(int index) {
        String title = this.getTitleAt(index);
        Component c = this.getComponentAt(index);
        if (title == null) {
            return "";
        }
        if (title.length() == 0 || !(c instanceof SpinningTabbedPane)) {
            return title;
        }
        String extra = this.getExtraTitleAt(index);
        if (title.length() == extra.length()) {
            return "";
        }
        return title.substring(0, title.length() - extra.length() - 1);
    }

    private final int getSpinTabCount() {
        int n = this.getTabCount();
        int x = n;
        for (int i = 0; i < x; ++i) {
            Component c = this.getComponentAt(i);
            if (!(c instanceof SpinningTabbedPane)) continue;
            --n;
            n += ((SpinningTabbedPane)c).getSpinTabCount();
        }
        return n;
    }

    private final int getSpinTabPlacementAt(int index) {
        Component c = this.getComponentAt(index);
        if (c instanceof SpinningTabbedPane) {
            return ((SpinningTabbedPane)c).getTabPlacement();
        }
        return -1;
    }

    private final boolean isTabLockedAt(int index) {
        return this.locked.contains(this.getComponentAt(index));
    }

    private final void addNewTab() {
        this.add(new JPanel());
    }

    private final void lockTabAt(int index) {
        this.locked.add(this.getComponentAt(index));
        this.setIconAt(index, Utilities.LOCK_ICON);
    }

    private final void spinTabsAt(int index, int placement) {
        Component c;
        SpinningTabbedPane pane = SpinningTabbedPane.createPane();
        this.moveTabAtTo(index, -1, pane);
        int x = this.getTabCount();
        for (int i = index; i < x && !((c = this.getComponentAt(index)) instanceof SpinningTabbedPane); ++i) {
            this.moveTabAtTo(index, -1, pane);
        }
        this.add((Component)pane, index);
        this.setTitleAt(index, "");
        pane.parent = this;
        pane.setTabPlacement(placement);
        this.updateTabUIAt(index);
    }

    private final void unlockTabAt(int index) {
        this.locked.remove(this.getComponentAt(index));
        this.setIconAt(index, null);
    }

    private final void unspinAll() {
        int parentIndex = this.parent.indexOfComponent(this);
        this.parent.removeTabAt(parentIndex);
        int x = this.getTabCount();
        while (--x >= 0) {
            this.moveTabAtTo(x, parentIndex, this.parent);
        }
        this.parent = null;
    }

    private final void unspinTabAt(int index) {
        if (this.getTabCount() == 1) {
            this.unspinAll();
        } else {
            int parentIndex = this.parent.indexOfComponent(this);
            this.moveTabAtTo(index, parentIndex, this.parent);
            this.parent.updateTabUIAt(parentIndex + 1);
        }
    }

    private void moveTabAtTo(int fromIndex, int toIndex, JTabbedPane to) {
        Component c = this.getComponentAt(fromIndex);
        if (c instanceof SpinningTabbedPane) {
            ((SpinningTabbedPane)c).parent = this;
        }
        Color background = this.getBackgroundAt(fromIndex);
        Icon disabledIcon = this.getDisabledIconAt(fromIndex);
        Color foreground = this.getForegroundAt(fromIndex);
        Icon icon = this.getIconAt(fromIndex);
        String title = this.getTitleAt(fromIndex);
        String tip = this.getToolTipTextAt(fromIndex);
        this.removeTabAt(fromIndex);
        if (toIndex == -1) {
            toIndex = to.getTabCount();
        }
        to.add(c, toIndex);
        to.setBackgroundAt(toIndex, background);
        to.setDisabledIconAt(toIndex, disabledIcon);
        to.setForegroundAt(toIndex, foreground);
        to.setIconAt(toIndex, icon);
        to.setTitleAt(toIndex, title);
        to.setToolTipTextAt(toIndex, tip);
    }

    private void updateTabUIAt(int index) {
        SpinningTabbedPane pane = (SpinningTabbedPane)this.getComponentAt(index);
        int offset = SpinningTabbedPane.offsetForPlacement(pane.getTabPlacement()) + 16;
        this.setTitleAt(index, this.getPlainTitleAt(index));
        this.setIconAt(index, icons[offset]);
        this.setToolTipTextAt(index, tips[offset]);
    }

    private static abstract class IndexedAction
    extends AbstractAction {
        private int index;

        public IndexedAction(int index, int offset) {
            this(index, labels[offset], icons[offset]);
            String label = labels[offset];
            if (label != null) {
                this.putValue("MnemonicKey", label.charAt(0));
            }
            this.putValue("ShortDescription", tips[index]);
        }

        public IndexedAction(int index, String name, ImageIcon icon) {
            super(name, icon);
            this.index = index;
        }

        public IndexedAction(int index, String name, ImageIcon icon, int mnemonic) {
            this(index, name, icon);
            this.putValue("MnemonicKey", mnemonic);
        }

        public int getIndex() {
            return this.index;
        }
    }

    private class UnlockAction
    extends IndexedAction {
        public UnlockAction(int index) {
            super(index, LanguageBundle.getString("in_unlock"), Utilities.LOCK_ICON, LanguageBundle.getMnemonic("in_mn_unlock"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.unlockTabAt(this.getIndex());
        }
    }

    private class UngroupSingleAction
    extends IndexedAction {
        public UngroupSingleAction(int index) {
            super(index, SpinningTabbedPane.offsetForPlacement(SpinningTabbedPane.this.parent.getTabPlacement()) + 28);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.unspinTabAt(this.getIndex());
            SpinningTabbedPane.this.parent.setSelectedIndex(SpinningTabbedPane.this.parent.indexOfComponent(SpinningTabbedPane.this) - 1);
        }
    }

    private class UngroupSelfAction
    extends IndexedAction {
        public UngroupSelfAction() {
            super(0, SpinningTabbedPane.offsetForPlacement(SpinningTabbedPane.this.parent.getTabPlacement()) + 24);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = SpinningTabbedPane.this.parent.indexOfComponent(SpinningTabbedPane.this);
            int newIndex = SpinningTabbedPane.this.getSelectedIndex();
            SpinningTabbedPane aParent = SpinningTabbedPane.this.parent;
            SpinningTabbedPane.this.unspinAll();
            aParent.setSelectedIndex(index + newIndex);
        }
    }

    private class UngroupChildAction
    extends IndexedAction {
        public UngroupChildAction(int index) {
            super(index, SpinningTabbedPane.offsetForPlacement(SpinningTabbedPane.this.getTabPlacement()) + 20);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane pane = (SpinningTabbedPane)SpinningTabbedPane.this.getComponentAt(this.getIndex());
            int newIndex = pane.getSelectedIndex();
            pane.unspinAll();
            SpinningTabbedPane.this.setSelectedIndex(this.getIndex() + newIndex);
        }
    }

    private class RenameTextFieldActionListener
    implements ActionListener {
        private JPopupMenu popupMenu;
        private JTextField textField;
        private int anIndex;

        RenameTextFieldActionListener(int index, JTextField textField, JPopupMenu popupMenu) {
            this.anIndex = index;
            this.textField = textField;
            this.popupMenu = popupMenu;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.setTitleAt(this.anIndex, this.textField.getText());
            this.popupMenu.setVisible(false);
        }
    }

    private class RenameAction
    extends IndexedAction {
        private MouseEvent evt;

        public RenameAction(int index, MouseEvent e) {
            super(index, LanguageBundle.getString("in_rename") + "...", null, LanguageBundle.getMnemonic("in_mn_rename"));
            this.evt = e;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int x = this.evt.getX();
            int y = this.evt.getY();
            JPopupMenu popupMenu = new JPopupMenu();
            String title = SpinningTabbedPane.this.getPlainTitleAt(this.getIndex());
            JTextField textField = new JTextField(title);
            Logging.errorPrint("document? " + textField.getDocument());
            textField.addActionListener(new RenameTextFieldActionListener(this.getIndex(), textField, popupMenu));
            popupMenu.add(textField);
            Component c = this.evt.getComponent();
            popupMenu.show(c, x, y);
            textField.selectAll();
            textField.setCaretPosition(title.length());
            Component pane = SpinningTabbedPane.this.getComponentAt(this.getIndex());
            Point paneLocation = pane.getLocationOnScreen();
            Point popupLocation = popupMenu.getLocationOnScreen();
            Dimension paneSize = pane.getSize();
            Dimension popupSize = popupMenu.getSize();
            boolean reshow = false;
            if (popupLocation.x + popupSize.width >= paneLocation.x + paneSize.width) {
                reshow = true;
                x = paneLocation.x + paneSize.width - popupSize.width - 1;
            }
            if (popupLocation.y + popupSize.height >= paneLocation.y + paneSize.height) {
                reshow = true;
                y = paneLocation.y + paneSize.height - popupSize.height - 1;
            }
            if (reshow) {
                popupMenu.show(c, x, y);
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (Utilities.isRightMouseButton(e)) {
                boolean usePlaceMenu;
                int x = e.getX();
                int y = e.getY();
                int index = SpinningTabbedPane.this.indexAtLocation(x, y);
                int aTabPlacement = SpinningTabbedPane.this.getTabPlacement();
                JPopupMenu popupMenu = new JPopupMenu();
                JMenuItem newMenuItem = null;
                JMenuItem closeMenuItem = null;
                JMenuItem lockMenuItem = null;
                JMenuItem renameMenuItem = null;
                JMenu groupMenu = null;
                JMenu moveMenu = null;
                PlaceMenu placeMenu = null;
                if (SpinningTabbedPane.this.policy.canNew(index)) {
                    newMenuItem = new JMenuItem(new NewAction());
                }
                if (index >= 0) {
                    int spinTabPlacement = SpinningTabbedPane.this.getSpinTabPlacementAt(index);
                    if (SpinningTabbedPane.this.policy.canClose(index) && !SpinningTabbedPane.this.isTabLockedAt(index)) {
                        closeMenuItem = new JMenuItem(new CloseAction(index));
                    }
                    if (SpinningTabbedPane.this.policy.canLock(index)) {
                        JMenuItem jMenuItem = lockMenuItem = SpinningTabbedPane.this.isTabLockedAt(index) ? new JMenuItem(new UnlockAction(index)) : new JMenuItem(new LockAction(index));
                    }
                    if (SpinningTabbedPane.this.policy.canRename(index)) {
                        renameMenuItem = new JMenuItem(new RenameAction(index, e));
                    }
                    if (SpinningTabbedPane.this.policy.hasGroupMenu(index, e) && !SpinningTabbedPane.this.isTabLockedAt(index)) {
                        groupMenu = new GroupMenu(index, spinTabPlacement == -1 ? aTabPlacement : spinTabPlacement);
                    }
                    if (SpinningTabbedPane.this.policy.hasMoveMenu(index, e) && SpinningTabbedPane.this.getMovableTabCount() > 1 && !SpinningTabbedPane.this.isTabLockedAt(index)) {
                        moveMenu = new MoveMenu(index);
                    }
                }
                if (SpinningTabbedPane.this.policy.hasPlaceMenu(index, e)) {
                    placeMenu = new PlaceMenu(aTabPlacement);
                }
                boolean useNewMenuItem = newMenuItem != null;
                boolean useCloseMenuItem = closeMenuItem != null;
                boolean useLockMenuItem = lockMenuItem != null;
                boolean useRenameMenuItem = renameMenuItem != null;
                boolean useGroupMenu = groupMenu != null && groupMenu.getMenuComponentCount() > 0;
                boolean useMoveMenu = moveMenu != null && moveMenu.getMenuComponentCount() > 0;
                boolean bl = usePlaceMenu = placeMenu != null && placeMenu.getMenuComponentCount() > 0;
                if (popupMenu.getComponentCount() > 0 && (useNewMenuItem || useCloseMenuItem)) {
                    popupMenu.addSeparator();
                }
                if (useNewMenuItem) {
                    popupMenu.add(newMenuItem);
                }
                if (useCloseMenuItem) {
                    popupMenu.add(closeMenuItem);
                }
                if (popupMenu.getComponentCount() > 0 && (useLockMenuItem || useRenameMenuItem)) {
                    popupMenu.addSeparator();
                }
                if (useLockMenuItem) {
                    popupMenu.add(lockMenuItem);
                }
                if (useRenameMenuItem) {
                    popupMenu.add(renameMenuItem);
                }
                if (popupMenu.getComponentCount() > 0 && (useGroupMenu || useMoveMenu || usePlaceMenu)) {
                    popupMenu.addSeparator();
                }
                if (useGroupMenu) {
                    popupMenu.add(groupMenu);
                }
                if (useMoveMenu) {
                    popupMenu.add(moveMenu);
                }
                if (usePlaceMenu) {
                    popupMenu.add(placeMenu);
                }
                popupMenu.show(e.getComponent(), x, y);
            } else if (Utilities.isShiftLeftMouseButton(e)) {
                int index = SpinningTabbedPane.this.indexAtLocation(e.getX(), e.getY());
                SpinningTabbedPane.this.spinTabsAt(index, SpinningTabbedPane.placementForSlot(3, SpinningTabbedPane.this.getTabPlacement()));
                SpinningTabbedPane.this.setSelectedIndex(index);
            }
        }
    }

    private class PlaceAction
    extends IndexedAction {
        private SpinningTabbedPane pane;
        private int placement;

        public PlaceAction(SpinningTabbedPane pane, int placement) {
            super(0, SpinningTabbedPane.offsetForPlacement(placement) + 0);
            this.pane = pane;
            this.placement = placement;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.pane.setTabPlacement(this.placement);
        }
    }

    private class PlaceMenu
    extends JMenu {
        PlaceMenu(int placement) {
            super(LanguageBundle.getString("in_placeTabs"));
            this.setMnemonic(LanguageBundle.getMnemonic("in_mn_placeTabs"));
            for (int j = 3; j > 0; --j) {
                this.add(new JMenuItem(new PlaceAction(SpinningTabbedPane.this, SpinningTabbedPane.placementForSlot(j, placement))));
            }
        }
    }

    private class NewAction
    extends IndexedAction {
        public NewAction() {
            super(0, LanguageBundle.getString("in_new"), Utilities.NEW_ICON, LanguageBundle.getMnemonic("in_mn_new"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.addNewTab();
        }
    }

    private class MoveTabMenuItem
    extends JMenuItem {
        MoveTabMenuItem(int index, int placement) {
            int offset = SpinningTabbedPane.offsetForPlacement(placement);
            switch (SpinningTabbedPane.this.getTabPlacement()) {
                case 1: 
                case 3: {
                    offset += 4;
                    break;
                }
                case 2: 
                case 4: {
                    offset += 8;
                }
            }
            this.addActionListener(new MoveActionListener(index, placement));
            SpinningTabbedPane.setMenuItem(this, offset);
        }
    }

    private class MoveMenu
    extends JMenu {
        MoveMenu(int index) {
            super(LanguageBundle.getString("in_moveTab"));
            this.setMnemonic(LanguageBundle.getMnemonic("in_mn_moveTab"));
            int[] indices = SpinningTabbedPane.this.getMovableTabIndices();
            int primum = -1;
            int secundum = -1;
            int penultimatum = -1;
            int ultimatum = -1;
            switch (indices.length) {
                case 0: {
                    this.setEnabled(false);
                    break;
                }
                case 1: {
                    this.setEnabled(false);
                    break;
                }
                case 2: {
                    primum = indices[0];
                    secundum = Integer.MAX_VALUE;
                    penultimatum = Integer.MIN_VALUE;
                    ultimatum = indices[1];
                    break;
                }
                case 3: {
                    primum = indices[0];
                    secundum = penultimatum = indices[1];
                    ultimatum = indices[2];
                }
                default: {
                    primum = indices[0];
                    secundum = indices[1];
                    penultimatum = indices[indices.length - 2];
                    ultimatum = indices[indices.length - 1];
                }
            }
            for (int i = 0; i < indices.length; ++i) {
                if (index < indices[i]) continue;
                if (index > primum) {
                    if (index > secundum) {
                        this.add(new MoveTabMenuItem(index, 1));
                    }
                    this.add(new MoveTabMenuItem(index, 2));
                }
                if (index >= ultimatum) break;
                this.add(new MoveTabMenuItem(index, 4));
                if (index >= penultimatum) break;
                this.add(new MoveTabMenuItem(index, 3));
                break;
            }
        }
    }

    private class MoveActionListener
    implements ActionListener {
        int index;
        int placement;

        MoveActionListener(int index, int placement) {
            this.index = index;
            this.placement = placement;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] indices = SpinningTabbedPane.this.getMovableTabIndices();
            int i = -1;
            switch (this.placement) {
                case 1: {
                    i = indices[0];
                    break;
                }
                case 2: {
                    i = this.previous(this.index, indices);
                    break;
                }
                case 3: {
                    i = indices[indices.length - 1];
                    break;
                }
                case 4: {
                    i = this.next(this.index, indices);
                }
            }
            SpinningTabbedPane.this.moveTabAtTo(this.index, i, SpinningTabbedPane.this);
            SpinningTabbedPane.this.setSelectedIndex(i);
        }

        private int next(int current, int[] indices) {
            int x = indices.length - 1;
            for (int i = 0; i < x; ++i) {
                if (current != indices[i]) continue;
                return indices[i + 1];
            }
            return -1;
        }

        private int previous(int current, int[] indices) {
            for (int i = 1; i < indices.length; ++i) {
                if (current != indices[i]) continue;
                return indices[i - 1];
            }
            return -1;
        }
    }

    private class LockAction
    extends IndexedAction {
        public LockAction(int index) {
            super(index, LanguageBundle.getString("in_lock"), Utilities.LOCK_ICON, LanguageBundle.getMnemonic("in_mn_lock"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.lockTabAt(this.getIndex());
        }
    }

    private class GroupAction
    extends IndexedAction {
        private int placement;

        public GroupAction(int index, int placement) {
            super(index, SpinningTabbedPane.offsetForPlacement(placement) + 12);
            this.placement = placement;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.spinTabsAt(this.getIndex(), this.placement);
            SpinningTabbedPane.this.setSelectedIndex(this.getIndex());
        }
    }

    private class GroupMenu
    extends JMenu {
        GroupMenu(int index, int placement) {
            int j;
            super(LanguageBundle.getString("in_groupTabs"));
            this.setMnemonic(LanguageBundle.getMnemonic("in_mn_groupTabs"));
            Component c = SpinningTabbedPane.this.getComponentAt(index);
            boolean first = true;
            if (SpinningTabbedPane.this.parent == null) {
                if (c instanceof SpinningTabbedPane) {
                    this.add(new JMenuItem(new UngroupChildAction(index)));
                    this.addSeparator();
                    for (j = 3; j > 0; --j) {
                        this.add(new JMenuItem(new PlaceAction((SpinningTabbedPane)c, SpinningTabbedPane.placementForSlot(j, placement))));
                    }
                    first = false;
                }
            } else {
                this.add(new JMenuItem(new UngroupSelfAction()));
                if (c instanceof SpinningTabbedPane) {
                    this.add(new JMenuItem(new UngroupChildAction(index)));
                } else {
                    this.add(new JMenuItem(new UngroupSingleAction(index)));
                }
                first = false;
            }
            if (SpinningTabbedPane.this.policy.canGroup(index)) {
                if (!first) {
                    this.addSeparator();
                }
                for (j = 4; j > 0; --j) {
                    this.add(new JMenuItem(new GroupAction(index, SpinningTabbedPane.placementForSlot(j, placement))));
                }
            }
        }
    }

    private class CloseAction
    extends IndexedAction {
        public CloseAction(int index) {
            super(index, LanguageBundle.getString("in_close"), Utilities.CLOSE_ICON, LanguageBundle.getMnemonic("in_mn_close"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.removeTabAt(this.getIndex());
        }
    }

    private final class DefaultPopupMenuPolicy
    implements PopupMenuPolicy {
        private DefaultPopupMenuPolicy() {
        }

        @Override
        public boolean canClose(int index) {
            return true;
        }

        @Override
        public boolean canGroup(int index) {
            return true;
        }

        @Override
        public boolean canLock(int index) {
            return true;
        }

        @Override
        public boolean canMove(int index) {
            return true;
        }

        @Override
        public boolean canNew(int index) {
            return true;
        }

        @Override
        public boolean canRename(int index) {
            return true;
        }

        @Override
        public boolean hasGroupMenu(int index, MouseEvent e) {
            return true;
        }

        @Override
        public boolean hasMoveMenu(int index, MouseEvent e) {
            return true;
        }

        @Override
        public boolean hasPlaceMenu(int index, MouseEvent e) {
            return true;
        }
    }

    public static interface PopupMenuPolicy {
        public boolean canClose(int var1);

        public boolean canGroup(int var1);

        public boolean canLock(int var1);

        public boolean canMove(int var1);

        public boolean canNew(int var1);

        public boolean canRename(int var1);

        public boolean hasGroupMenu(int var1, MouseEvent var2);

        public boolean hasMoveMenu(int var1, MouseEvent var2);

        public boolean hasPlaceMenu(int var1, MouseEvent var2);
    }
}

