/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.bio;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.ChronicleEntryFacade;
import pcgen.facade.core.DescriptionFacade;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.models.TextFieldListener;
import pcgen.gui2.tools.Icons;

public class CampaignHistoryInfoPane
extends JPanel
implements CharacterInfoTab {
    private static final String ADD_COMMAND = "ADD";
    private static final String ALL_COMMAND = "ALL";
    private static final String NONE_COMMAND = "NONE";
    private final TabTitle title = new TabTitle("Campaign History", null);
    private final JPanel chroniclesPane;
    private final JButton addButton = new JButton();
    private final JButton allButton = new JButton();
    private final JButton noneButton = new JButton();

    public CampaignHistoryInfoPane() {
        this.chroniclesPane = new ChroniclesPane();
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.addButton.setText("Add Next Chronicle");
        this.addButton.setActionCommand(ADD_COMMAND);
        this.allButton.setText("All");
        this.allButton.setActionCommand(ALL_COMMAND);
        this.noneButton.setText("None");
        this.noneButton.setActionCommand(NONE_COMMAND);
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createRigidArea(new Dimension(5, 0)));
        hbox.add(new JLabel("Check an item to include on your Character Sheet"));
        hbox.add(Box.createRigidArea(new Dimension(5, 0)));
        hbox.add(this.allButton);
        hbox.add(Box.createRigidArea(new Dimension(3, 0)));
        hbox.add(this.noneButton);
        hbox.add(Box.createHorizontalGlue());
        this.add(Box.createVerticalStrut(5));
        this.add(hbox);
        this.add(Box.createVerticalStrut(10));
        JScrollPane pane = new JScrollPane(this.chroniclesPane){

            @Override
            public Dimension getMaximumSize() {
                Dimension size = this.getPreferredSize();
                size.width = Integer.MAX_VALUE;
                return size;
            }

            @Override
            public boolean isValidateRoot() {
                return false;
            }
        };
        pane.setHorizontalScrollBarPolicy(31);
        pane.setVerticalScrollBarPolicy(22);
        this.add(pane);
        this.add(Box.createVerticalStrut(10));
        this.addButton.setAlignmentX(0.5f);
        this.add(this.addButton);
        this.add(Box.createVerticalStrut(5));
        this.add(Box.createVerticalGlue());
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(ChronicleHandler.class, new ChronicleHandler(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(ChronicleHandler.class).install();
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(ChronicleHandler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.title;
    }

    private static class ChroniclesPane
    extends JPanel
    implements Scrollable {
        private ChroniclePane dummyPane = new ChroniclePane();

        public ChroniclesPane() {
            this.setLayout(new BoxLayout(this, 1));
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 100;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.dummyPane.getPreferredSize().height + 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private static class ChroniclePane
    extends JPanel
    implements ActionListener {
        private JCheckBox checkBox = new JCheckBox();
        private JButton deleteButton = new JButton();
        private JTextField campaignField = new JTextField();
        private JTextField adventureField = new JTextField();
        private JTextField partyField = new JTextField();
        private JTextField dateField = new JTextField();
        private JFormattedTextField xpField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        private JTextField gmField = new JTextField();
        private JTextArea textArea = new JTextArea(){

            @Override
            public Dimension getMinimumSize() {
                Dimension minSize = super.getMinimumSize();
                Dimension prefSize = this.getPreferredSize();
                minSize.height = prefSize.height;
                return minSize;
            }
        };
        private ChronicleHandler handler;
        private ChronicleEntryFacade entry;

        public ChroniclePane() {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(2, 0, 5, 5));
            this.initComponents();
        }

        public ChroniclePane(ChronicleHandler handler, ChronicleEntryFacade entry) {
            this();
            this.handler = handler;
            this.entry = entry;
            this.populateComponents();
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setRows(5);
            this.partyField.setColumns(10);
            this.dateField.setColumns(6);
            this.xpField.setColumns(6);
            this.gmField.setColumns(10);
            this.deleteButton.setMinimumSize(new Dimension(20, 20));
            this.deleteButton.setPreferredSize(new Dimension(20, 20));
            this.deleteButton.setFocusable(false);
            this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
            this.deleteButton.setIcon(Icons.CloseX9.getImageIcon());
            this.deleteButton.addActionListener(this);
        }

        public void setSelected(boolean select) {
            this.checkBox.setSelected(select);
            this.entry.setOutputEntry(select);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int ret;
            if (this.fieldsNotBlank() && (ret = JOptionPane.showConfirmDialog(this, "<html>This chronicle has been written in.<br>Are you sure you want to delete it?</html>", "PCGen", 0)) != 0) {
                return;
            }
            this.handler.deleteChroniclePane(this, this.entry);
        }

        private boolean fieldsNotBlank() {
            return StringUtils.isNotBlank(this.campaignField.getText()) || StringUtils.isNotBlank(this.adventureField.getText()) || StringUtils.isNotBlank(this.adventureField.getText()) || StringUtils.isNotBlank(this.partyField.getText()) || StringUtils.isNotBlank(this.dateField.getText()) || !NumberUtils.INTEGER_ZERO.equals(this.xpField.getValue()) || StringUtils.isNotBlank(this.gmField.getText()) || StringUtils.isNotBlank(this.textArea.getText());
        }

        private void initComponents() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 4, 0, 0);
            gbc.gridheight = 1;
            gbc.anchor = 256;
            this.add((Component)this.checkBox, gbc);
            gbc.anchor = 13;
            gbc.insets = new Insets(0, 10, 0, 0);
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.fill = 2;
            gbc2.gridwidth = 3;
            gbc2.insets = new Insets(1, 4, 1, 0);
            this.add((Component)new JLabel("Campaign:"), gbc);
            this.add((Component)this.campaignField, gbc2);
            this.add((Component)new JLabel("Adventure:"), gbc);
            gbc2.gridwidth = 0;
            this.add((Component)this.adventureField, gbc2);
            this.add((Component)new JLabel(), gbc);
            this.add((Component)new JLabel("Party Name:"), gbc);
            gbc2.gridwidth = 1;
            gbc2.weightx = 0.35;
            this.add((Component)this.partyField, gbc2);
            this.add((Component)new JLabel("Date:"), gbc);
            gbc2.weightx = 0.15;
            this.add((Component)this.dateField, gbc2);
            this.add((Component)new JLabel("XP Gained:"), gbc);
            gbc2.weightx = 0.05;
            this.add((Component)this.xpField, gbc2);
            this.add((Component)new JLabel("GM:"), gbc);
            gbc2.gridwidth = 0;
            gbc2.weightx = 0.45;
            this.add((Component)this.gmField, gbc2);
            gbc.fill = 3;
            gbc.insets = new Insets(0, 0, 2, 0);
            this.add((Component)this.deleteButton, gbc);
            gbc.gridwidth = 0;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 10, 0, 0);
            this.add((Component)this.textArea, gbc);
        }

        private void populateComponents() {
            this.checkBox.setSelected(this.entry.isOutputEntry());
            this.campaignField.setText(this.entry.getCampaign());
            this.adventureField.setText(this.entry.getAdventure());
            this.partyField.setText(this.entry.getParty());
            this.dateField.setText(this.entry.getDate());
            this.xpField.setValue(this.entry.getXpField());
            this.gmField.setText(this.entry.getGmField());
            this.textArea.setText(this.entry.getChronicle());
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChroniclePane.this.entry.setOutputEntry(ChroniclePane.this.checkBox.getModel().isSelected());
                }
            };
            this.checkBox.addActionListener(actionListener);
            this.campaignField.getDocument().addDocumentListener(new TextFieldListener(this.campaignField){

                @Override
                protected void textChanged(String text) {
                    ChroniclePane.this.entry.setCampaign(text);
                }
            });
            this.adventureField.getDocument().addDocumentListener(new TextFieldListener(this.adventureField){

                @Override
                protected void textChanged(String text) {
                    ChroniclePane.this.entry.setAdventure(text);
                }
            });
            this.partyField.getDocument().addDocumentListener(new TextFieldListener(this.partyField){

                @Override
                protected void textChanged(String text) {
                    ChroniclePane.this.entry.setParty(text);
                }
            });
            this.dateField.getDocument().addDocumentListener(new TextFieldListener(this.dateField){

                @Override
                protected void textChanged(String text) {
                    ChroniclePane.this.entry.setDate(text);
                }
            });
            this.xpField.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ChroniclePane.this.entry.setXpField(((Number)ChroniclePane.this.xpField.getValue()).intValue());
                }
            });
            this.gmField.getDocument().addDocumentListener(new TextFieldListener(this.gmField){

                @Override
                protected void textChanged(String text) {
                    ChroniclePane.this.entry.setGmField(text);
                }
            });
            this.textArea.getDocument().addDocumentListener(new TextFieldListener(this.textArea){

                @Override
                protected void textChanged(String text) {
                    ChroniclePane.this.entry.setChronicle(text);
                }
            });
        }
    }

    private class ChronicleHandler
    implements ActionListener {
        private final List<ChroniclePane> chronicles;
        private final DescriptionFacade descFacade;

        public ChronicleHandler(CharacterFacade character) {
            this.descFacade = character.getDescriptionFacade();
            this.chronicles = new ArrayList<ChroniclePane>();
            for (ChronicleEntryFacade entry : this.descFacade.getChronicleEntries()) {
                this.chronicles.add(new ChroniclePane(this, entry));
            }
        }

        private ChroniclePane createNewChronicleEntry() {
            ChronicleEntryFacade entry = this.descFacade.createChronicleEntry();
            ChroniclePane pane = new ChroniclePane(this, entry);
            return pane;
        }

        public void install() {
            CampaignHistoryInfoPane.this.addButton.addActionListener(this);
            CampaignHistoryInfoPane.this.allButton.addActionListener(this);
            CampaignHistoryInfoPane.this.noneButton.addActionListener(this);
            CampaignHistoryInfoPane.this.chroniclesPane.removeAll();
            for (ChroniclePane chroniclePane : this.chronicles) {
                SwingUtilities.updateComponentTreeUI(chroniclePane);
                CampaignHistoryInfoPane.this.chroniclesPane.add(chroniclePane);
            }
            this.updateChroniclesPane();
        }

        public void uninstall() {
            CampaignHistoryInfoPane.this.addButton.removeActionListener(this);
            CampaignHistoryInfoPane.this.allButton.removeActionListener(this);
            CampaignHistoryInfoPane.this.noneButton.removeActionListener(this);
        }

        private void updateChroniclesPane() {
            boolean notempty = !this.chronicles.isEmpty();
            CampaignHistoryInfoPane.this.allButton.setEnabled(notempty);
            CampaignHistoryInfoPane.this.noneButton.setEnabled(notempty);
            CampaignHistoryInfoPane.this.chroniclesPane.revalidate();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block3: {
                block4: {
                    block2: {
                        if (!CampaignHistoryInfoPane.ADD_COMMAND.equals(e.getActionCommand())) break block2;
                        ChroniclePane pane = this.createNewChronicleEntry();
                        this.chronicles.add(pane);
                        CampaignHistoryInfoPane.this.chroniclesPane.add(pane);
                        this.updateChroniclesPane();
                        break block3;
                    }
                    if (!CampaignHistoryInfoPane.ALL_COMMAND.equals(e.getActionCommand())) break block4;
                    for (ChroniclePane chroniclePane : this.chronicles) {
                        chroniclePane.setSelected(true);
                    }
                    break block3;
                }
                if (!CampaignHistoryInfoPane.NONE_COMMAND.equals(e.getActionCommand())) break block3;
                for (ChroniclePane chroniclePane : this.chronicles) {
                    chroniclePane.setSelected(false);
                }
            }
        }

        public void deleteChroniclePane(ChroniclePane pane, ChronicleEntryFacade entry) {
            this.descFacade.removeChronicleEntry(entry);
            CampaignHistoryInfoPane.this.chroniclesPane.remove(pane);
            this.chronicles.remove(pane);
            this.updateChroniclesPane();
        }
    }
}

