/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import pcgen.facade.core.SpellBuilderFacade;
import pcgen.gui2.equip.SpellChoicePanel;
import pcgen.gui2.tools.Utility;
import pcgen.system.LanguageBundle;

public class SpellChoiceDialog
extends JDialog
implements ActionListener {
    private SpellChoicePanel spellChoicePanel;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private boolean cancelled;

    public SpellChoiceDialog(JFrame frame, SpellBuilderFacade builder) {
        super((Frame)frame, true);
        this.setTitle(LanguageBundle.getString("in_csdChooseSpell"));
        this.buttonPanel = new JPanel();
        this.okButton = new JButton(LanguageBundle.getString("in_ok"));
        this.okButton.setMnemonic(LanguageBundle.getMnemonic("in_mn_ok"));
        this.cancelButton = new JButton(LanguageBundle.getString("in_cancel"));
        this.cancelButton.setMnemonic(LanguageBundle.getMnemonic("in_mn_cancel"));
        this.spellChoicePanel = new SpellChoicePanel(builder);
        this.setDefaultCloseOperation(1);
        this.initComponents();
        this.pack();
        Utility.resizeDialogToScreen(this);
    }

    private void initComponents() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.spellChoicePanel, "Center");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        Box buttons = Box.createHorizontalBox();
        buttons.add(this.buttonPanel);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(this.okButton);
        buttons.add(Box.createHorizontalStrut(10));
        buttons.add(this.cancelButton);
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)buttons, "South");
        Utility.installEscapeCloseOperation(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cancelled = e.getSource() == this.cancelButton;
        this.setVisible(false);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

