/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.converter.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Campaign;
import pcgen.gui2.converter.panel.ConvertSubPanel;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.FontManipulation;

public class SummaryPanel
extends ConvertSubPanel {
    @Override
    public boolean autoAdvance(CDOMObject pc) {
        return false;
    }

    @Override
    public boolean performAnalysis(CDOMObject pc) {
        this.fireProgressEvent(0);
        return true;
    }

    @Override
    public void setupDisplay(JPanel panel, CDOMObject pc) {
        panel.setLayout(new GridBagLayout());
        JLabel introLabel = new JLabel("Ready to convert.");
        GridBagConstraints gbc = new GridBagConstraints();
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 0.0, 2, 18);
        gbc.insets = new Insets(50, 25, 10, 25);
        panel.add((Component)introLabel, gbc);
        JLabel instructLabel = new JLabel("Press Next to begin converting using the following settings:");
        Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 0.0, 2, 18);
        gbc.insets = new Insets(10, 25, 20, 25);
        panel.add((Component)instructLabel, gbc);
        JLabel[] labels = new JLabel[4];
        JComponent[] values = new JComponent[4];
        labels[0] = new JLabel("Source Folder:");
        labels[1] = new JLabel("Destination Folder:");
        labels[2] = new JLabel("Game mode:");
        labels[3] = new JLabel("Sources:");
        values[0] = new JLabel(pc.get(ObjectKey.DIRECTORY).getAbsolutePath());
        values[1] = new JLabel(pc.get(ObjectKey.WRITE_DIRECTORY).getAbsolutePath());
        values[2] = new JLabel(pc.get(ObjectKey.GAME_MODE).getDisplayName());
        List<Campaign> campaigns = pc.getSafeListFor(ListKey.CAMPAIGN);
        StringBuilder campDisplay = new StringBuilder();
        for (int i = 0; i < campaigns.size(); ++i) {
            campDisplay.append(campaigns.get(i).getDisplayName());
            campDisplay.append("\n");
        }
        JTextArea campText = new JTextArea(campDisplay.toString());
        campText.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(campText);
        values[3] = scrollPane;
        Font plainFont = FontManipulation.plain(panel.getFont());
        for (int i = 0; i < labels.length; ++i) {
            Utility.buildRelativeConstraints(gbc, 1, 1, 0.0, 0.0, 0, 18);
            gbc.insets = new Insets(10, 25, 10, 10);
            panel.add((Component)labels[i], gbc);
            if (i < labels.length - 1) {
                Utility.buildRelativeConstraints(gbc, 0, 1, 1.0, 0.0, 2, 18);
            } else {
                Utility.buildRelativeConstraints(gbc, 0, 0, 1.0, 1.0, 1, 18);
            }
            gbc.insets = new Insets(10, 10, 10, 25);
            panel.add((Component)values[i], gbc);
            values[i].setFont(plainFont);
        }
    }
}

