/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.StringUtils;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.PCGenActionMap;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.tabs.InfoTabbedPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.util.SharedTabPane;
import pcgen.system.CharacterManager;

public final class CharacterTabs
extends SharedTabPane
implements ChangeListener,
ReferenceListener<CharacterFacade>,
ListListener<CharacterFacade> {
    private final PCGenFrame frame;
    private final List<CharacterFacade> characters;
    private final Map<CharacterFacade, TabLabel> listenerMap;
    private final InfoTabbedPane infoTabbedPane;
    private final JPopupMenu popupMenu;

    public CharacterTabs(PCGenFrame frame) {
        this.frame = frame;
        this.characters = new ArrayList<CharacterFacade>();
        this.infoTabbedPane = new InfoTabbedPane();
        this.listenerMap = new HashMap<CharacterFacade, TabLabel>();
        this.popupMenu = new JPopupMenu();
        this.initComponents();
    }

    private void initComponents() {
        CharacterManager.getCharacters().addListListener(this);
        this.frame.getSelectedCharacterRef().addReferenceListener(this);
        this.setTabPlacement(3);
        this.addChangeListener(this);
        this.setSharedComponent(this.infoTabbedPane);
        PCGenActionMap actions = this.frame.getActionMap();
        this.popupMenu.add(actions.get("file.new"));
        this.popupMenu.add(actions.get("file.close"));
        this.popupMenu.add(actions.get("file.save"));
        this.popupMenu.add(actions.get("file.saveas"));
        this.addMouseListener(new PopupListener());
    }

    private void addCharacter(CharacterFacade character) {
        this.characters.add(character);
        TabLabel tabLabel = new TabLabel(character);
        this.addTab(tabLabel);
        this.listenerMap.put(character, tabLabel);
    }

    private void removeCharacter(CharacterFacade character) {
        int index = this.characters.indexOf(character);
        this.characters.remove(index);
        this.removeTabAt(index);
        this.listenerMap.remove(character).removeListeners();
        this.infoTabbedPane.characterRemoved(character);
    }

    @Override
    public void referenceChanged(ReferenceEvent<CharacterFacade> e) {
        this.setSelectedIndex(this.characters.indexOf(e.getNewReference()));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.getSelectedIndex();
        CharacterFacade character = index != -1 ? this.characters.get(index) : null;
        this.frame.setSelectedCharacter(character);
        if (character != null) {
            this.infoTabbedPane.setCharacter(character);
        } else {
            this.infoTabbedPane.clearStateMap();
        }
    }

    @Override
    public void elementAdded(ListEvent<CharacterFacade> e) {
        this.addCharacter(e.getElement());
    }

    @Override
    public void elementRemoved(ListEvent<CharacterFacade> e) {
        this.removeCharacter(e.getElement());
    }

    @Override
    public void elementsChanged(ListEvent<CharacterFacade> e) {
        this.removeAll();
        for (CharacterFacade character : this.characters) {
            this.listenerMap.remove(character).removeListeners();
        }
        this.characters.clear();
        for (CharacterFacade character : (ListFacade)e.getSource()) {
            this.addCharacter(character);
        }
        this.infoTabbedPane.clearStateMap();
    }

    @Override
    public void elementModified(ListEvent<CharacterFacade> e) {
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                CharacterTabs.this.popupMenu.setVisible(true);
                CharacterTabs.this.popupMenu.show(e.getComponent(), e.getX(), e.getY() - CharacterTabs.this.popupMenu.getHeight());
            }
        }
    }

    private class TabLabel
    extends JPanel
    implements ActionListener,
    ReferenceListener<String> {
        private JLabel titleLabel;
        private JButton closeButton;
        private CharacterFacade character;
        private ReferenceFacade<String> tabNameRef;
        private ReferenceFacade<String> nameRef;

        public TabLabel(CharacterFacade character) {
            super(new FlowLayout(1, 5, 2));
            this.character = character;
            this.tabNameRef = character.getTabNameRef();
            this.nameRef = character.getNameRef();
            this.initComponents();
            this.closeButton.addActionListener(this);
            this.tabNameRef.addReferenceListener(this);
            this.nameRef.addReferenceListener(this);
        }

        private void initComponents() {
            this.titleLabel = StringUtils.isNotEmpty(this.tabNameRef.getReference()) ? new JLabel(this.tabNameRef.getReference()) : new JLabel(this.nameRef.getReference());
            this.add(this.titleLabel);
            this.closeButton = new JButton();
            this.closeButton.setMargin(new Insets(0, 0, 0, 0));
            this.closeButton.setBorder(BorderFactory.createEmptyBorder());
            this.closeButton.setFocusable(false);
            this.closeButton.setBorderPainted(false);
            this.closeButton.setContentAreaFilled(false);
            this.closeButton.setRolloverEnabled(true);
            ImageIcon icon = Icons.XButton_Stat.getImageIcon();
            Dimension size = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            Insets insets = this.closeButton.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            this.closeButton.setMinimumSize(size);
            this.closeButton.setPreferredSize(size);
            this.closeButton.setMaximumSize(size);
            this.closeButton.setIcon(icon);
            this.closeButton.setRolloverIcon(Icons.XButton_Roll.getImageIcon());
            this.closeButton.setPressedIcon(Icons.XButton_Click.getImageIcon());
            this.add(this.closeButton);
            this.setOpaque(false);
        }

        public void removeListeners() {
            this.tabNameRef.removeReferenceListener(this);
            this.nameRef.removeReferenceListener(this);
        }

        @Override
        public void referenceChanged(ReferenceEvent<String> e) {
            if (e.getSource() == this.nameRef) {
                if (StringUtils.isEmpty(this.tabNameRef.getReference())) {
                    this.titleLabel.setText(e.getNewReference());
                }
            } else if (StringUtils.isNotEmpty(e.getNewReference())) {
                this.titleLabel.setText(e.getNewReference());
            } else {
                this.titleLabel.setText(this.nameRef.getReference());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CharacterTabs.this.frame.closeCharacter(this.character);
        }
    }
}

