/*
 * Decompiled with CFR 0.152.
 */
package pcgen.facade.util;

import javax.swing.event.EventListenerList;
import pcgen.facade.util.MapFacade;
import pcgen.facade.util.event.FacadeEvent;
import pcgen.facade.util.event.MapEvent;
import pcgen.facade.util.event.MapListener;

public abstract class AbstractMapFacade<K, V>
implements MapFacade<K, V> {
    private EventListenerList listenerList = new EventListenerList();

    @Override
    public void addMapListener(MapListener<? super K, ? super V> listener) {
        this.listenerList.add(MapListener.class, listener);
    }

    @Override
    public void removeMapListener(MapListener<? super K, ? super V> listener) {
        this.listenerList.remove(MapListener.class, listener);
    }

    @Override
    public int getSize() {
        return this.getKeys().size();
    }

    @Override
    public boolean containsKey(K key) {
        return this.getKeys().contains(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getKeys().isEmpty();
    }

    protected void fireKeyAdded(Object source, K key, V value) {
        Object[] listeners = this.listenerList.getListenerList();
        MapEvent<K, Object> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapListener.class) continue;
            if (e == null) {
                e = new MapEvent<K, Object>(source, 0, key, null, value);
            }
            ((MapListener)listeners[i + 1]).keyAdded(e);
        }
    }

    protected void fireKeyRemoved(Object source, K key, V value) {
        Object[] listeners = this.listenerList.getListenerList();
        MapEvent<K, Object> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapListener.class) continue;
            if (e == null) {
                e = new MapEvent<K, Object>(source, 1, key, value, null);
            }
            ((MapListener)listeners[i + 1]).keyRemoved(e);
        }
    }

    protected void fireKeyModified(Object source, K key, V value, FacadeEvent cause) {
        Object[] listeners = this.listenerList.getListenerList();
        MapEvent<K, V> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapListener.class) continue;
            if (e == null) {
                e = new MapEvent<K, V>(source, 2, key, value, value, cause);
            }
            ((MapListener)listeners[i + 1]).keyModified(e);
        }
    }

    protected void fireValueChanged(Object source, K key, V oldValue, V newValue) {
        Object[] listeners = this.listenerList.getListenerList();
        MapEvent<K, V> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapListener.class) continue;
            if (e == null) {
                e = new MapEvent<K, V>(source, 3, key, oldValue, newValue);
            }
            ((MapListener)listeners[i + 1]).valueChanged(e);
        }
    }

    protected void fireValueModified(Object source, K key, V value, FacadeEvent cause) {
        Object[] listeners = this.listenerList.getListenerList();
        MapEvent<K, V> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapListener.class) continue;
            if (e == null) {
                e = new MapEvent<K, V>(source, 4, key, value, value, cause);
            }
            ((MapListener)listeners[i + 1]).valueModified(e);
        }
    }

    protected void fireKeysChanged(Object source) {
        Object[] listeners = this.listenerList.getListenerList();
        MapEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MapListener.class) continue;
            if (e == null) {
                e = new MapEvent(source);
            }
            ((MapListener)listeners[i + 1]).keysChanged(e);
        }
    }
}

