/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.List;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.helper.EqModRef;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;

public class EqModAttachment {
    public static void finishEquipment(Equipment eq) {
        for (int i = 1; i <= 2; ++i) {
            List<EqModRef> modInfoList;
            EquipmentHead head = eq.getEquipmentHeadReference(i);
            if (head == null || (modInfoList = head.getListFor(ListKey.EQMOD_INFO)) == null) continue;
            for (EqModRef modRef : modInfoList) {
                List<EquipmentModifier> modlist = head.getListFor(ListKey.EQMOD);
                EquipmentModifier eqMod = modRef.getRef().resolvesTo();
                String eqModKey = eqMod.getKeyName();
                EquipmentModifier curMod = null;
                if (modlist != null) {
                    for (EquipmentModifier mod : modlist) {
                        if (!mod.getKeyName().equals(eqModKey)) continue;
                        curMod = mod;
                        break;
                    }
                }
                if (curMod == null) {
                    if (eqMod.getSafe(StringKey.CHOICE_STRING).length() != 0) {
                        eqMod = eqMod.clone();
                    }
                    eq.addToEqModifierList(eqMod, i == 1);
                } else {
                    eqMod = curMod;
                }
                if (eqMod.getSafe(StringKey.CHOICE_STRING).length() == 0) continue;
                List<String> choices = modRef.getChoices();
                for (String x : choices) {
                    Integer min = eqMod.get(IntegerKey.MIN_CHARGES);
                    if (min != null && min > 0 || eqMod.getSafe(StringKey.CHOICE_STRING).startsWith("EQBUILDER")) {
                        eq.removeAllAssociations(eqMod);
                    }
                    eq.addAssociation(eqMod, x);
                }
            }
        }
    }
}

