/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.content.CNAbility;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.io.EntityEncoder;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.Logging;

public class Description
extends ConcretePrereqObject {
    private List<String> theComponents = new ArrayList<String>();
    private List<String> theVariables = null;
    private static final String VAR_NAME = "%NAME";
    private static final String VAR_CHOICE = "%CHOICE";
    private static final String VAR_LIST = "%LIST";
    private static final String VAR_FEATS = "%FEAT=";
    private static final String VAR_MARKER = "$$VAR:";

    public Description(String aString) {
        int currentInd = 0;
        int percentInd = -1;
        while ((percentInd = aString.indexOf(37, currentInd)) != -1) {
            String preText = aString.substring(currentInd, percentInd);
            if (preText.length() > 0) {
                this.theComponents.add(preText);
            }
            if (percentInd == aString.length() - 1) {
                this.theComponents.add("%");
                return;
            }
            if (aString.charAt(percentInd + 1) == '{') {
                currentInd = aString.indexOf(125, percentInd + 1) + 1;
                String replacement = aString.substring(percentInd + 1, currentInd);
                try {
                    Integer.parseInt(replacement);
                }
                catch (NumberFormatException nfe) {
                    Logging.errorPrintLocalised("Errors.Description.InvalidVariableReplacement", replacement);
                }
                this.theComponents.add(VAR_MARKER + replacement);
                continue;
            }
            if (aString.charAt(percentInd + 1) == '%') {
                currentInd = percentInd + 2;
                this.theComponents.add("%");
                continue;
            }
            for (currentInd = percentInd + 1; currentInd < aString.length(); ++currentInd) {
                char val = aString.charAt(currentInd);
                try {
                    Integer.parseInt(String.valueOf(val));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    break;
                }
            }
            if (currentInd > percentInd + 1) {
                this.theComponents.add(VAR_MARKER + aString.substring(percentInd + 1, currentInd));
                continue;
            }
            this.theComponents.add(aString.substring(percentInd, percentInd + 1));
            if (!Logging.isLoggable(Logging.LST_WARNING)) continue;
            Logging.log(Logging.LST_WARNING, "The % without a number in the description '" + aString + "' should be either escaped e.g. %% or made into a parameter reference e.g. %1 .");
        }
        this.theComponents.add(aString.substring(currentInd));
    }

    public void addVariable(String aVariable) {
        if (this.theVariables == null) {
            this.theVariables = new ArrayList<String>();
        }
        this.theVariables.add(aVariable);
    }

    public String getDescription(PlayerCharacter aPC, List<? extends Object> objList) {
        PObject sampleObject;
        if (objList.size() == 0) {
            return "";
        }
        Object b = objList.get(0);
        if (b instanceof PObject) {
            sampleObject = (PObject)b;
        } else if (b instanceof CNAbility) {
            sampleObject = ((CNAbility)b).getAbility();
        } else {
            Logging.errorPrint("Unable to resolve Description with object of type: " + b.getClass().getName());
            return "";
        }
        StringBuilder buf = new StringBuilder(250);
        if (this.qualifies(aPC, sampleObject)) {
            for (String comp : this.theComponents) {
                if (comp.startsWith(VAR_MARKER)) {
                    int ind = Integer.parseInt(comp.substring(VAR_MARKER.length()));
                    if (this.theVariables == null || ind > this.theVariables.size()) continue;
                    String var = this.theVariables.get(ind - 1);
                    if (var.equals(VAR_NAME)) {
                        if (sampleObject == null) continue;
                        buf.append(sampleObject.getOutputName());
                        continue;
                    }
                    if (var.equals(VAR_CHOICE)) {
                        if (b instanceof ChooseDriver) {
                            ChooseDriver object = (ChooseDriver)b;
                            if (!aPC.hasAssociations(object)) continue;
                            buf.append(aPC.getAssociationList(object).get(0));
                            continue;
                        }
                        Logging.errorPrint("In Description resolution, Ignoring object of type: " + b.getClass().getName() + " because " + VAR_CHOICE + " was requested but the object does not support CHOOSE");
                        continue;
                    }
                    if (var.equals(VAR_LIST)) {
                        ArrayList<String> assocList = new ArrayList<String>();
                        for (Object object : objList) {
                            if (object instanceof ChooseDriver) {
                                ChooseDriver object2 = (ChooseDriver)object;
                                if (!aPC.hasAssociations(object2)) continue;
                                assocList.addAll(aPC.getAssociationList(object2));
                                continue;
                            }
                            Logging.errorPrint("In Description resolution, Ignoring object of type: " + b.getClass().getName() + " because " + VAR_CHOICE + " was requested but the object does not support CHOOSE");
                        }
                        String joinString = assocList.size() == 2 ? " and " : ", ";
                        Collections.sort(assocList);
                        buf.append((CharSequence)StringUtil.joinToStringBuilder(assocList, (String)joinString));
                        continue;
                    }
                    if (var.startsWith(VAR_FEATS)) {
                        List<CNAbility> feats;
                        String featName = var.substring(VAR_FEATS.length());
                        if (featName.startsWith("TYPE=") || featName.startsWith("TYPE.")) {
                            feats = aPC.getCNAbilities(AbilityCategory.FEAT);
                        } else {
                            Ability ability = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.FEAT, featName);
                            if (ability == null) {
                                Logging.errorPrint("Found invalid Feat reference in Description: " + featName);
                            }
                            feats = aPC.getMatchingCNAbilities(ability);
                        }
                        boolean bl = false;
                        for (CNAbility cna : feats) {
                            boolean bl2;
                            if (!cna.getAbility().isType(featName.substring(5))) continue;
                            if (bl2) {
                                buf.append(' ');
                            }
                            buf.append(aPC.getDescription(Collections.singletonList(cna)));
                            bl2 = true;
                        }
                        continue;
                    }
                    if (var.startsWith("\"")) {
                        buf.append(var.substring(1, var.length() - 1));
                        continue;
                    }
                    buf.append(aPC.getVariableValue(var, "Description").intValue());
                    continue;
                }
                buf.append(comp);
            }
        }
        return buf.toString();
    }

    public String getPCCText() {
        StringBuilder buf = new StringBuilder(250);
        for (String str : this.theComponents) {
            if (str.startsWith(VAR_MARKER)) {
                int ind = Integer.parseInt(str.substring(VAR_MARKER.length()));
                buf.append('%' + String.valueOf(ind));
                continue;
            }
            if (str.equals("%")) {
                buf.append("%%");
                continue;
            }
            buf.append(EntityEncoder.encodeLight(str));
        }
        if (this.theVariables != null) {
            for (String var : this.theVariables) {
                buf.append("|");
                buf.append(var);
            }
        }
        if (this.hasPrerequisites()) {
            buf.append("|");
            buf.append(new PrerequisiteWriter().getPrerequisiteString(this.getPrerequisiteList(), "|"));
        }
        return buf.toString();
    }

    public String toString() {
        return this.getPCCText();
    }

    public int hashCode() {
        return this.theComponents.size() + 7 * this.getPrerequisiteCount() + 31 * (this.theVariables == null ? 0 : this.theVariables.size());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Description)) {
            return false;
        }
        Description other = (Description)o;
        if (this.theVariables == null && other.theVariables != null) {
            return false;
        }
        return this.theComponents.equals(other.theComponents) && (this.theVariables == null || this.theVariables.equals(other.theVariables)) && this.equalsPrereqObject(other);
    }
}

