/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content.factset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.util.FormatManager;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.factset.FactSetInfo;
import pcgen.cdom.enumeration.FactSetKey;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class FactSetParser<T extends CDOMObject, F>
extends AbstractTokenWithSeparator<T>
implements CDOMSecondaryToken<T> {
    private final FactSetInfo<T, F> def;

    public FactSetParser(FactSetInfo<T, F> fsi) {
        if (fsi == null) {
            throw new IllegalArgumentException("FactSet Info cannot be null");
        }
        this.def = fsi;
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, T obj, String value) {
        FormatManager<F> tm = this.def.getFormatManager();
        FactSetKey<F> fk = this.def.getFactSetKey();
        StringTokenizer st = new StringTokenizer(value, "|");
        boolean firstToken = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (".CLEARALL".equals(token)) {
                if (!firstToken) {
                    return new ParseResult.Fail("Non-sensical situation was encountered while parsing " + this.getParentToken() + "|" + this.getTokenName() + ": When used, .CLEARALL must be the first argument", context);
                }
                context.getObjectContext().removeSet((CDOMObject)obj, fk);
            }
            ObjectContainer indirect = tm.convertObjectContainer(token);
            context.getObjectContext().addToSet((CDOMObject)obj, fk, indirect);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public Class<T> getTokenClass() {
        return this.def.getUsableLocation();
    }

    @Override
    public String getTokenName() {
        return this.def.getFactSetName();
    }

    @Override
    public String getParentToken() {
        return "FACTSET";
    }

    @Override
    public String[] unparse(LoadContext context, T obj) {
        FactSetKey<F> fk = this.def.getFactSetKey();
        Changes<ObjectContainer<F>> changes = context.getObjectContext().getSetChanges((CDOMObject)obj, fk);
        Collection<ObjectContainer<F>> removedItems = changes.getRemoved();
        ArrayList<String> results = new ArrayList<String>(2);
        if (changes.includesGlobalClear()) {
            results.add(".CLEARALL");
        }
        if (removedItems != null && !removedItems.isEmpty()) {
            context.addWriteMessage(this.getTokenName() + " does not support " + ".CLEAR.");
            return null;
        }
        Collection<ObjectContainer<F>> added = changes.getAdded();
        if (added != null && added.size() > 0) {
            StringBuilder sb = new StringBuilder();
            boolean needsPipe = false;
            for (ObjectContainer<F> oc : added) {
                if (needsPipe) {
                    sb.append("|");
                }
                sb.append(oc.getLSTformat(false));
                needsPipe = true;
            }
            results.add(sb.toString());
        }
        return results.toArray(new String[results.size()]);
    }
}

