/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.serial.internal;

import java.net.URI;
import java.util.Enumeration;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.serial.ProtocolType;
import org.openhab.core.io.transport.serial.SerialPortIdentifier;
import org.openhab.core.io.transport.serial.SerialPortProvider;
import org.openhab.core.io.transport.serial.internal.SerialPortIdentifierImpl;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={SerialPortProvider.class})
public class JavaCommPortProvider
implements SerialPortProvider {
    private final Logger logger = LoggerFactory.getLogger(JavaCommPortProvider.class);

    public @Nullable SerialPortIdentifier getPortIdentifier(URI port) {
        CommPortIdentifier ident = null;
        try {
            ident = CommPortIdentifier.getPortIdentifier((String)port.getPath());
        }
        catch (NoSuchPortException e) {
            this.logger.debug("No SerialPortIdentifier found for: {}", (Object)port.getPath());
            return null;
        }
        return new SerialPortIdentifierImpl(ident);
    }

    public Stream<ProtocolType> getAcceptedProtocols() {
        return Stream.of(new ProtocolType(ProtocolType.PathType.LOCAL, "javacomm"));
    }

    public Stream<SerialPortIdentifier> getSerialPortIdentifiers() {
        Enumeration ids = CommPortIdentifier.getPortIdentifiers();
        return StreamSupport.stream(new SplitIteratorForEnumeration(ids), false).filter(id -> id.getPortType() == 1).map(sid -> new SerialPortIdentifierImpl((CommPortIdentifier)sid));
    }

    private static class SplitIteratorForEnumeration<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final Enumeration<T> e;

        public SplitIteratorForEnumeration(Enumeration<T> e) {
            super(Long.MAX_VALUE, 16);
            this.e = e;
        }

        @Override
        @NonNullByDefault(value={})
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.e.hasMoreElements()) {
                action.accept(this.e.nextElement());
                return true;
            }
            return false;
        }

        @Override
        @NonNullByDefault(value={})
        public void forEachRemaining(Consumer<? super T> action) {
            while (this.e.hasMoreElements()) {
                action.accept(this.e.nextElement());
            }
        }
    }
}

