/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.internal.filter;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.pid=org.openhab.core.cors"}, configurationPid={"org.openhab.cors"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@JaxrsExtension
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@NonNullByDefault
public class CorsFilter
implements ContainerResponseFilter {
    static final String HTTP_HEAD_METHOD = "HEAD";
    static final String HTTP_DELETE_METHOD = "DELETE";
    static final String HTTP_PUT_METHOD = "PUT";
    static final String HTTP_POST_METHOD = "POST";
    static final String HTTP_GET_METHOD = "GET";
    static final String HTTP_OPTIONS_METHOD = "OPTIONS";
    static final String CONTENT_TYPE_HEADER = "Content-Type";
    static final String AUTHORIZATION_HEADER = "Authorization";
    static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
    static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    static final String ORIGIN_HEADER = "Origin";
    static final String VARY_HEADER = "Vary";
    static final String VARY_HEADER_WILDCARD = "*";
    static final String HEADERS_SEPARATOR = ",";
    static final List<String> ACCEPTED_HTTP_METHODS_LIST = List.of("GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS");
    static final String ACCEPTED_HTTP_METHODS = ACCEPTED_HTTP_METHODS_LIST.stream().collect(Collectors.joining(","));
    private final transient Logger logger = LoggerFactory.getLogger(CorsFilter.class);
    private boolean isEnabled = false;

    public void filter(@NonNullByDefault(value={}) ContainerRequestContext requestContext, @NonNullByDefault(value={}) ContainerResponseContext responseContext) throws IOException {
        if (this.isEnabled && !this.processPreflight(requestContext, responseContext)) {
            this.processRequest(requestContext, responseContext);
        }
    }

    private void processRequest(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        String origin;
        if (ACCEPTED_HTTP_METHODS_LIST.contains(requestContext.getMethod()) && !HTTP_OPTIONS_METHOD.equals(requestContext.getMethod()) && (origin = this.getValue((MultivaluedMap<String, String>)requestContext.getHeaders(), ORIGIN_HEADER)) != null && !origin.isBlank()) {
            responseContext.getHeaders().add((Object)ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, (Object)origin);
        }
    }

    private boolean processPreflight(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        boolean isCorsPreflight = false;
        if (HTTP_OPTIONS_METHOD.equals(requestContext.getMethod())) {
            String origin = this.getValue((MultivaluedMap<String, String>)requestContext.getHeaders(), ORIGIN_HEADER);
            String realRequestMethod = this.getValue((MultivaluedMap<String, String>)requestContext.getHeaders(), ACCESS_CONTROL_REQUEST_METHOD);
            boolean bl = isCorsPreflight = origin != null && !origin.isBlank() && realRequestMethod != null && !realRequestMethod.isBlank();
            if (isCorsPreflight) {
                responseContext.getHeaders().add((Object)ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, (Object)origin);
                responseContext.getHeaders().add((Object)ACCESS_CONTROL_ALLOW_METHODS_HEADER, (Object)ACCEPTED_HTTP_METHODS);
                responseContext.getHeaders().add((Object)ACCESS_CONTROL_ALLOW_HEADERS, (Object)CONTENT_TYPE_HEADER);
                responseContext.getHeaders().add((Object)ACCESS_CONTROL_ALLOW_HEADERS, (Object)AUTHORIZATION_HEADER);
                this.appendVaryHeader(responseContext);
            }
        }
        return isCorsPreflight;
    }

    private @Nullable String getValue(MultivaluedMap<String, String> headers, String header) {
        List values = (List)headers.get((Object)header);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.get(0);
    }

    private void appendVaryHeader(ContainerResponseContext responseContext) {
        String varyHeader = this.getValue((MultivaluedMap<String, String>)responseContext.getStringHeaders(), VARY_HEADER);
        if (varyHeader == null || varyHeader.isBlank()) {
            responseContext.getHeaders().add((Object)VARY_HEADER, (Object)ORIGIN_HEADER);
        } else if (!VARY_HEADER_WILDCARD.equals(varyHeader)) {
            responseContext.getHeaders().putSingle((Object)VARY_HEADER, (Object)(String.valueOf(varyHeader) + HEADERS_SEPARATOR + ORIGIN_HEADER));
        }
    }

    @Activate
    protected void activate(@Nullable Map<String, Object> properties) {
        if (properties != null) {
            String corsPropertyValue = (String)properties.get("enable");
            this.isEnabled = "true".equalsIgnoreCase(corsPropertyValue);
        }
        if (this.isEnabled) {
            this.logger.info("enabled CORS for REST API.");
        }
    }
}

