/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.rest.JSONInputStream;

@NonNullByDefault
public class Stream2JSONInputStream
extends InputStream
implements JSONInputStream {
    private final Iterator<String> iterator;
    private InputStream jsonElementStream;
    private boolean firstIteratorElement;
    private final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();

    public Stream2JSONInputStream(Stream<?> source) {
        this.iterator = source.map(e -> this.gson.toJson(e)).iterator();
        this.jsonElementStream = new ByteArrayInputStream(new byte[0]);
        this.firstIteratorElement = true;
    }

    @Override
    public int read() throws IOException {
        int result = this.jsonElementStream.read();
        if (result == -1) {
            if (this.finished()) {
                return -1;
            }
            this.fillBuffer();
            result = this.jsonElementStream.read();
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.jsonElementStream.close();
    }

    private void fillBuffer() {
        String prefix;
        if (this.firstIteratorElement) {
            prefix = "[";
            this.firstIteratorElement = false;
        } else {
            prefix = ",";
        }
        String entity = this.iterator.hasNext() ? this.iterator.next() : "";
        String postfix = "";
        if (!this.iterator.hasNext()) {
            postfix = "]";
        }
        try {
            this.jsonElementStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.jsonElementStream = new ByteArrayInputStream((String.valueOf(prefix) + entity + postfix).getBytes(StandardCharsets.UTF_8));
    }

    private boolean finished() {
        return !this.firstIteratorElement && !this.iterator.hasNext();
    }
}

