/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.addon.ip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.text.ParseException;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.addon.AddonDiscoveryMethod;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.config.discovery.addon.AddonFinder;
import org.openhab.core.config.discovery.addon.BaseAddonFinder;
import org.openhab.core.net.NetUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AddonFinder.class}, name="ip-addon-suggestion-finder")
public class IpAddonFinder
extends BaseAddonFinder {
    public static final String SERVICE_TYPE = "ip";
    public static final String SERVICE_NAME = "ip-addon-suggestion-finder";
    private static final String TYPE_IP_MULTICAST = "ipMulticast";
    private static final String MATCH_PROPERTY_RESPONSE = "response";
    private static final String PARAMETER_DEST_IP = "destIp";
    private static final String PARAMETER_DEST_PORT = "destPort";
    private static final String PARAMETER_REQUEST = "request";
    private static final String PARAMETER_SRC_IP = "srcIp";
    private static final String PARAMETER_SRC_PORT = "srcPort";
    private static final String PARAMETER_TIMEOUT_MS = "timeoutMs";
    private final Logger logger = LoggerFactory.getLogger(IpAddonFinder.class);
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private @Nullable Future<?> scanJob = null;
    Set<AddonInfo> suggestions = new HashSet<AddonInfo>();

    public IpAddonFinder() {
        this.logger.trace("IpAddonFinder::IpAddonFinder");
    }

    @Deactivate
    public void deactivate() {
        this.logger.trace("IpAddonFinder::deactivate");
        this.stopScan();
    }

    public void setAddonCandidates(List<AddonInfo> candidates) {
        this.logger.debug("IpAddonFinder::setAddonCandidates({})", (Object)candidates.size());
        super.setAddonCandidates(candidates);
        this.startScan();
    }

    private void startScan() {
        this.stopScan();
        this.scanJob = this.scheduler.schedule(this::scan, 20L, TimeUnit.SECONDS);
    }

    private void stopScan() {
        Future<?> tmpScanJob = this.scanJob;
        if (tmpScanJob != null) {
            if (!tmpScanJob.isDone()) {
                this.logger.trace("Trying to cancel IP scan");
                tmpScanJob.cancel(true);
            }
            this.scanJob = null;
        }
    }

    private void scan() {
        this.logger.trace("IpAddonFinder::scan started");
        for (AddonInfo candidate : this.addonCandidates) {
            block23: for (AddonDiscoveryMethod method2 : candidate.getDiscoveryMethods().stream().filter(method -> SERVICE_TYPE.equals(method.getServiceType())).toList()) {
                this.logger.trace("Checking candidate: {}", (Object)candidate.getUID());
                Map<String, String> parameters = method2.getParameters().stream().collect(Collectors.toMap(property -> property.getName(), property -> property.getValue()));
                Map<String, String> matchProperties = method2.getMatchProperties().stream().collect(Collectors.toMap(property -> property.getName(), property -> property.getRegex()));
                String type = Objects.toString(parameters.get("type"), "");
                String request = Objects.toString(parameters.get(PARAMETER_REQUEST), "");
                String response = Objects.toString(matchProperties.get(MATCH_PROPERTY_RESPONSE), "");
                int timeoutMs = 0;
                try {
                    timeoutMs = Integer.parseInt(Objects.toString(parameters.get(PARAMETER_TIMEOUT_MS)));
                }
                catch (NumberFormatException e) {
                    this.logger.warn("{}: discovery-parameter '{}' cannot be parsed", (Object)candidate.getUID(), (Object)PARAMETER_TIMEOUT_MS);
                    continue;
                }
                InetAddress destIp = null;
                try {
                    destIp = InetAddress.getByName(parameters.get(PARAMETER_DEST_IP));
                }
                catch (UnknownHostException e) {
                    this.logger.warn("{}: discovery-parameter '{}' cannot be parsed", (Object)candidate.getUID(), (Object)PARAMETER_DEST_IP);
                    continue;
                }
                int destPort = 0;
                try {
                    destPort = Integer.parseInt(Objects.toString(parameters.get(PARAMETER_DEST_PORT)));
                }
                catch (NumberFormatException e) {
                    this.logger.warn("{}: discovery-parameter '{}' cannot be parsed", (Object)candidate.getUID(), (Object)PARAMETER_DEST_PORT);
                    continue;
                }
                try {
                    switch (Objects.toString(type)) {
                        case "ipMulticast": {
                            List<String> ipAddresses = NetUtil.getAllInterfaceAddresses().stream().filter(a -> a.getAddress() instanceof Inet4Address).map(a -> a.getAddress().getHostAddress()).toList();
                            for (String localIp : ipAddresses) {
                                try {
                                    DatagramChannel channel = (DatagramChannel)((AbstractSelectableChannel)((Object)((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).bind(new InetSocketAddress(localIp, 0)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)64))).configureBlocking(false);
                                    byte[] requestArray = this.buildRequestArray(channel, Objects.toString(request));
                                    this.logger.trace("{}: {}", (Object)candidate.getUID(), (Object)HexFormat.of().withDelimiter(" ").formatHex(requestArray));
                                    channel.send(ByteBuffer.wrap(requestArray), new InetSocketAddress(destIp, destPort));
                                    Selector selector = Selector.open();
                                    ByteBuffer buffer = ByteBuffer.wrap(new byte[50]);
                                    channel.register(selector, 1);
                                    selector.select(timeoutMs);
                                    Iterator<SelectionKey> it = selector.selectedKeys().iterator();
                                    switch (Objects.toString(response)) {
                                        case ".*": {
                                            if (it.hasNext()) {
                                                SocketAddress source = ((DatagramChannel)it.next().channel()).receive(buffer);
                                                this.logger.debug("Received return frame from {}", (Object)((InetSocketAddress)source).getAddress().getHostAddress());
                                                this.suggestions.add(candidate);
                                                this.logger.debug("Suggested add-on found: {}", (Object)candidate.getUID());
                                                break;
                                            }
                                            this.logger.trace("{}: no response", (Object)candidate.getUID());
                                            break;
                                        }
                                        default: {
                                            this.logger.warn("{}: match-property response \"{}\" is unknown", (Object)candidate.getUID(), (Object)type);
                                            break;
                                        }
                                    }
                                }
                                catch (IOException e) {
                                    this.logger.debug("{}: network error", (Object)candidate.getUID(), (Object)e);
                                }
                            }
                            continue block23;
                        }
                        default: {
                            this.logger.warn("{}: discovery-parameter type \"{}\" is unknown", (Object)candidate.getUID(), (Object)type);
                            break;
                        }
                    }
                }
                catch (NumberFormatException | ParseException exception) {
                    // empty catch block
                }
            }
        }
        this.logger.trace("IpAddonFinder::scan completed");
    }

    private byte[] buildRequestArray(DatagramChannel channel, String request) throws IOException, ParseException {
        InetSocketAddress sock = (InetSocketAddress)channel.getLocalAddress();
        ByteArrayOutputStream requestFrame = new ByteArrayOutputStream();
        StringTokenizer parts = new StringTokenizer(request);
        block8: while (parts.hasMoreTokens()) {
            String token;
            block11: {
                token = parts.nextToken();
                if (!token.startsWith("$")) break block11;
                switch (token) {
                    case "$srcIp": {
                        byte[] adr = sock.getAddress().getAddress();
                        requestFrame.write(adr);
                        continue block8;
                    }
                    case "$srcPort": {
                        int dPort = sock.getPort();
                        requestFrame.write((byte)(dPort >> 8 & 0xFF));
                        requestFrame.write((byte)(dPort & 0xFF));
                        continue block8;
                    }
                    default: {
                        this.logger.warn("Unknown token in request frame \"{}\"", (Object)token);
                        throw new ParseException(token, 0);
                    }
                }
            }
            int i = Integer.decode(token);
            requestFrame.write((byte)i);
        }
        return requestFrame.toByteArray();
    }

    public Set<AddonInfo> getSuggestedAddons() {
        this.logger.trace("IpAddonFinder::getSuggestedAddons {}/{}", (Object)this.suggestions.size(), (Object)this.addonCandidates.size());
        return this.suggestions;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }
}

