/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence.filter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import javax.measure.UnconvertibleException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.Item;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.persistence.filter.PersistenceFilter;
import org.openhab.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class PersistenceThresholdFilter
extends PersistenceFilter {
    private static final BigDecimal HUNDRED = BigDecimal.valueOf(100L);
    private final Logger logger = LoggerFactory.getLogger(PersistenceThresholdFilter.class);
    private final BigDecimal value;
    private final String unit;
    private final boolean relative;
    private final transient Map<String, State> valueCache = new HashMap<String, State>();

    public PersistenceThresholdFilter(String name, BigDecimal value, @Nullable String unit, @Nullable Boolean relative) {
        super(name);
        this.value = value;
        this.unit = unit == null ? "" : unit;
        this.relative = relative == null ? false : relative;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean isRelative() {
        return this.relative;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean apply(Item item) {
        String itemName = item.getName();
        State state = item.getState();
        if (!(state instanceof DecimalType) && !(state instanceof QuantityType)) {
            return true;
        }
        State cachedState = this.valueCache.get(itemName);
        if (cachedState == null || !state.getClass().equals(cachedState.getClass())) {
            return true;
        }
        if (state instanceof DecimalType) {
            BigDecimal oldState = ((DecimalType)cachedState).toBigDecimal();
            BigDecimal delta = oldState.subtract(((DecimalType)state).toBigDecimal());
            if (!this.relative || BigDecimal.ZERO.equals(oldState)) return delta.abs().compareTo(this.value) > 0;
            delta = delta.multiply(HUNDRED).divide(oldState, 2, RoundingMode.HALF_UP);
            return delta.abs().compareTo(this.value) > 0;
        }
        try {
            QuantityType oldState = (QuantityType)cachedState;
            QuantityType delta = oldState.subtract((QuantityType)state);
            if (this.relative) {
                if (BigDecimal.ZERO.equals(oldState.toBigDecimal())) {
                    return true;
                }
                delta = delta.multiply(HUNDRED).divide(oldState);
                return delta.toBigDecimal().abs().compareTo(this.value) > 0;
            } else {
                if (this.unit.isBlank() || (delta = delta.toUnit(this.unit)) != null) return delta.toBigDecimal().abs().compareTo(this.value) > 0;
                throw new UnconvertibleException("");
            }
        }
        catch (UnconvertibleException e) {
            this.logger.warn("Cannot compare {} to {}", (Object)cachedState, (Object)state);
            return true;
        }
    }

    @Override
    public void persisted(Item item) {
        this.valueCache.put(item.getName(), item.getState());
    }

    @Override
    public String toString() {
        return String.format("%s [name=%s, value=%s, unit=%s, relative=%b]", this.getClass().getSimpleName(), this.getName(), this.value, this.unit, this.relative);
    }
}

