/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence.filter;

import java.math.BigDecimal;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.Item;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.persistence.filter.PersistenceFilter;
import org.openhab.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class PersistenceIncludeFilter
extends PersistenceFilter {
    private final Logger logger = LoggerFactory.getLogger(PersistenceIncludeFilter.class);
    private final BigDecimal lower;
    private final BigDecimal upper;
    private final String unit;
    private final boolean inverted;

    public PersistenceIncludeFilter(String name, BigDecimal lower, BigDecimal upper, @Nullable String unit, @Nullable Boolean inverted) {
        super(name);
        this.lower = lower;
        this.upper = upper;
        this.unit = unit == null ? "" : unit;
        this.inverted = inverted == null ? false : inverted;
    }

    public BigDecimal getLower() {
        return this.lower;
    }

    public BigDecimal getUpper() {
        return this.upper;
    }

    public String getUnit() {
        return this.unit;
    }

    public boolean getInverted() {
        return this.inverted;
    }

    @Override
    public boolean apply(Item item) {
        State state = item.getState();
        BigDecimal compareValue = null;
        if (state instanceof DecimalType var4_5) {
            compareValue = decimalType.toBigDecimal();
        } else {
            if (state instanceof QuantityType var6_7 && !this.unit.isBlank() && (convertedQuantity = quantityType.toUnit(this.unit)) != null) {
                compareValue = convertedQuantity.toBigDecimal();
            }
        }
        if (compareValue == null) {
            this.logger.warn("Cannot compare {} to range {}{} - {}{} ", new Object[]{state, this.lower, this.unit, this.upper, this.unit});
            return true;
        }
        if (this.inverted) {
            return compareValue.compareTo(this.lower) <= 0 || compareValue.compareTo(this.upper) >= 0;
        }
        return compareValue.compareTo(this.lower) >= 0 && compareValue.compareTo(this.upper) <= 0;
    }

    @Override
    public void persisted(Item item) {
    }

    @Override
    public String toString() {
        return String.format("%s [name=%s, lower=%s, upper=%s, unit=%s, inverted=%b]", this.getClass().getSimpleName(), this.getName(), this.lower, this.upper, this.unit, this.inverted);
    }
}

