/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence.filter;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.Item;
import org.openhab.core.persistence.filter.PersistenceFilter;

@NonNullByDefault
public class PersistenceEqualsFilter
extends PersistenceFilter {
    private final Collection<String> values;
    private final boolean inverted;

    public PersistenceEqualsFilter(String name, Collection<String> values, @Nullable Boolean inverted) {
        super(name);
        this.values = values;
        this.inverted = inverted == null ? false : inverted;
    }

    public Collection<String> getValues() {
        return this.values;
    }

    public boolean getInverted() {
        return this.inverted;
    }

    @Override
    public boolean apply(Item item) {
        return this.values.contains(item.getState().toFullString()) ^ this.inverted;
    }

    @Override
    public void persisted(Item item) {
    }

    @Override
    public String toString() {
        return String.format("%s [name=%s, value=%s, inverted=]", this.getClass().getSimpleName(), this.getName(), this.values);
    }
}

