/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence.extensions;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.Item;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.persistence.FilterCriteria;
import org.openhab.core.persistence.HistoricItem;
import org.openhab.core.persistence.PersistenceService;
import org.openhab.core.persistence.PersistenceServiceRegistry;
import org.openhab.core.persistence.QueryablePersistenceService;
import org.openhab.core.types.State;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class PersistenceExtensions {
    private static PersistenceServiceRegistry registry;

    @Activate
    public PersistenceExtensions(@Reference PersistenceServiceRegistry registry) {
        PersistenceExtensions.registry = registry;
    }

    public static void persist(Item item, String serviceId) {
        PersistenceService service = PersistenceExtensions.getService(serviceId);
        if (service != null) {
            service.store(item);
        } else {
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no persistence service registered with the id '{}'", (Object)serviceId);
        }
    }

    public static void persist(Item item) {
        PersistenceExtensions.persist(item, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable HistoricItem historicState(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.historicState(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable HistoricItem historicState(Item item, ZonedDateTime timestamp, String serviceId) {
        PersistenceService service = PersistenceExtensions.getService(serviceId);
        if (service instanceof QueryablePersistenceService var4_5) {
            FilterCriteria filter = new FilterCriteria();
            filter.setEndDate(timestamp);
            filter.setItemName(item.getName());
            filter.setPageSize(1);
            filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
            Iterable<HistoricItem> result = qService.query(filter);
            if (result.iterator().hasNext()) {
                return result.iterator().next();
            }
            return null;
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the id '{}'", (Object)serviceId);
        return null;
    }

    public static @Nullable ZonedDateTime lastUpdate(Item item) {
        return PersistenceExtensions.lastUpdate(item, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable ZonedDateTime lastUpdate(Item item, String serviceId) {
        PersistenceService service = PersistenceExtensions.getService(serviceId);
        if (service instanceof QueryablePersistenceService var3_4) {
            FilterCriteria filter = new FilterCriteria();
            filter.setItemName(item.getName());
            filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
            filter.setPageSize(1);
            Iterable<HistoricItem> result = qService.query(filter);
            if (result.iterator().hasNext()) {
                return result.iterator().next().getTimestamp();
            }
            return null;
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the id '{}'", (Object)serviceId);
        return null;
    }

    public static @Nullable HistoricItem previousState(Item item) {
        return PersistenceExtensions.previousState(item, false);
    }

    public static @Nullable HistoricItem previousState(Item item, boolean skipEqual) {
        return PersistenceExtensions.previousState(item, skipEqual, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable HistoricItem previousState(Item item, boolean skipEqual, String serviceId) {
        PersistenceService service = PersistenceExtensions.getService(serviceId);
        if (service instanceof QueryablePersistenceService var4_5) {
            FilterCriteria filter = new FilterCriteria();
            filter.setItemName(item.getName());
            filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
            filter.setPageSize(skipEqual ? 1000 : 1);
            int startPage = 0;
            filter.setPageNumber(startPage);
            Iterable<HistoricItem> items = qService.query(filter);
            while (items != null) {
                Iterator<HistoricItem> itemIterator = items.iterator();
                int itemCount = 0;
                while (itemIterator.hasNext()) {
                    HistoricItem historicItem = itemIterator.next();
                    ++itemCount;
                    if (skipEqual && historicItem.getState().equals(item.getState())) continue;
                    return historicItem;
                }
                if (itemCount == filter.getPageSize()) {
                    filter.setPageNumber(++startPage);
                    items = qService.query(filter);
                    continue;
                }
                items = null;
            }
        } else {
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the id '{}'", (Object)serviceId);
        }
        return null;
    }

    public static boolean changedSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.changedSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static boolean changedBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.changedBetween(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static boolean changedSince(Item item, ZonedDateTime timestamp, String serviceId) {
        return PersistenceExtensions.internalChanged(item, timestamp, null, serviceId);
    }

    public static boolean changedBetween(Item item, ZonedDateTime begin, ZonedDateTime end, String serviceId) {
        return PersistenceExtensions.internalChanged(item, begin, end, serviceId);
    }

    private static boolean internalChanged(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetween(item, begin, end, serviceId);
        Iterator<HistoricItem> it = result.iterator();
        HistoricItem itemThen = PersistenceExtensions.historicState(item, begin, serviceId);
        if (itemThen == null) {
            return it.hasNext();
        }
        State state = itemThen.getState();
        while (it.hasNext()) {
            HistoricItem hItem = it.next();
            if (!hItem.getState().equals(state)) {
                return true;
            }
            state = hItem.getState();
        }
        return false;
    }

    public static boolean updatedSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.updatedSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static boolean updatedBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.updatedBetween(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static boolean updatedSince(Item item, ZonedDateTime timestamp, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetween(item, timestamp, null, serviceId);
        return result.iterator().hasNext();
    }

    public static boolean updatedBetween(Item item, ZonedDateTime begin, ZonedDateTime end, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetween(item, begin, end, serviceId);
        return result.iterator().hasNext();
    }

    public static @Nullable HistoricItem maximumSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.maximumSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable HistoricItem maximumBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalMaximum(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable HistoricItem maximumSince(Item item, ZonedDateTime timestamp, String serviceId) {
        return PersistenceExtensions.internalMaximum(item, timestamp, null, serviceId);
    }

    public static @Nullable HistoricItem maximumBetween(Item item, ZonedDateTime begin, ZonedDateTime end, String serviceId) {
        return PersistenceExtensions.internalMaximum(item, begin, end, serviceId);
    }

    private static @Nullable HistoricItem internalMaximum(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetweenWithBoundaries(item, begin, end, serviceId);
        Iterator<HistoricItem> it = result.iterator();
        HistoricItem maximumHistoricItem = null;
        DecimalType maximum = end == null ? (DecimalType)item.getStateAs(DecimalType.class) : null;
        while (it.hasNext()) {
            HistoricItem historicItem = it.next();
            DecimalType value = (DecimalType)historicItem.getState().as(DecimalType.class);
            if (value == null || maximum != null && value.compareTo(maximum) <= 0) continue;
            maximum = value;
            maximumHistoricItem = historicItem;
        }
        return PersistenceExtensions.historicItemOrCurrentState(item, maximumHistoricItem, maximum);
    }

    public static @Nullable HistoricItem minimumSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.minimumSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable HistoricItem minimumBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.internalMinimum(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable HistoricItem minimumSince(Item item, ZonedDateTime timestamp, String serviceId) {
        return PersistenceExtensions.internalMinimum(item, timestamp, null, serviceId);
    }

    public static @Nullable HistoricItem minimumBetween(Item item, ZonedDateTime begin, ZonedDateTime end, String serviceId) {
        return PersistenceExtensions.internalMinimum(item, begin, end, serviceId);
    }

    private static @Nullable HistoricItem internalMinimum(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetweenWithBoundaries(item, begin, end, serviceId);
        Iterator<HistoricItem> it = result.iterator();
        HistoricItem minimumHistoricItem = null;
        DecimalType minimum = end == null ? (DecimalType)item.getStateAs(DecimalType.class) : null;
        while (it.hasNext()) {
            HistoricItem historicItem = it.next();
            DecimalType value = (DecimalType)historicItem.getState().as(DecimalType.class);
            if (value == null || minimum != null && value.compareTo(minimum) >= 0) continue;
            minimum = value;
            minimumHistoricItem = historicItem;
        }
        return PersistenceExtensions.historicItemOrCurrentState(item, minimumHistoricItem, minimum);
    }

    public static @Nullable DecimalType varianceSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.varianceSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable DecimalType varianceBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.varianceBetween(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable DecimalType varianceSince(Item item, ZonedDateTime timestamp, String serviceId) {
        return PersistenceExtensions.internalVariance(item, timestamp, null, serviceId);
    }

    public static @Nullable DecimalType varianceBetween(Item item, ZonedDateTime begin, ZonedDateTime end, String serviceId) {
        return PersistenceExtensions.internalVariance(item, begin, end, serviceId);
    }

    private static @Nullable DecimalType internalVariance(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetweenWithBoundaries(item, begin, end, serviceId);
        Iterator<HistoricItem> it = result.iterator();
        DecimalType averageSince = PersistenceExtensions.internalAverage(item, it, end);
        if (averageSince != null) {
            BigDecimal average = averageSince.toBigDecimal();
            BigDecimal sum = BigDecimal.ZERO;
            int count = 0;
            for (HistoricItem historicItem : result) {
                DecimalType value = (DecimalType)historicItem.getState().as(DecimalType.class);
                if (value == null) continue;
                ++count;
                sum = sum.add(value.toBigDecimal().subtract(average, MathContext.DECIMAL64).pow(2, MathContext.DECIMAL64));
            }
            if (count > 0) {
                return new DecimalType((Number)sum.divide(BigDecimal.valueOf(count), MathContext.DECIMAL64));
            }
        }
        return null;
    }

    public static @Nullable DecimalType deviationSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.deviationSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable DecimalType deviationBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.deviationBetween(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable DecimalType deviationSince(Item item, ZonedDateTime timestamp, String serviceId) {
        return PersistenceExtensions.internalDeviation(item, timestamp, null, serviceId);
    }

    public static @Nullable DecimalType deviationBetween(Item item, ZonedDateTime begin, ZonedDateTime end, String serviceId) {
        return PersistenceExtensions.internalDeviation(item, begin, end, serviceId);
    }

    private static @Nullable DecimalType internalDeviation(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end, String serviceId) {
        BigDecimal bd;
        DecimalType variance = PersistenceExtensions.internalVariance(item, begin, end, serviceId);
        if (variance != null && BigDecimal.ZERO.compareTo(bd = variance.toBigDecimal()) <= 0) {
            return new DecimalType((Number)bd.sqrt(MathContext.DECIMAL64));
        }
        return null;
    }

    public static @Nullable DecimalType averageSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.averageSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable DecimalType averageBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.averageBetween(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable DecimalType averageSince(Item item, ZonedDateTime timestamp, String serviceId) {
        return PersistenceExtensions.averageBetween(item, timestamp, null, serviceId);
    }

    public static @Nullable DecimalType averageBetween(Item item, ZonedDateTime begin, ZonedDateTime end, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetweenWithBoundaries(item, begin, end, serviceId);
        Iterator<HistoricItem> it = result.iterator();
        return PersistenceExtensions.internalAverage(item, it, end);
    }

    private static @Nullable DecimalType internalAverage(Item item, Iterator<HistoricItem> it, ZonedDateTime endTime) {
        if (endTime == null) {
            endTime = ZonedDateTime.now();
        }
        BigDecimal sum = BigDecimal.ZERO;
        HistoricItem lastItem = null;
        ZonedDateTime firstTimestamp = null;
        while (it.hasNext()) {
            HistoricItem thisItem = it.next();
            if (lastItem != null) {
                BigDecimal value = ((DecimalType)lastItem.getState().as(DecimalType.class)).toBigDecimal();
                BigDecimal weight = BigDecimal.valueOf(Duration.between(lastItem.getTimestamp(), thisItem.getTimestamp()).toMillis());
                sum = sum.add(value.multiply(weight));
            }
            if (firstTimestamp == null) {
                firstTimestamp = thisItem.getTimestamp();
            }
            lastItem = thisItem;
        }
        if (lastItem != null) {
            BigDecimal value = ((DecimalType)lastItem.getState().as(DecimalType.class)).toBigDecimal();
            BigDecimal weight = BigDecimal.valueOf(Duration.between(lastItem.getTimestamp(), endTime).toMillis());
            sum = sum.add(value.multiply(weight));
        }
        if (firstTimestamp != null) {
            BigDecimal totalDuration = BigDecimal.valueOf(Duration.between(firstTimestamp, endTime).toMillis());
            return totalDuration.signum() == 0 ? null : new DecimalType((Number)sum.divide(totalDuration, MathContext.DECIMAL64));
        }
        return null;
    }

    public static DecimalType sumSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.sumSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static DecimalType sumBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.sumBetween(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static DecimalType sumSince(Item item, ZonedDateTime timestamp, String serviceId) {
        return PersistenceExtensions.internalSum(item, timestamp, null, serviceId);
    }

    public static DecimalType sumBetween(Item item, ZonedDateTime begin, ZonedDateTime end, String serviceId) {
        return PersistenceExtensions.internalSum(item, begin, end, serviceId);
    }

    private static DecimalType internalSum(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetween(item, begin, end, serviceId);
        Iterator<HistoricItem> it = result.iterator();
        BigDecimal sum = BigDecimal.ZERO;
        while (it.hasNext()) {
            HistoricItem historicItem = it.next();
            DecimalType value = (DecimalType)historicItem.getState().as(DecimalType.class);
            if (value == null) continue;
            sum = sum.add(value.toBigDecimal());
        }
        return new DecimalType((Number)sum);
    }

    public static @Nullable DecimalType deltaSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.deltaSince(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable DecimalType deltaBetween(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.deltaBetween(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable DecimalType deltaSince(Item item, ZonedDateTime timestamp, String serviceId) {
        HistoricItem itemThen = PersistenceExtensions.historicState(item, timestamp, serviceId);
        if (itemThen != null) {
            DecimalType valueThen = (DecimalType)itemThen.getState().as(DecimalType.class);
            DecimalType valueNow = (DecimalType)item.getStateAs(DecimalType.class);
            if (valueThen != null && valueNow != null) {
                return new DecimalType((Number)valueNow.toBigDecimal().subtract(valueThen.toBigDecimal()));
            }
        }
        return null;
    }

    public static @Nullable DecimalType deltaBetween(Item item, ZonedDateTime begin, ZonedDateTime end, String serviceId) {
        HistoricItem itemStart = PersistenceExtensions.historicState(item, begin, serviceId);
        HistoricItem itemStop = PersistenceExtensions.historicState(item, end, serviceId);
        if (itemStart != null && itemStop != null) {
            DecimalType valueStart = (DecimalType)itemStart.getState().as(DecimalType.class);
            DecimalType valueStop = (DecimalType)itemStop.getState().as(DecimalType.class);
            if (valueStart != null && valueStop != null) {
                return new DecimalType((Number)valueStop.toBigDecimal().subtract(valueStart.toBigDecimal()));
            }
        }
        return null;
    }

    public static DecimalType evolutionRate(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.evolutionRate(item, timestamp, PersistenceExtensions.getDefaultServiceId());
    }

    public static DecimalType evolutionRate(Item item, ZonedDateTime begin, ZonedDateTime end) {
        return PersistenceExtensions.evolutionRate(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static @Nullable DecimalType evolutionRate(Item item, ZonedDateTime timestamp, String serviceId) {
        HistoricItem itemThen = PersistenceExtensions.historicState(item, timestamp, serviceId);
        if (itemThen != null) {
            DecimalType valueThen = (DecimalType)itemThen.getState().as(DecimalType.class);
            DecimalType valueNow = (DecimalType)item.getStateAs(DecimalType.class);
            if (valueThen != null && valueThen.toBigDecimal().compareTo(BigDecimal.ZERO) != 0 && valueNow != null) {
                return new DecimalType((Number)valueNow.toBigDecimal().subtract(valueThen.toBigDecimal()).divide(valueThen.toBigDecimal(), MathContext.DECIMAL64).movePointRight(2));
            }
        }
        return null;
    }

    public static @Nullable DecimalType evolutionRate(Item item, ZonedDateTime begin, ZonedDateTime end, String serviceId) {
        HistoricItem itemBegin = PersistenceExtensions.historicState(item, begin, serviceId);
        HistoricItem itemEnd = PersistenceExtensions.historicState(item, end, serviceId);
        if (itemBegin != null && itemEnd != null) {
            DecimalType valueBegin = (DecimalType)itemBegin.getState().as(DecimalType.class);
            DecimalType valueEnd = (DecimalType)itemEnd.getState().as(DecimalType.class);
            if (valueBegin != null && valueBegin.toBigDecimal().compareTo(BigDecimal.ZERO) != 0 && valueEnd != null) {
                return new DecimalType((Number)valueEnd.toBigDecimal().subtract(valueBegin.toBigDecimal()).divide(valueBegin.toBigDecimal(), MathContext.DECIMAL64).movePointRight(2));
            }
        }
        return null;
    }

    public static long countSince(Item item, ZonedDateTime begin) {
        return PersistenceExtensions.countSince(item, begin, PersistenceExtensions.getDefaultServiceId());
    }

    public static long countSince(Item item, ZonedDateTime begin, String serviceId) {
        return PersistenceExtensions.countBetween(item, begin, null, serviceId);
    }

    public static long countBetween(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end) {
        return PersistenceExtensions.countBetween(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static long countBetween(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end, String serviceId) {
        Iterable<HistoricItem> historicItems = PersistenceExtensions.getAllStatesBetween(item, begin, end, serviceId);
        if (historicItems instanceof Collection var5_6) {
            return collection.size();
        }
        return StreamSupport.stream(historicItems.spliterator(), false).count();
    }

    public static long countStateChangesSince(Item item, ZonedDateTime begin) {
        return PersistenceExtensions.countStateChangesSince(item, begin, PersistenceExtensions.getDefaultServiceId());
    }

    public static long countStateChangesSince(Item item, ZonedDateTime begin, String serviceId) {
        return PersistenceExtensions.countStateChangesBetween(item, begin, null, serviceId);
    }

    public static long countStateChangesBetween(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end) {
        return PersistenceExtensions.countStateChangesBetween(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static long countStateChangesBetween(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end, String serviceId) {
        Iterable<HistoricItem> result = PersistenceExtensions.getAllStatesBetween(item, begin, end, serviceId);
        Iterator<HistoricItem> it = result.iterator();
        if (!it.hasNext()) {
            return 0L;
        }
        long count = 0L;
        State previousState = it.next().getState();
        while (it.hasNext()) {
            HistoricItem historicItem = it.next();
            State state = historicItem.getState();
            if (state.equals(previousState)) continue;
            previousState = state;
            ++count;
        }
        return count;
    }

    private static @Nullable PersistenceService getService(String serviceId) {
        if (registry != null) {
            return serviceId != null ? registry.get(serviceId) : registry.getDefault();
        }
        return null;
    }

    private static @Nullable String getDefaultServiceId() {
        if (registry != null) {
            String id = registry.getDefaultId();
            if (id != null) {
                return id;
            }
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no default persistence service configured!");
        } else {
            LoggerFactory.getLogger(PersistenceExtensions.class).warn("PersistenceServiceRegistryImpl is not available!");
        }
        return null;
    }

    public static Iterable<HistoricItem> getAllStatesSince(Item item, ZonedDateTime timestamp) {
        return PersistenceExtensions.getAllStatesBetween(item, timestamp, null);
    }

    public static Iterable<HistoricItem> getAllStatesSince(Item item, ZonedDateTime timestamp, String serviceId) {
        return PersistenceExtensions.getAllStatesBetween(item, timestamp, null, serviceId);
    }

    public static Iterable<HistoricItem> getAllStatesBetween(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end) {
        return PersistenceExtensions.getAllStatesBetween(item, begin, end, PersistenceExtensions.getDefaultServiceId());
    }

    public static Iterable<HistoricItem> getAllStatesBetween(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end, String serviceId) {
        PersistenceService service = PersistenceExtensions.getService(serviceId);
        if (service instanceof QueryablePersistenceService var5_6) {
            FilterCriteria filter = new FilterCriteria();
            filter.setBeginDate(begin);
            if (end != null) {
                filter.setEndDate(end);
            }
            filter.setItemName(item.getName());
            filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
            return qService.query(filter);
        }
        LoggerFactory.getLogger(PersistenceExtensions.class).warn("There is no queryable persistence service registered with the id '{}'", (Object)serviceId);
        return List.of();
    }

    private static Iterable<HistoricItem> getAllStatesBetweenWithBoundaries(Item item, ZonedDateTime begin, @Nullable ZonedDateTime end, String serviceId) {
        HistoricItem last;
        HistoricItem first;
        Iterable<HistoricItem> betweenItems = PersistenceExtensions.getAllStatesBetween(item, begin, end, serviceId);
        ArrayList<HistoricItem> betweenItemsList = new ArrayList<HistoricItem>();
        for (HistoricItem historicItem : betweenItems) {
            betweenItemsList.add(historicItem);
        }
        if (!(!betweenItemsList.isEmpty() && ((HistoricItem)betweenItemsList.get(0)).getTimestamp().equals(begin) || begin.isAfter(ZonedDateTime.now()) || (first = PersistenceExtensions.historicState(item, begin, serviceId)) == null)) {
            betweenItemsList.add(0, new RetimedHistoricItem(first, begin));
        }
        if (!(end == null || end.isAfter(ZonedDateTime.now()) || !betweenItemsList.isEmpty() && ((HistoricItem)betweenItemsList.get(betweenItemsList.size() - 1)).getTimestamp().equals(end) || (last = PersistenceExtensions.historicState(item, end, serviceId)) == null)) {
            betweenItemsList.add(new RetimedHistoricItem(last, end));
        }
        return betweenItemsList;
    }

    private static @Nullable HistoricItem historicItemOrCurrentState(final Item item, HistoricItem historicItem, DecimalType value) {
        if (historicItem == null && value != null) {
            return new HistoricItem(){

                @Override
                public ZonedDateTime getTimestamp() {
                    return ZonedDateTime.now();
                }

                @Override
                public State getState() {
                    return item.getState();
                }

                @Override
                public String getName() {
                    return item.getName();
                }
            };
        }
        return historicItem;
    }

    private static class RetimedHistoricItem
    implements HistoricItem {
        private final HistoricItem originItem;
        private final ZonedDateTime timestamp;

        public RetimedHistoricItem(HistoricItem originItem, ZonedDateTime timestamp) {
            this.originItem = originItem;
            this.timestamp = timestamp;
        }

        @Override
        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }

        @Override
        public State getState() {
            return this.originItem.getState();
        }

        @Override
        public String getName() {
            return this.originItem.getName();
        }

        public String toString() {
            return "RetimedHistoricItem [originItem=" + this.originItem + ", timestamp=" + this.timestamp + "]";
        }
    }
}

