/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.semantics.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemPredicates;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataRegistry;
import org.openhab.core.semantics.Equipment;
import org.openhab.core.semantics.Location;
import org.openhab.core.semantics.Point;
import org.openhab.core.semantics.SemanticTag;
import org.openhab.core.semantics.SemanticTagRegistry;
import org.openhab.core.semantics.SemanticsPredicates;
import org.openhab.core.semantics.SemanticsService;
import org.openhab.core.semantics.Tag;
import org.openhab.core.semantics.internal.SemanticTagRegistryImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component
public class SemanticsServiceImpl
implements SemanticsService {
    private static final String SYNONYMS_NAMESPACE = "synonyms";
    private final ItemRegistry itemRegistry;
    private final MetadataRegistry metadataRegistry;
    private final SemanticTagRegistry semanticTagRegistry;

    @Activate
    public SemanticsServiceImpl(@Reference ItemRegistry itemRegistry, @Reference MetadataRegistry metadataRegistry, @Reference SemanticTagRegistry semanticTagRegistry) {
        this.itemRegistry = itemRegistry;
        this.metadataRegistry = metadataRegistry;
        this.semanticTagRegistry = semanticTagRegistry;
    }

    @Override
    public Set<Item> getItemsInLocation(Class<? extends Location> locationType) {
        HashSet<Item> items = new HashSet<Item>();
        Set locationItems = this.itemRegistry.stream().filter(SemanticsPredicates.isA(locationType)).collect(Collectors.toSet());
        for (Item locationItem : locationItems) {
            if (!(locationItem instanceof GroupItem var6_6)) continue;
            items.addAll(gItem.getMembers(SemanticsPredicates.isA(Point.class).or(SemanticsPredicates.isA(Equipment.class))));
        }
        return items;
    }

    @Override
    public Set<Item> getItemsInLocation(String labelOrSynonym, Locale locale) {
        HashSet<Item> items = new HashSet<Item>();
        List<Class<? extends Tag>> tagList = this.getByLabelOrSynonym(labelOrSynonym, locale);
        if (!tagList.isEmpty()) {
            for (Class<? extends Tag> tag : tagList) {
                if (!Location.class.isAssignableFrom(tag)) continue;
                items.addAll(this.getItemsInLocation(tag));
            }
        } else {
            Set locationItems = this.itemRegistry.stream().filter(ItemPredicates.hasLabel((String)labelOrSynonym).or(this.hasSynonym(labelOrSynonym)).and(SemanticsPredicates.isLocation())).collect(Collectors.toSet());
            for (Item locationItem : locationItems) {
                if (!(locationItem instanceof GroupItem var8_10)) continue;
                items.addAll(gItem.getMembers(SemanticsPredicates.isA(Point.class).or(SemanticsPredicates.isA(Equipment.class))));
            }
        }
        return items;
    }

    private Predicate<? super Item> hasSynonym(String labelOrSynonym) {
        return item -> {
            MetadataKey key = new MetadataKey(SYNONYMS_NAMESPACE, item.getName());
            Metadata md = (Metadata)this.metadataRegistry.get((Object)key);
            if (md != null) {
                String[] synonyms;
                String[] stringArray = synonyms = md.getValue().split(",");
                int n = synonyms.length;
                int n2 = 0;
                while (n2 < n) {
                    String synonym = stringArray[n2];
                    if (synonym.equalsIgnoreCase(labelOrSynonym)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        };
    }

    @Override
    public @Nullable Class<? extends Tag> getByLabel(String tagLabel, Locale locale) {
        Optional<SemanticTag> tag = this.semanticTagRegistry.getAll().stream().filter(t -> t.localized(locale).getLabel().equalsIgnoreCase(tagLabel)).sorted(Comparator.comparing(Identifiable::getUID)).findFirst();
        return tag.isPresent() ? this.semanticTagRegistry.getTagClassById((String)tag.get().getUID()) : null;
    }

    @Override
    public List<Class<? extends Tag>> getByLabelOrSynonym(String tagLabelOrSynonym, Locale locale) {
        List<SemanticTag> tags = this.semanticTagRegistry.getAll().stream().filter(t -> this.getLabelAndSynonyms((SemanticTag)t, locale).contains(tagLabelOrSynonym.toLowerCase(locale))).sorted(Comparator.comparing(Identifiable::getUID)).toList();
        ArrayList<Class<? extends Tag>> tagList = new ArrayList<Class<? extends Tag>>();
        tags.forEach(t -> {
            Class<? extends Tag> tag = this.semanticTagRegistry.getTagClassById((String)t.getUID());
            if (tag != null) {
                tagList.add(tag);
            }
        });
        return tagList;
    }

    @Override
    public List<String> getLabelAndSynonyms(Class<? extends Tag> tagClass, Locale locale) {
        SemanticTag tag = (SemanticTag)this.semanticTagRegistry.get(SemanticTagRegistryImpl.buildId(tagClass));
        return tag == null ? List.of() : this.getLabelAndSynonyms(tag, locale);
    }

    private List<String> getLabelAndSynonyms(SemanticTag tag, Locale locale) {
        SemanticTag localizedTag = tag.localized(locale);
        Stream<String> label = Stream.of(localizedTag.getLabel());
        Stream synonyms = localizedTag.getSynonyms().stream();
        return Stream.concat(label, synonyms).map(s -> s.toLowerCase(locale)).distinct().toList();
    }
}

